/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.spring.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.elide.Elide;
import com.yahoo.elide.ElideMapper;
import com.yahoo.elide.ElideSettings;
import com.yahoo.elide.ElideSettingsBuilderCustomizer;
import com.yahoo.elide.ElideSettingsBuilderCustomizers;
import com.yahoo.elide.RefreshableElide;
import com.yahoo.elide.Serdes;
import com.yahoo.elide.SerdesBuilderCustomizer;
import com.yahoo.elide.Settings;
import com.yahoo.elide.async.AsyncSettings;
import com.yahoo.elide.async.AsyncSettingsBuilderCustomizer;
import com.yahoo.elide.async.AsyncSettingsBuilderCustomizers;
import com.yahoo.elide.async.models.AsyncQuery;
import com.yahoo.elide.async.models.TableExport;
import com.yahoo.elide.async.service.storageengine.ResultStorageEngine;
import com.yahoo.elide.core.TransactionRegistry;
import com.yahoo.elide.core.audit.AuditLogger;
import com.yahoo.elide.core.audit.Slf4jLogger;
import com.yahoo.elide.core.datastore.DataStore;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.dictionary.EntityDictionaryBuilderCustomizer;
import com.yahoo.elide.core.dictionary.Injector;
import com.yahoo.elide.core.exceptions.BasicExceptionMappers;
import com.yahoo.elide.core.exceptions.ExceptionLogger;
import com.yahoo.elide.core.exceptions.ExceptionMapper;
import com.yahoo.elide.core.exceptions.ExceptionMapperRegistration;
import com.yahoo.elide.core.exceptions.ExceptionMappers;
import com.yahoo.elide.core.exceptions.ExceptionMappersBuilderCustomizer;
import com.yahoo.elide.core.exceptions.Slf4jExceptionLogger;
import com.yahoo.elide.core.filter.dialect.RSQLFilterDialect;
import com.yahoo.elide.core.filter.dialect.jsonapi.JoinFilterDialect;
import com.yahoo.elide.core.filter.dialect.jsonapi.SubqueryFilterDialect;
import com.yahoo.elide.core.request.route.ApiVersionValidator;
import com.yahoo.elide.core.request.route.BasicApiVersionValidator;
import com.yahoo.elide.core.request.route.DelegatingRouteResolver;
import com.yahoo.elide.core.request.route.HeaderRouteResolver;
import com.yahoo.elide.core.request.route.MediaTypeProfileRouteResolver;
import com.yahoo.elide.core.request.route.NullRouteResolver;
import com.yahoo.elide.core.request.route.ParameterRouteResolver;
import com.yahoo.elide.core.request.route.PathRouteResolver;
import com.yahoo.elide.core.request.route.RouteResolver;
import com.yahoo.elide.core.security.checks.prefab.Role;
import com.yahoo.elide.core.type.ClassType;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.core.utils.ClassScanner;
import com.yahoo.elide.core.utils.DefaultClassScanner;
import com.yahoo.elide.core.utils.coerce.CoerceUtil;
import com.yahoo.elide.core.utils.coerce.converters.Serde;
import com.yahoo.elide.datastores.aggregation.AggregationDataStore;
import com.yahoo.elide.datastores.aggregation.DefaultQueryValidator;
import com.yahoo.elide.datastores.aggregation.QueryEngine;
import com.yahoo.elide.datastores.aggregation.QueryValidator;
import com.yahoo.elide.datastores.aggregation.cache.Cache;
import com.yahoo.elide.datastores.aggregation.cache.CaffeineCache;
import com.yahoo.elide.datastores.aggregation.core.QueryLogger;
import com.yahoo.elide.datastores.aggregation.core.Slf4jQueryLogger;
import com.yahoo.elide.datastores.aggregation.metadata.MetaDataStore;
import com.yahoo.elide.datastores.aggregation.query.DefaultQueryPlanMerger;
import com.yahoo.elide.datastores.aggregation.query.QueryPlanMerger;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.ConnectionDetails;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.DataSourceConfiguration;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.SQLQueryEngine;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.dialects.SQLDialectFactory;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.query.AggregateBeforeJoinOptimizer;
import com.yahoo.elide.datastores.aggregation.validator.TemplateConfigValidator;
import com.yahoo.elide.datastores.jpa.JpaDataStore;
import com.yahoo.elide.graphql.DefaultGraphQLErrorMapper;
import com.yahoo.elide.graphql.DefaultGraphQLExceptionHandler;
import com.yahoo.elide.graphql.GraphQLErrorMapper;
import com.yahoo.elide.graphql.GraphQLExceptionHandler;
import com.yahoo.elide.graphql.GraphQLSettings;
import com.yahoo.elide.graphql.GraphQLSettingsBuilderCustomizer;
import com.yahoo.elide.graphql.GraphQLSettingsBuilderCustomizers;
import com.yahoo.elide.graphql.QueryRunners;
import com.yahoo.elide.jsonapi.DefaultJsonApiErrorMapper;
import com.yahoo.elide.jsonapi.DefaultJsonApiExceptionHandler;
import com.yahoo.elide.jsonapi.JsonApi;
import com.yahoo.elide.jsonapi.JsonApiErrorMapper;
import com.yahoo.elide.jsonapi.JsonApiExceptionHandler;
import com.yahoo.elide.jsonapi.JsonApiMapper;
import com.yahoo.elide.jsonapi.JsonApiSettings;
import com.yahoo.elide.jsonapi.JsonApiSettingsBuilderCustomizer;
import com.yahoo.elide.jsonapi.JsonApiSettingsBuilderCustomizers;
import com.yahoo.elide.jsonapi.links.DefaultJsonApiLinks;
import com.yahoo.elide.jsonapi.links.JsonApiLinks;
import com.yahoo.elide.modelconfig.DBPasswordExtractor;
import com.yahoo.elide.modelconfig.DynamicConfiguration;
import com.yahoo.elide.modelconfig.store.ConfigDataStore;
import com.yahoo.elide.modelconfig.store.models.ConfigChecks;
import com.yahoo.elide.modelconfig.validator.DynamicConfigValidator;
import com.yahoo.elide.modelconfig.validator.Validator;
import com.yahoo.elide.spring.api.BasicOpenApiDocumentCustomizer;
import com.yahoo.elide.spring.api.DefaultElideGroupedOpenApiCustomizer;
import com.yahoo.elide.spring.api.DefaultElideOpenApiCustomizer;
import com.yahoo.elide.spring.api.ElideGroupedOpenApiCustomizer;
import com.yahoo.elide.spring.api.ElideOpenApiCustomizer;
import com.yahoo.elide.spring.api.OpenApiDocumentCustomizer;
import com.yahoo.elide.spring.config.AsyncProperties;
import com.yahoo.elide.spring.config.ElideConfigProperties;
import com.yahoo.elide.spring.controllers.ApiDocsController;
import com.yahoo.elide.spring.controllers.ExportController;
import com.yahoo.elide.spring.controllers.GraphqlController;
import com.yahoo.elide.spring.controllers.JsonApiController;
import com.yahoo.elide.spring.datastore.config.DataStoreBuilder;
import com.yahoo.elide.spring.datastore.config.DataStoreBuilderCustomizer;
import com.yahoo.elide.spring.jackson.ObjectMapperBuilder;
import com.yahoo.elide.spring.orm.jpa.config.EnableJpaDataStore;
import com.yahoo.elide.spring.orm.jpa.config.EnableJpaDataStores;
import com.yahoo.elide.spring.orm.jpa.config.JpaDataStoreRegistration;
import com.yahoo.elide.spring.orm.jpa.config.JpaDataStoreRegistrations;
import com.yahoo.elide.spring.orm.jpa.config.JpaDataStoreRegistrationsBuilder;
import com.yahoo.elide.spring.orm.jpa.config.JpaDataStoreRegistrationsBuilderCustomizer;
import com.yahoo.elide.swagger.OpenApiBuilder;
import com.yahoo.elide.utils.HeaderProcessor;
import com.yahoo.elide.utils.Headers;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.SimpleDataFetcherExceptionHandler;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.cache.CaffeineCacheMetrics;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.servers.Server;
import jakarta.persistence.EntityManagerFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.customizers.OpenApiCustomizer;
import org.springdoc.core.models.GroupedOpenApi;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.transaction.TransactionAutoConfiguration;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.core.annotation.Order;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.function.SingletonSupplier;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@Configuration
@AutoConfigureAfter(value={TransactionAutoConfiguration.class})
@EnableConfigurationProperties(value={ElideConfigProperties.class})
public class ElideAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ElideAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public AuditLogger auditLogger() {
        return new Slf4jLogger();
    }

    @Bean
    @ConditionalOnMissingBean
    @Scope(value="prototype")
    public ElideSettings.ElideSettingsBuilder elideSettingsBuilder(ElideConfigProperties settings, EntityDictionary entityDictionary, DataStore dataStore, HeaderProcessor headerProcessor, ElideMapper elideMapper, AuditLogger auditLogger, Serdes.SerdesBuilder serdesBuilder, ObjectProvider<Settings.SettingsBuilder> settingsProvider, ObjectProvider<ElideSettingsBuilderCustomizer> customizerProvider) {
        return ElideSettingsBuilderCustomizers.buildElideSettingsBuilder(builder -> {
            ((ElideSettings.ElideSettingsBuilder)((ElideSettings.ElideSettingsBuilder)((ElideSettings.ElideSettingsBuilder)((ElideSettings.ElideSettingsBuilder)((ElideSettings.ElideSettingsBuilder)((ElideSettings.ElideSettingsBuilder)((ElideSettings.ElideSettingsBuilder)((ElideSettings.ElideSettingsBuilder)builder.dataStore(dataStore)).entityDictionary(entityDictionary)).objectMapper(elideMapper.getObjectMapper())).maxPageSize(settings.getMaxPageSize())).defaultPageSize(settings.getDefaultPageSize())).auditLogger(auditLogger)).baseUrl(settings.getBaseUrl())).serdes(serdes -> serdes.entries(entries -> {
                entries.clear();
                serdesBuilder.build().entrySet().stream().forEach(entry -> entries.put((Class)entry.getKey(), (Serde)entry.getValue()));
            }))).headerProcessor(headerProcessor);
            if (settings.isVerboseErrors()) {
                builder.verboseErrors(true);
            }
            settingsProvider.orderedStream().forEach(xva$0 -> {
                ElideSettings.ElideSettingsBuilder cfr_ignored_0 = (ElideSettings.ElideSettingsBuilder)builder.settings(new Settings.SettingsBuilder[]{xva$0});
            });
            customizerProvider.orderedStream().forEach(customizer -> customizer.customize(builder));
        });
    }

    @Bean
    @ConditionalOnMissingBean
    @Scope(value="prototype")
    public Serdes.SerdesBuilder serdesBuilder(ObjectProvider<SerdesBuilderCustomizer> customizerProvider) {
        Serdes.SerdesBuilder builder = (Serdes.SerdesBuilder)((Serdes.SerdesBuilder)Serdes.builder().withDefaults()).withISO8601Dates("yyyy-MM-dd'T'HH:mm'Z'", TimeZone.getTimeZone("UTC"));
        customizerProvider.orderedStream().forEach(customizer -> customizer.customize(builder));
        return builder;
    }

    @Bean
    @ConditionalOnMissingBean
    @Scope(value="prototype")
    public EntityDictionary.EntityDictionaryBuilder entityDictionaryBuilder(Injector injector, ClassScanner scanner, Optional<DynamicConfiguration> optionalDynamicConfig, ElideConfigProperties settings, @Qualifier(value="entitiesToExclude") Set<Type<?>> entitiesToExclude, ObjectProvider<EntityDictionaryBuilderCustomizer> customizerProvider) {
        EntityDictionary.EntityDictionaryBuilder builder = EntityDictionary.builder();
        HashMap<String, Class> checks = new HashMap<String, Class>();
        if (settings.getAggregationStore().getDynamicConfig().getConfigApi().isEnabled()) {
            checks.put("Can Create Config", ConfigChecks.CanNotCreate.class);
            checks.put("Can Read Config", ConfigChecks.CanNotRead.class);
            checks.put("Can Delete Config", ConfigChecks.CanNotDelete.class);
            checks.put("Can Update Config", ConfigChecks.CanNotUpdate.class);
        }
        HashMap roleChecks = new HashMap();
        if (ElideAutoConfiguration.isAggregationStoreEnabled(settings) && ElideAutoConfiguration.isDynamicConfigEnabled(settings)) {
            optionalDynamicConfig.ifPresent(dynamicConfig -> dynamicConfig.getRoles().forEach(role -> roleChecks.put(role, new Role.RoleMemberCheck(role))));
        }
        builder.checks(checks).roleChecks(roleChecks).injector(injector).serdeLookup(CoerceUtil::lookup).entitiesToExclude(entitiesToExclude).scanner(scanner);
        customizerProvider.orderedStream().forEach(customizer -> customizer.customize(builder));
        return builder;
    }

    @Bean
    @ConditionalOnMissingBean
    public ApiVersionValidator apiVersionValidator() {
        return new BasicApiVersionValidator();
    }

    @Bean
    @ConditionalOnMissingBean
    public RouteResolver routeResolver(RefreshableElide refreshableElide, ElideConfigProperties settings, ApiVersionValidator apiVersionValidator) {
        Set apiVersions = refreshableElide.getElide().getElideSettings().getEntityDictionary().getApiVersions();
        if (apiVersions.size() == 1 && apiVersions.contains("")) {
            return new NullRouteResolver();
        }
        ArrayList<Object> routeResolvers = new ArrayList<Object>();
        if (settings.getApiVersioningStrategy().getPath().isEnabled()) {
            routeResolvers.add(new PathRouteResolver(settings.getApiVersioningStrategy().getPath().getVersionPrefix(), apiVersionValidator));
        }
        if (settings.getApiVersioningStrategy().getHeader().isEnabled()) {
            routeResolvers.add(new HeaderRouteResolver(settings.getApiVersioningStrategy().getHeader().getHeaderName()));
        }
        if (settings.getApiVersioningStrategy().getParameter().isEnabled()) {
            routeResolvers.add(new ParameterRouteResolver(settings.getApiVersioningStrategy().getParameter().getParameterName(), apiVersionValidator));
        }
        if (settings.getApiVersioningStrategy().getMediaTypeProfile().isEnabled()) {
            routeResolvers.add(new MediaTypeProfileRouteResolver(settings.getApiVersioningStrategy().getMediaTypeProfile().getVersionPrefix(), apiVersionValidator, () -> {
                if (!settings.getApiVersioningStrategy().getMediaTypeProfile().getUriPrefix().isBlank()) {
                    return settings.getApiVersioningStrategy().getMediaTypeProfile().getUriPrefix();
                }
                String baseUrl = refreshableElide.getElide().getElideSettings().getBaseUrl();
                if (StringUtils.isEmpty((CharSequence)baseUrl)) {
                    baseUrl = ServletUriComponentsBuilder.fromCurrentContextPath().path("").build().toUriString();
                }
                return baseUrl;
            }));
        }
        if (!routeResolvers.isEmpty()) {
            return new DelegatingRouteResolver(routeResolvers);
        }
        return new NullRouteResolver();
    }

    @Bean
    @ConditionalOnMissingBean
    public TransactionRegistry transactionRegistry() {
        return new TransactionRegistry();
    }

    @Bean
    @ConditionalOnMissingBean
    public HeaderProcessor headerProcessor(ElideConfigProperties settings) {
        if (settings.isStripAuthorizationHeaders()) {
            return Headers::removeAuthorizationHeaders;
        }
        return headers -> headers;
    }

    @Bean(name={"entitiesToExclude"})
    @ConditionalOnMissingBean
    public Set<Type<?>> entitiesToExclude(ElideConfigProperties settings) {
        boolean exportEnabled;
        HashSet entitiesToExclude = new HashSet();
        AsyncProperties asyncProperties = settings.getAsync();
        if (asyncProperties == null || !asyncProperties.isEnabled()) {
            entitiesToExclude.add((Type<?>)ClassType.of(AsyncQuery.class));
        }
        if (!(exportEnabled = ElideAutoConfiguration.isExportEnabled(asyncProperties))) {
            entitiesToExclude.add((Type<?>)ClassType.of(TableExport.class));
        }
        return entitiesToExclude;
    }

    @Bean
    @ConditionalOnMissingBean
    @Scope(value="prototype")
    public Injector injector(final AutowireCapableBeanFactory beanFactory) {
        return new Injector(){

            public void inject(Object entity) {
                beanFactory.autowireBean(entity);
            }

            public <T> T instantiate(Class<T> cls) {
                return (T)beanFactory.createBean(cls);
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean
    @Scope(value="prototype")
    public JpaDataStoreRegistrationsBuilder jpaDataStoreRegistrationsBuilder(ApplicationContext applicationContext, ElideConfigProperties settings, Optional<com.yahoo.elide.datastores.jpql.porting.QueryLogger> optionalQueryLogger, ObjectProvider<JpaDataStoreRegistrationsBuilderCustomizer> customizerProviders) {
        JpaDataStoreRegistrationsBuilder builder = new JpaDataStoreRegistrationsBuilder();
        String[] entityManagerFactoryNames = applicationContext.getBeanNamesForType(EntityManagerFactory.class);
        String[] platformTransactionManagerNames = applicationContext.getBeanNamesForType(PlatformTransactionManager.class);
        HashMap beans = new HashMap();
        beans.putAll(applicationContext.getBeansWithAnnotation(EnableJpaDataStore.class));
        beans.putAll(applicationContext.getBeansWithAnnotation(EnableJpaDataStores.class));
        if (!beans.isEmpty()) {
            beans.values().stream().forEach(bean -> {
                EnableJpaDataStore[] annotations;
                for (EnableJpaDataStore annotation : annotations = (EnableJpaDataStore[])bean.getClass().getAnnotationsByType(EnableJpaDataStore.class)) {
                    String entityManagerFactoryName = annotation.entityManagerFactoryRef();
                    String platformTransactionManagerName = annotation.transactionManagerRef();
                    if (StringUtils.isBlank((CharSequence)entityManagerFactoryName) || StringUtils.isBlank((CharSequence)platformTransactionManagerName)) continue;
                    builder.add(this.buildJpaDataStoreRegistration(applicationContext, entityManagerFactoryName, platformTransactionManagerName, settings, optionalQueryLogger, annotation.managedClasses()));
                }
            });
        } else if (entityManagerFactoryNames.length == 1 && platformTransactionManagerNames.length == 1) {
            String platformTransactionManagerName = platformTransactionManagerNames[0];
            String entityManagerFactoryName = entityManagerFactoryNames[0];
            builder.add(this.buildJpaDataStoreRegistration(applicationContext, entityManagerFactoryName, platformTransactionManagerName, settings, optionalQueryLogger, new Class[0]));
        }
        customizerProviders.orderedStream().forEach(customizer -> customizer.customize(builder));
        return builder;
    }

    @Bean
    @ConditionalOnMissingBean
    @Scope(value="prototype")
    public DataStoreBuilder dataStoreBuilder(JpaDataStoreRegistrationsBuilder builder, ElideConfigProperties settings, ClassScanner scanner, Optional<QueryEngine> optionalQueryEngine, Optional<Cache> optionalCache, Optional<QueryLogger> optionalQueryLogger, ObjectProvider<DataStoreBuilderCustomizer> customizerProvider) {
        return ElideAutoConfiguration.buildDataStoreBuilder(builder, settings, scanner, optionalQueryEngine, optionalCache, optionalQueryLogger, Optional.of(dataStoreBuilder -> customizerProvider.orderedStream().forEach(customizer -> customizer.customize(dataStoreBuilder))));
    }

    @Bean
    @ConditionalOnMissingBean
    @Scope(value="prototype")
    public DataStore dataStore(DataStoreBuilder dataStoreBuilder) {
        return dataStoreBuilder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    public ClassScanner classScanner() {
        return new DefaultClassScanner();
    }

    @Bean
    @ConditionalOnMissingBean
    @Scope(value="prototype")
    public ExceptionMappers.ExceptionMappersBuilder exceptionMappersBuilder(ObjectProvider<ExceptionMapperRegistration> exceptionMapperRegistrationProvider, ObjectProvider<ExceptionMapper<?, ?>> exceptionMapperProvider, ObjectProvider<ExceptionMappersBuilderCustomizer> customizerProvider) {
        BasicExceptionMappers.BasicExceptionMappersBuilder exceptionMappersBuilder = BasicExceptionMappers.builder();
        exceptionMapperRegistrationProvider.orderedStream().forEach(arg_0 -> ((ExceptionMappers.ExceptionMappersBuilder)exceptionMappersBuilder).register(arg_0));
        exceptionMapperProvider.orderedStream().forEach(arg_0 -> ((ExceptionMappers.ExceptionMappersBuilder)exceptionMappersBuilder).register(arg_0));
        customizerProvider.orderedStream().forEach(arg_0 -> ElideAutoConfiguration.lambda$exceptionMappersBuilder$16((ExceptionMappers.ExceptionMappersBuilder)exceptionMappersBuilder, arg_0));
        return exceptionMappersBuilder;
    }

    @Bean
    @ConditionalOnMissingBean
    public ExceptionMappers exceptionMapper(ExceptionMappers.ExceptionMappersBuilder exceptionMappersBuilder) {
        return exceptionMappersBuilder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    public ExceptionLogger exceptionLogger() {
        return new Slf4jExceptionLogger();
    }

    @Bean
    @ConditionalOnMissingBean
    @Scope(value="prototype")
    public ObjectMapperBuilder objectMapperBuilder(Optional<Jackson2ObjectMapperBuilder> optionalJackson2ObjectMapperBuilder) {
        if (optionalJackson2ObjectMapperBuilder.isPresent()) {
            return () -> ((Jackson2ObjectMapperBuilder)optionalJackson2ObjectMapperBuilder.get()).build();
        }
        return ObjectMapper::new;
    }

    @Bean
    @ConditionalOnMissingBean
    public ElideMapper elideMapper(ObjectMapperBuilder builder) {
        return new ElideMapper(builder.build());
    }

    public static RefreshableElide buildRefreshableElide(ElideSettings.ElideSettingsBuilder elideSettingsBuilder, EntityDictionary dictionary, TransactionRegistry transactionRegistry) {
        Elide elide = new Elide(elideSettingsBuilder.build(), transactionRegistry, dictionary.getScanner(), true);
        return new RefreshableElide(elide);
    }

    public static ApiDocsController.ApiDocsRegistrations buildApiDocsRegistrations(RefreshableElide elide, ElideConfigProperties settings, String contextPath, OpenApiDocumentCustomizer customizer) {
        String jsonApiPath = settings.getJsonApi() != null ? settings.getJsonApi().getPath() : "";
        EntityDictionary dictionary = elide.getElide().getElideSettings().getEntityDictionary();
        ArrayList<ApiDocsController.ApiDocsRegistration> registrations = new ArrayList<ApiDocsController.ApiDocsRegistration>();
        dictionary.getApiVersions().stream().forEach(apiVersion -> {
            Supplier<OpenAPI> document = () -> {
                OpenApiBuilder builder = new OpenApiBuilder(dictionary).apiVersion(apiVersion).supportLegacyFilterDialect(false);
                if (!"".equals(apiVersion)) {
                    if (settings.getApiVersioningStrategy().getPath().isEnabled()) {
                        builder.basePath("/" + settings.getApiVersioningStrategy().getPath().getVersionPrefix() + apiVersion);
                    } else if (settings.getApiVersioningStrategy().getHeader().isEnabled()) {
                        builder.globalParameter(new Parameter().in("header").name(settings.getApiVersioningStrategy().getHeader().getHeaderName()[0]).required(Boolean.valueOf(true)).schema((Schema)new StringSchema().addEnumItem(apiVersion)));
                    } else if (settings.getApiVersioningStrategy().getParameter().isEnabled()) {
                        builder.globalParameter(new Parameter().in("query").name(settings.getApiVersioningStrategy().getParameter().getParameterName()).required(Boolean.valueOf(true)).schema((Schema)new StringSchema().addEnumItem(apiVersion)));
                    }
                }
                Object url = contextPath != null ? contextPath : "";
                if (((String)(url = (String)url + jsonApiPath)).isBlank()) {
                    url = "/";
                }
                OpenAPI openApi = builder.build();
                openApi.addServersItem(new Server().url((String)url));
                if (!"".equals(apiVersion)) {
                    Info info = openApi.getInfo();
                    if (info == null) {
                        info = new Info();
                        openApi.setInfo(info);
                    }
                    info.setVersion(apiVersion);
                }
                customizer.customize(openApi);
                return openApi;
            };
            registrations.add(new ApiDocsController.ApiDocsRegistration("", (Supplier<OpenAPI>)SingletonSupplier.of(document), settings.getApiDocs().getVersion().getValue(), (String)apiVersion));
        });
        return new ApiDocsController.ApiDocsRegistrations(registrations);
    }

    public static DataStoreBuilder buildDataStoreBuilder(JpaDataStoreRegistrationsBuilder builder, ElideConfigProperties settings, ClassScanner scanner, Optional<QueryEngine> optionalQueryEngine, Optional<Cache> optionalCache, Optional<QueryLogger> optionalQueryLogger, Optional<DataStoreBuilderCustomizer> optionalCustomizer) {
        DataStoreBuilder dataStoreBuilder = new DataStoreBuilder();
        builder.build().forEach(registration -> {
            if (registration.getManagedClasses() != null && !registration.getManagedClasses().isEmpty()) {
                dataStoreBuilder.dataStore((DataStore)new JpaDataStore(registration.getEntityManagerSupplier(), registration.getReadTransactionSupplier(), registration.getWriteTransactionSupplier(), registration.getQueryLogger(), (Type[])registration.getManagedClasses().toArray(Type[]::new)));
            } else {
                dataStoreBuilder.dataStore((DataStore)new JpaDataStore(registration.getEntityManagerSupplier(), registration.getReadTransactionSupplier(), registration.getWriteTransactionSupplier(), registration.getQueryLogger(), registration.getMetamodelSupplier()));
            }
        });
        if (ElideAutoConfiguration.isAggregationStoreEnabled(settings)) {
            AggregationDataStore.AggregationDataStoreBuilder aggregationDataStoreBuilder = AggregationDataStore.builder();
            optionalQueryEngine.ifPresent(arg_0 -> ((AggregationDataStore.AggregationDataStoreBuilder)aggregationDataStoreBuilder).queryEngine(arg_0));
            if (ElideAutoConfiguration.isDynamicConfigEnabled(settings)) {
                optionalQueryEngine.ifPresent(queryEngine -> aggregationDataStoreBuilder.dynamicCompiledClasses(queryEngine.getMetaDataStore().getDynamicTypes()));
                if (settings.getAggregationStore().getDynamicConfig().getConfigApi().isEnabled()) {
                    dataStoreBuilder.dataStore((DataStore)new ConfigDataStore(settings.getAggregationStore().getDynamicConfig().getPath(), (Validator)new TemplateConfigValidator(scanner, settings.getAggregationStore().getDynamicConfig().getPath())));
                }
            }
            optionalCache.ifPresent(arg_0 -> ((AggregationDataStore.AggregationDataStoreBuilder)aggregationDataStoreBuilder).cache(arg_0));
            optionalQueryLogger.ifPresent(arg_0 -> ((AggregationDataStore.AggregationDataStoreBuilder)aggregationDataStoreBuilder).queryLogger(arg_0));
            AggregationDataStore aggregationDataStore = aggregationDataStoreBuilder.build();
            optionalQueryEngine.ifPresent(queryEngine -> dataStoreBuilder.dataStore((DataStore)queryEngine.getMetaDataStore()));
            dataStoreBuilder.dataStore((DataStore)aggregationDataStore);
        }
        optionalCustomizer.ifPresent(customizer -> customizer.customize(dataStoreBuilder));
        return dataStoreBuilder;
    }

    private JpaDataStoreRegistration buildJpaDataStoreRegistration(ApplicationContext applicationContext, String entityManagerFactoryName, String platformTransactionManagerName, ElideConfigProperties settings, Optional<com.yahoo.elide.datastores.jpql.porting.QueryLogger> optionalQueryLogger, Class<?>[] managedClasses) {
        PlatformTransactionManager platformTransactionManager = (PlatformTransactionManager)applicationContext.getBean(platformTransactionManagerName, PlatformTransactionManager.class);
        EntityManagerFactory entityManagerFactory = (EntityManagerFactory)applicationContext.getBean(entityManagerFactoryName, EntityManagerFactory.class);
        return JpaDataStoreRegistrations.buildJpaDataStoreRegistration(entityManagerFactoryName, entityManagerFactory, platformTransactionManagerName, platformTransactionManager, settings, optionalQueryLogger, managedClasses);
    }

    public static boolean isDynamicConfigEnabled(ElideConfigProperties settings) {
        boolean enabled = false;
        if (settings.getAggregationStore() != null && settings.getAggregationStore().getDynamicConfig() != null) {
            enabled = settings.getAggregationStore().getDynamicConfig().isEnabled();
        }
        return enabled;
    }

    public static boolean isAggregationStoreEnabled(ElideConfigProperties settings) {
        boolean enabled = false;
        if (settings.getAggregationStore() != null) {
            enabled = settings.getAggregationStore().isEnabled();
        }
        return enabled;
    }

    public static boolean isExportEnabled(AsyncProperties asyncProperties) {
        return asyncProperties != null && asyncProperties.getExport() != null && asyncProperties.getExport().isEnabled();
    }

    private static /* synthetic */ void lambda$exceptionMappersBuilder$16(ExceptionMappers.ExceptionMappersBuilder exceptionMappersBuilder, ExceptionMappersBuilderCustomizer customizer) {
        customizer.customize(exceptionMappersBuilder);
    }

    @Configuration
    @ConditionalOnProperty(name={"elide.aggregation-store.enabled"}, havingValue="true")
    public static class AggregationStoreConfiguration {
        @Bean
        @Scope(value="prototype")
        @ConditionalOnMissingBean
        @ConditionalOnProperty(name={"elide.aggregation-store.dynamic-config.enabled"}, havingValue="true")
        public DynamicConfiguration dynamicConfiguration(ClassScanner scanner, ElideConfigProperties settings) throws IOException {
            DynamicConfigValidator validator = new DynamicConfigValidator(scanner, settings.getAggregationStore().getDynamicConfig().getPath());
            validator.readAndValidateConfigs();
            return validator;
        }

        @Bean
        @ConditionalOnMissingBean
        public DBPasswordExtractor dbPasswordExtractor() {
            return config -> "";
        }

        @Bean
        @ConditionalOnMissingBean
        public DataSourceConfiguration dataSourceConfiguration() {
            return new DataSourceConfiguration(){};
        }

        @Bean
        @ConditionalOnMissingBean
        @Scope(value="prototype")
        public QueryEngine queryEngine(DataSource defaultDataSource, Optional<DynamicConfiguration> optionalDynamicConfig, ElideConfigProperties settings, ClassScanner scanner, DataSourceConfiguration dataSourceConfiguration, DBPasswordExtractor dbPasswordExtractor) {
            boolean enableMetaDataStore = settings.getAggregationStore().getMetadataStore().isEnabled();
            ConnectionDetails defaultConnectionDetails = new ConnectionDetails(defaultDataSource, SQLDialectFactory.getDialect((String)settings.getAggregationStore().getDefaultDialect()));
            if (ElideAutoConfiguration.isDynamicConfigEnabled(settings) && optionalDynamicConfig.isPresent()) {
                DynamicConfiguration dynamicConfig = optionalDynamicConfig.get();
                MetaDataStore metaDataStore = new MetaDataStore(scanner, (Collection)dynamicConfig.getTables(), (Collection)dynamicConfig.getNamespaceConfigurations(), enableMetaDataStore);
                HashMap connectionDetailsMap = new HashMap();
                dynamicConfig.getDatabaseConfigurations().forEach(dbConfig -> connectionDetailsMap.put(dbConfig.getName(), new ConnectionDetails(dataSourceConfiguration.getDataSource(dbConfig, dbPasswordExtractor), SQLDialectFactory.getDialect((String)dbConfig.getDialect()))));
                Function<String, ConnectionDetails> connectionDetailsLookup = name -> {
                    if (StringUtils.isEmpty((CharSequence)name)) {
                        return defaultConnectionDetails;
                    }
                    return Optional.ofNullable((ConnectionDetails)connectionDetailsMap.get(name)).orElseThrow(() -> new IllegalStateException("ConnectionDetails undefined for connection: " + name));
                };
                return new SQLQueryEngine(metaDataStore, connectionDetailsLookup, new HashSet<AggregateBeforeJoinOptimizer>(Arrays.asList(new AggregateBeforeJoinOptimizer(metaDataStore))), (QueryPlanMerger)new DefaultQueryPlanMerger(metaDataStore), (QueryValidator)new DefaultQueryValidator(metaDataStore.getMetadataDictionary()));
            }
            MetaDataStore metaDataStore = new MetaDataStore(scanner, enableMetaDataStore);
            return new SQLQueryEngine(metaDataStore, unused -> defaultConnectionDetails);
        }

        @Bean
        @ConditionalOnMissingBean
        public Cache queryCache(ElideConfigProperties settings, Optional<MeterRegistry> optionalMeterRegistry) {
            int maxCacheItems = settings.getAggregationStore().getQueryCache().getMaxSize();
            if (settings.getAggregationStore().getQueryCache().isEnabled() && maxCacheItems > 0) {
                CaffeineCache cache = new CaffeineCache(maxCacheItems, settings.getAggregationStore().getQueryCache().getExpiration());
                optionalMeterRegistry.ifPresent(meterRegistry -> CaffeineCacheMetrics.monitor((MeterRegistry)meterRegistry, (com.github.benmanes.caffeine.cache.Cache)cache.getImplementation(), (String)"elideQueryCache", (String[])new String[0]));
                return cache;
            }
            return null;
        }

        @Bean
        @ConditionalOnMissingBean
        public QueryLogger queryLogger() {
            return new Slf4jQueryLogger();
        }
    }

    @Configuration
    @ConditionalOnProperty(name={"elide.async.enabled"}, havingValue="true")
    @ConditionalOnClass(value={AsyncSettings.AsyncSettingsBuilder.class})
    public static class AsyncConfiguration {
        @Bean
        @ConditionalOnMissingBean
        @Scope(value="prototype")
        public AsyncSettings.AsyncSettingsBuilder asyncSettingsBuilder(ElideConfigProperties settings, ObjectProvider<AsyncSettingsBuilderCustomizer> customizerProviders) {
            return AsyncSettingsBuilderCustomizers.buildAsyncSettingsBuilder(builder -> {
                builder.export(export -> export.enabled(settings.getAsync().getExport().isEnabled()).path(settings.getAsync().getExport().getPath()));
                customizerProviders.orderedStream().forEach(customizer -> customizer.customize(builder));
            });
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(name={"elide.async.export.enabled"}, havingValue="true")
        public ExportController exportController(ResultStorageEngine resultStorageEngine) {
            return new ExportController(resultStorageEngine);
        }
    }

    @Configuration
    @ConditionalOnProperty(name={"elide.jsonapi.enabled"}, havingValue="true")
    @ConditionalOnClass(value={JsonApiSettings.JsonApiSettingsBuilder.class})
    public static class JsonApiConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public JsonApiErrorMapper jsonApiErrorMapper() {
            return new DefaultJsonApiErrorMapper();
        }

        @Bean
        @ConditionalOnMissingBean
        public JsonApiExceptionHandler jsonApiExceptionHandler(ExceptionLogger exceptionLogger, ExceptionMappers exceptionMappers, JsonApiErrorMapper jsonApiErrorMapper) {
            return new DefaultJsonApiExceptionHandler(exceptionLogger, exceptionMappers, jsonApiErrorMapper);
        }

        @Bean
        @ConditionalOnMissingBean
        @Scope(value="prototype")
        public JsonApiSettings.JsonApiSettingsBuilder jsonApiSettingsBuilder(ElideConfigProperties settings, EntityDictionary entityDictionary, JsonApiMapper jsonApiMapper, JsonApiExceptionHandler jsonApiExceptionHandler, ObjectProvider<JsonApiSettingsBuilderCustomizer> customizerProviders) {
            return JsonApiSettingsBuilderCustomizers.buildJsonApiSettingsBuilder((EntityDictionary)entityDictionary, builder -> {
                ((JsonApiSettings.JsonApiSettingsBuilder)((JsonApiSettings.JsonApiSettingsBuilder)((JsonApiSettings.JsonApiSettingsBuilder)((JsonApiSettings.JsonApiSettingsBuilder)builder.path(settings.getJsonApi().getPath())).joinFilterDialect((JoinFilterDialect)RSQLFilterDialect.builder().dictionary(entityDictionary).build())).subqueryFilterDialect((SubqueryFilterDialect)RSQLFilterDialect.builder().dictionary(entityDictionary).build())).jsonApiMapper(jsonApiMapper)).jsonApiExceptionHandler(jsonApiExceptionHandler);
                if (settings.getJsonApi().getLinks().isEnabled()) {
                    String baseUrl = settings.getBaseUrl();
                    builder.links(links -> links.enabled(true));
                    if (StringUtils.isEmpty((CharSequence)baseUrl)) {
                        builder.links(links -> links.jsonApiLinks((JsonApiLinks)new DefaultJsonApiLinks()));
                    } else {
                        String jsonApiBaseUrl = baseUrl + settings.getJsonApi().getPath() + "/";
                        builder.links(links -> links.jsonApiLinks((JsonApiLinks)new DefaultJsonApiLinks(jsonApiBaseUrl)));
                    }
                }
                customizerProviders.orderedStream().forEach(customizer -> customizer.customize(builder));
            });
        }

        @Bean
        @ConditionalOnMissingBean
        public JsonApiMapper jsonApiMapper(ElideMapper elideMapper) {
            return new JsonApiMapper(elideMapper.getObjectMapper());
        }
    }

    @Configuration
    @ConditionalOnProperty(name={"elide.graphql.enabled"}, havingValue="true")
    @ConditionalOnClass(value={GraphQLSettings.GraphQLSettingsBuilder.class})
    public static class GraphQLConfiguration {
        @Bean
        @ConditionalOnMissingBean
        @Scope(value="prototype")
        public DataFetcherExceptionHandler dataFetcherExceptionHandler() {
            return new SimpleDataFetcherExceptionHandler();
        }

        @Bean
        @ConditionalOnMissingBean
        public GraphQLErrorMapper graphqlErrorMapper() {
            return new DefaultGraphQLErrorMapper();
        }

        @Bean
        @ConditionalOnMissingBean
        public GraphQLExceptionHandler graphqlExceptionHandler(ExceptionLogger exceptionLogger, ExceptionMappers exceptionMappers, GraphQLErrorMapper graphqlErrorMapper) {
            return new DefaultGraphQLExceptionHandler(exceptionLogger, exceptionMappers, graphqlErrorMapper);
        }

        @Bean
        @ConditionalOnMissingBean
        @Scope(value="prototype")
        public GraphQLSettings.GraphQLSettingsBuilder graphqlSettingsBuilder(ElideConfigProperties settings, EntityDictionary entityDictionary, GraphQLExceptionHandler graphqlExceptionHandler, ObjectProvider<GraphQLSettingsBuilderCustomizer> customizerProviders) {
            return GraphQLSettingsBuilderCustomizers.buildGraphQLSettingsBuilder((EntityDictionary)entityDictionary, builder -> {
                ((GraphQLSettings.GraphQLSettingsBuilder)((GraphQLSettings.GraphQLSettingsBuilder)builder.path(settings.getGraphql().getPath())).federation(federation -> federation.enabled(settings.getGraphql().getFederation().isEnabled()).version(settings.getGraphql().getFederation().getVersion().getValue()))).graphqlExceptionHandler(graphqlExceptionHandler);
                customizerProviders.orderedStream().forEach(customizer -> customizer.customize(builder));
            });
        }
    }

    @Configuration
    @ConditionalOnProperty(name={"spring.cloud.refresh.enabled"}, havingValue="false", matchIfMissing=true)
    @Order(value=0x7FFFFFFF)
    public static class NonRefreshableConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public EntityDictionary entityDictionary(EntityDictionary.EntityDictionaryBuilder entityDictionaryBuilder) {
            return entityDictionaryBuilder.build();
        }

        @Bean
        @ConditionalOnMissingBean
        public RefreshableElide refreshableElide(ElideSettings.ElideSettingsBuilder elideSettingsBuilder, EntityDictionary dictionary, TransactionRegistry transactionRegistry) {
            return ElideAutoConfiguration.buildRefreshableElide(elideSettingsBuilder, dictionary, transactionRegistry);
        }

        @Configuration
        @ConditionalOnProperty(name={"elide.graphql.enabled"}, havingValue="true")
        @ConditionalOnClass(value={GraphQLSettings.GraphQLSettingsBuilder.class})
        public static class GraphQLConfiguration {
            @Bean
            @ConditionalOnMissingBean
            public QueryRunners queryRunners(RefreshableElide refreshableElide, DataFetcherExceptionHandler exceptionHandler) {
                return new QueryRunners(refreshableElide, exceptionHandler);
            }

            @Bean
            @ConditionalOnMissingBean(name={"graphqlController"})
            public GraphqlController graphqlController(RefreshableElide refreshableElide, QueryRunners runners, ElideMapper elideMapper, HeaderProcessor headerProcessor, ElideConfigProperties settings, RouteResolver routeResolver) {
                return new GraphqlController(refreshableElide.getElide(), runners, headerProcessor, settings, routeResolver);
            }
        }

        @Configuration
        @ConditionalOnProperty(name={"elide.api-docs.enabled"}, havingValue="true")
        @ConditionalOnClass(value={OpenApiBuilder.class})
        public static class ApiDocsConfiguration {
            @Bean
            @ConditionalOnMissingBean
            public ApiDocsController.ApiDocsRegistrations apiDocsRegistrations(RefreshableElide elide, ElideConfigProperties settings, ServerProperties serverProperties, OpenApiDocumentCustomizer customizer) {
                return ElideAutoConfiguration.buildApiDocsRegistrations(elide, settings, serverProperties.getServlet().getContextPath(), customizer);
            }

            @Bean
            @ConditionalOnMissingBean(name={"apiDocsController"})
            public ApiDocsController apiDocsController(ApiDocsController.ApiDocsRegistrations docs, RouteResolver routeResolver, ElideConfigProperties elideConfigProperties) {
                return new ApiDocsController(docs, routeResolver, elideConfigProperties);
            }

            @Bean
            @ConditionalOnMissingBean
            public OpenApiDocumentCustomizer openApiDocumentCustomizer() {
                return new BasicOpenApiDocumentCustomizer();
            }
        }

        @Configuration
        @ConditionalOnProperty(name={"elide.json-api.enabled"}, havingValue="true")
        public static class JsonApiConfiguration {
            @Bean
            @ConditionalOnMissingBean(name={"jsonApiController"})
            public JsonApiController jsonApiController(JsonApi jsonApi, ElideConfigProperties settings, RouteResolver routeResolver) {
                return new JsonApiController(jsonApi, settings, routeResolver);
            }

            @Bean
            @ConditionalOnMissingBean
            public JsonApi jsonApi(RefreshableElide refreshableElide) {
                return new JsonApi(refreshableElide);
            }
        }
    }

    @Configuration
    @ConditionalOnClass(value={RefreshScope.class})
    @ConditionalOnProperty(name={"spring.cloud.refresh.enabled"}, havingValue="true", matchIfMissing=true)
    @Order(value=0x7FFFFFFE)
    public static class RefreshableConfiguration {
        @Bean
        @RefreshScope
        @ConditionalOnMissingBean
        public EntityDictionary entityDictionary(EntityDictionary.EntityDictionaryBuilder entityDictionaryBuilder) {
            return entityDictionaryBuilder.build();
        }

        @Bean
        @RefreshScope
        @ConditionalOnMissingBean
        public RefreshableElide refreshableElide(ElideSettings.ElideSettingsBuilder elideSettingsBuilder, EntityDictionary dictionary, TransactionRegistry transactionRegistry) {
            return ElideAutoConfiguration.buildRefreshableElide(elideSettingsBuilder, dictionary, transactionRegistry);
        }

        @Configuration
        @ConditionalOnProperty(name={"elide.graphql.enabled"}, havingValue="true")
        @ConditionalOnClass(value={GraphQLSettings.GraphQLSettingsBuilder.class})
        public static class GraphQLConfiguration {
            @Bean
            @RefreshScope
            @ConditionalOnMissingBean
            public QueryRunners queryRunners(RefreshableElide refreshableElide, DataFetcherExceptionHandler exceptionHandler) {
                return new QueryRunners(refreshableElide, exceptionHandler);
            }

            @Bean
            @RefreshScope
            @ConditionalOnMissingBean(name={"graphqlController"})
            public GraphqlController graphqlController(RefreshableElide refreshableElide, QueryRunners runners, ElideMapper elideMapper, HeaderProcessor headerProcessor, ElideConfigProperties settings, RouteResolver routeResolver) {
                return new GraphqlController(refreshableElide.getElide(), runners, headerProcessor, settings, routeResolver);
            }
        }

        @Configuration
        @ConditionalOnProperty(name={"elide.api-docs.enabled"}, havingValue="true")
        @ConditionalOnClass(value={OpenApiBuilder.class})
        public static class ApiDocsConfiguration {
            @Bean
            @RefreshScope
            @ConditionalOnMissingBean
            public ApiDocsController.ApiDocsRegistrations apiDocsRegistrations(RefreshableElide elide, ElideConfigProperties settings, ServerProperties serverProperties, OpenApiDocumentCustomizer customizer) {
                return ElideAutoConfiguration.buildApiDocsRegistrations(elide, settings, serverProperties.getServlet().getContextPath(), customizer);
            }

            @Bean
            @RefreshScope
            @ConditionalOnMissingBean(name={"apiDocsController"})
            public ApiDocsController apiDocsController(ApiDocsController.ApiDocsRegistrations docs, RouteResolver routeResolver, ElideConfigProperties elideConfigProperties) {
                return new ApiDocsController(docs, routeResolver, elideConfigProperties);
            }

            @Bean
            @RefreshScope
            @ConditionalOnMissingBean
            public OpenApiDocumentCustomizer openApiDocumentCustomizer() {
                return new BasicOpenApiDocumentCustomizer();
            }
        }

        @Configuration
        @ConditionalOnProperty(name={"elide.json-api.enabled"}, havingValue="true")
        public static class JsonApiConfiguration {
            @Bean
            @RefreshScope
            @ConditionalOnMissingBean(name={"jsonApiController"})
            public JsonApiController jsonApiController(JsonApi jsonApi, ElideConfigProperties settings, RouteResolver routeResolver) {
                return new JsonApiController(jsonApi, settings, routeResolver);
            }

            @Bean
            @RefreshScope
            @ConditionalOnMissingBean
            public JsonApi jsonApi(RefreshableElide refreshableElide) {
                return new JsonApi(refreshableElide);
            }
        }
    }

    @Configuration
    @ConditionalOnClass(value={OpenApiCustomizer.class, OpenApiBuilder.class})
    @ConditionalOnProperty(name={"springdoc.api-docs.enabled"}, havingValue="true", matchIfMissing=true)
    public static class SpringDocConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public ElideOpenApiCustomizer elideOpenApiCustomizer(RefreshableElide elide, ElideConfigProperties properties) {
            return new DefaultElideOpenApiCustomizer(elide, properties);
        }

        @Bean
        public ElideGroupedOpenApiCustomizer elideGroupedOpenApiCustomizer(RefreshableElide elide, ElideConfigProperties properties) {
            return new DefaultElideGroupedOpenApiCustomizer(elide, properties);
        }

        @Configuration
        public static class ElideGroupedOpenApiConfiguration {
            public ElideGroupedOpenApiConfiguration(Optional<List<GroupedOpenApi>> optionalGroupedOpenApis, ObjectProvider<ElideGroupedOpenApiCustomizer> customizerProvider) {
                optionalGroupedOpenApis.ifPresent(groupedOpenApis -> {
                    for (GroupedOpenApi groupedOpenApi : groupedOpenApis) {
                        customizerProvider.orderedStream().forEach(customizer -> customizer.customize(groupedOpenApi));
                    }
                });
            }
        }
    }
}

