/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.spring.config;

import com.yahoo.elide.spring.config.ControllerProperties;
import com.yahoo.elide.spring.config.SubscriptionProperties;
import java.util.Arrays;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

public class GraphQLControllerProperties
extends ControllerProperties {
    @NestedConfigurationProperty
    private SubscriptionProperties subscription = new SubscriptionProperties();
    private Federation federation = new Federation();

    public SubscriptionProperties getSubscription() {
        return this.subscription;
    }

    public Federation getFederation() {
        return this.federation;
    }

    public void setSubscription(SubscriptionProperties subscription) {
        this.subscription = subscription;
    }

    public void setFederation(Federation federation) {
        this.federation = federation;
    }

    @Override
    public String toString() {
        return "GraphQLControllerProperties(subscription=" + this.getSubscription() + ", federation=" + this.getFederation() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GraphQLControllerProperties)) {
            return false;
        }
        GraphQLControllerProperties other = (GraphQLControllerProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SubscriptionProperties this$subscription = this.getSubscription();
        SubscriptionProperties other$subscription = other.getSubscription();
        if (this$subscription == null ? other$subscription != null : !((Object)this$subscription).equals(other$subscription)) {
            return false;
        }
        Federation this$federation = this.getFederation();
        Federation other$federation = other.getFederation();
        return !(this$federation == null ? other$federation != null : !((Object)this$federation).equals(other$federation));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof GraphQLControllerProperties;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        SubscriptionProperties $subscription = this.getSubscription();
        result = result * 59 + ($subscription == null ? 43 : ((Object)$subscription).hashCode());
        Federation $federation = this.getFederation();
        result = result * 59 + ($federation == null ? 43 : ((Object)$federation).hashCode());
        return result;
    }

    public static class Federation {
        private boolean enabled = false;
        private Version version = Version.FEDERATION_1_0;

        public boolean isEnabled() {
            return this.enabled;
        }

        public Version getVersion() {
            return this.version;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setVersion(Version version) {
            this.version = version;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Federation)) {
                return false;
            }
            Federation other = (Federation)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            Version this$version = this.getVersion();
            Version other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !((Object)((Object)this$version)).equals((Object)other$version));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Federation;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            Version $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : ((Object)((Object)$version)).hashCode());
            return result;
        }

        public String toString() {
            return "GraphQLControllerProperties.Federation(enabled=" + this.isEnabled() + ", version=" + this.getVersion() + ")";
        }

        public static enum Version {
            FEDERATION_2_5("2.5"),
            FEDERATION_2_4("2.4"),
            FEDERATION_2_3("2.3"),
            FEDERATION_2_2("2.2"),
            FEDERATION_2_1("2.1"),
            FEDERATION_2_0("2.0"),
            FEDERATION_1_1("1.1"),
            FEDERATION_1_0("1.0");

            private final String value;

            private Version(String value) {
                this.value = value;
            }

            public String getValue() {
                return this.value;
            }

            public static Version from(String version) {
                return Arrays.stream(Version.values()).filter(v -> version.equals(v.getValue())).findFirst().orElseThrow(() -> {
                    throw new IllegalArgumentException("Invalid Federation version.");
                });
            }
        }
    }
}

