/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.spring.controllers;

import com.yahoo.elide.core.request.route.Route;
import com.yahoo.elide.core.request.route.RouteResolver;
import com.yahoo.elide.spring.config.ElideConfigProperties;
import com.yahoo.elide.swagger.OpenApiDocument;
import io.swagger.v3.oas.models.OpenAPI;
import jakarta.servlet.http.HttpServletRequest;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.owasp.encoder.Encode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@RestController
@RequestMapping(value={"${elide.api-docs.path}"})
public class ApiDocsController {
    private static final Logger log = LoggerFactory.getLogger(ApiDocsController.class);
    protected Map<Pair<String, String>, OpenApiDocument> documents;
    protected RouteResolver routeResolver;
    protected ElideConfigProperties elideConfigProperties;

    public ApiDocsController(ApiDocsRegistrations docs, RouteResolver routeResolver, ElideConfigProperties elideConfigProperties) {
        log.debug("Started ~~");
        this.documents = new HashMap<Pair<String, String>, OpenApiDocument>();
        this.routeResolver = routeResolver;
        this.elideConfigProperties = elideConfigProperties;
        docs.getRegistrations().forEach(doc -> {
            String apiVersion = doc.getApiVersion();
            apiVersion = apiVersion == null ? "" : apiVersion;
            String apiPath = doc.path;
            this.documents.put((Pair<String, String>)Pair.of((Object)apiVersion, (Object)apiPath), new OpenApiDocument(doc.document, OpenApiDocument.Version.from((String)doc.version)));
        });
    }

    @GetMapping(value={"/**", ""}, produces={"application/json"})
    public Callable<ResponseEntity<String>> listJson(@RequestHeader HttpHeaders requestHeaders, @RequestParam MultiValueMap<String, String> allRequestParams, HttpServletRequest request) {
        String prefix = this.elideConfigProperties.getApiDocs().getPath();
        String pathname = this.getPath(request, prefix);
        String baseUrl = this.getBaseUrl(prefix);
        Route route = this.routeResolver.resolve("application/json", baseUrl, pathname, (Map)requestHeaders, allRequestParams);
        String path = route.getPath();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.isBlank()) {
            return this.list(route.getApiVersion(), "application/json");
        }
        return this.list(route.getApiVersion(), path, "application/json");
    }

    @GetMapping(value={"/**", ""}, produces={"application/yaml"})
    public Callable<ResponseEntity<String>> listYaml(@RequestHeader HttpHeaders requestHeaders, @RequestParam MultiValueMap<String, String> allRequestParams, HttpServletRequest request) {
        String prefix = this.elideConfigProperties.getApiDocs().getPath();
        String pathname = this.getPath(request, prefix);
        String baseUrl = this.getBaseUrl(prefix);
        Route route = this.routeResolver.resolve("application/yaml", baseUrl, pathname, (Map)requestHeaders, allRequestParams);
        String path = route.getPath();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.isBlank()) {
            return this.list(route.getApiVersion(), "application/yaml");
        }
        return this.list(route.getApiVersion(), path, "application/yaml");
    }

    public Callable<ResponseEntity<String>> list(final String apiVersion, final String mediaType) {
        final List<String> documentPaths = this.documents.keySet().stream().filter(key -> ((String)key.getLeft()).equals(apiVersion)).map(Pair::getRight).toList();
        return new Callable<ResponseEntity<String>>(){

            @Override
            public ResponseEntity<String> call() throws Exception {
                Optional<Pair> pair;
                if (documentPaths.size() == 1 && (pair = ApiDocsController.this.documents.keySet().stream().filter(key -> ((String)key.getLeft()).equals(apiVersion)).findFirst()).isPresent()) {
                    return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)ApiDocsController.this.documents.get(pair.get()).ofMediaType(mediaType));
                }
                String body = documentPaths.stream().map(key -> "\"" + key + "\"").collect(Collectors.joining(",", "[", "]"));
                return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)body);
            }
        };
    }

    public Callable<ResponseEntity<String>> list(final String apiVersion, String name, final String mediaType) {
        final String encodedName = Encode.forHtml((String)name);
        return new Callable<ResponseEntity<String>>(){

            @Override
            public ResponseEntity<String> call() throws Exception {
                Pair lookupKey = Pair.of((Object)apiVersion, (Object)encodedName);
                if (ApiDocsController.this.documents.containsKey(lookupKey)) {
                    return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)ApiDocsController.this.documents.get(lookupKey).ofMediaType(mediaType));
                }
                return ResponseEntity.status((int)404).body((Object)("Unknown document: " + encodedName));
            }
        };
    }

    private String getPath(HttpServletRequest request, String prefix) {
        String pathname = (String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
        pathname = pathname.replaceFirst(prefix, "");
        try {
            return URLDecoder.decode(pathname, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            return pathname;
        }
    }

    protected String getBaseUrl(String prefix) {
        Object baseUrl = this.elideConfigProperties.getBaseUrl();
        if (StringUtils.isEmpty((CharSequence)baseUrl)) {
            baseUrl = ServletUriComponentsBuilder.fromCurrentContextPath().build().toUriString();
        }
        if (prefix.length() > 1) {
            baseUrl = ((String)baseUrl).endsWith("/") ? ((String)baseUrl).substring(0, ((String)baseUrl).length() - 1) + prefix : (String)baseUrl + prefix;
        }
        return baseUrl;
    }

    public static class ApiDocsRegistrations {
        List<ApiDocsRegistration> registrations;

        public ApiDocsRegistrations(Supplier<OpenAPI> doc, String version, String apiVersion) {
            this.registrations = List.of(new ApiDocsRegistration("", doc, version, apiVersion));
        }

        public List<ApiDocsRegistration> getRegistrations() {
            return this.registrations;
        }

        public void setRegistrations(List<ApiDocsRegistration> registrations) {
            this.registrations = registrations;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ApiDocsRegistrations)) {
                return false;
            }
            ApiDocsRegistrations other = (ApiDocsRegistrations)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<ApiDocsRegistration> this$registrations = this.getRegistrations();
            List<ApiDocsRegistration> other$registrations = other.getRegistrations();
            return !(this$registrations == null ? other$registrations != null : !((Object)this$registrations).equals(other$registrations));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ApiDocsRegistrations;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<ApiDocsRegistration> $registrations = this.getRegistrations();
            result = result * 59 + ($registrations == null ? 43 : ((Object)$registrations).hashCode());
            return result;
        }

        public String toString() {
            return "ApiDocsController.ApiDocsRegistrations(registrations=" + this.getRegistrations() + ")";
        }

        public ApiDocsRegistrations(List<ApiDocsRegistration> registrations) {
            this.registrations = registrations;
        }
    }

    public static class ApiDocsRegistration {
        private String path;
        private Supplier<OpenAPI> document;
        private String version;
        private String apiVersion;

        public String getPath() {
            return this.path;
        }

        public Supplier<OpenAPI> getDocument() {
            return this.document;
        }

        public String getVersion() {
            return this.version;
        }

        public String getApiVersion() {
            return this.apiVersion;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public void setDocument(Supplier<OpenAPI> document) {
            this.document = document;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public void setApiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ApiDocsRegistration)) {
                return false;
            }
            ApiDocsRegistration other = (ApiDocsRegistration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            Supplier<OpenAPI> this$document = this.getDocument();
            Supplier<OpenAPI> other$document = other.getDocument();
            if (this$document == null ? other$document != null : !this$document.equals(other$document)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$apiVersion = this.getApiVersion();
            String other$apiVersion = other.getApiVersion();
            return !(this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ApiDocsRegistration;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            Supplier<OpenAPI> $document = this.getDocument();
            result = result * 59 + ($document == null ? 43 : $document.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $apiVersion = this.getApiVersion();
            result = result * 59 + ($apiVersion == null ? 43 : $apiVersion.hashCode());
            return result;
        }

        public String toString() {
            return "ApiDocsController.ApiDocsRegistration(path=" + this.getPath() + ", document=" + this.getDocument() + ", version=" + this.getVersion() + ", apiVersion=" + this.getApiVersion() + ")";
        }

        public ApiDocsRegistration(String path, Supplier<OpenAPI> document, String version, String apiVersion) {
            this.path = path;
            this.document = document;
            this.version = version;
            this.apiVersion = apiVersion;
        }
    }
}

