/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.spring.controllers;

import com.yahoo.elide.Elide;
import com.yahoo.elide.ElideResponse;
import com.yahoo.elide.core.request.route.Route;
import com.yahoo.elide.core.request.route.RouteResolver;
import com.yahoo.elide.jsonapi.JsonApi;
import com.yahoo.elide.spring.config.ElideConfigProperties;
import com.yahoo.elide.spring.security.AuthenticationUser;
import com.yahoo.elide.utils.HeaderProcessor;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@RestController
@RequestMapping(value={"${elide.json-api.path}"})
public class JsonApiController {
    private static final Logger log = LoggerFactory.getLogger(JsonApiController.class);
    private final JsonApi jsonApi;
    private final Elide elide;
    private final ElideConfigProperties settings;
    private final HeaderProcessor headerProcessor;
    private final RouteResolver routeResolver;

    public JsonApiController(JsonApi jsonApi, ElideConfigProperties settings, RouteResolver routeResolver) {
        log.debug("Started ~~");
        this.jsonApi = jsonApi;
        this.settings = settings;
        this.elide = jsonApi.getElide();
        this.headerProcessor = this.elide.getElideSettings().getHeaderProcessor();
        this.routeResolver = routeResolver;
    }

    @GetMapping(value={"/**"}, produces={"application/vnd.api+json"})
    public Callable<ResponseEntity<String>> elideGet(@RequestHeader HttpHeaders requestHeaders, @RequestParam MultiValueMap<String, String> allRequestParams, HttpServletRequest request, Authentication authentication) {
        Map requestHeadersCleaned = this.headerProcessor.process((Map)requestHeaders);
        String prefix = this.settings.getJsonApi().getPath();
        String baseUrl = this.getBaseUrl(prefix);
        String pathname = this.getPath(request, prefix);
        final Route route = this.routeResolver.resolve("application/vnd.api+json", baseUrl, pathname, requestHeadersCleaned, allRequestParams);
        final AuthenticationUser user = new AuthenticationUser(authentication);
        return new Callable<ResponseEntity<String>>(){

            @Override
            public ResponseEntity<String> call() throws Exception {
                ElideResponse response = JsonApiController.this.jsonApi.get(route, user, UUID.randomUUID());
                return ResponseEntity.status((int)response.getStatus()).body((Object)((String)response.getBody()));
            }
        };
    }

    @PostMapping(value={"/**"}, consumes={"application/vnd.api+json", "application/vnd.api+json; ext=\"https://jsonapi.org/ext/atomic\""}, produces={"application/vnd.api+json", "application/vnd.api+json; ext=\"https://jsonapi.org/ext/atomic\""})
    public Callable<ResponseEntity<String>> elidePost(@RequestHeader HttpHeaders requestHeaders, @RequestParam MultiValueMap<String, String> allRequestParams, final @RequestBody String body, HttpServletRequest request, Authentication authentication) {
        Map requestHeadersCleaned = this.headerProcessor.process((Map)requestHeaders);
        String prefix = this.settings.getJsonApi().getPath();
        String baseUrl = this.getBaseUrl(prefix);
        String pathname = this.getPath(request, prefix);
        final Route route = this.routeResolver.resolve("application/vnd.api+json", baseUrl, pathname, requestHeadersCleaned, allRequestParams);
        final AuthenticationUser user = new AuthenticationUser(authentication);
        return new Callable<ResponseEntity<String>>(){

            @Override
            public ResponseEntity<String> call() throws Exception {
                if ("/operations".equals(route.getPath()) || "operations".equals(route.getPath())) {
                    ElideResponse response = JsonApiController.this.jsonApi.operations(route, body, user, UUID.randomUUID());
                    return ResponseEntity.status((int)response.getStatus()).contentType(MediaType.valueOf((String)"application/vnd.api+json; ext=\"https://jsonapi.org/ext/atomic\"")).body((Object)((String)response.getBody()));
                }
                ElideResponse response = JsonApiController.this.jsonApi.post(route, body, user, UUID.randomUUID());
                return ResponseEntity.status((int)response.getStatus()).contentType(MediaType.valueOf((String)"application/vnd.api+json")).body((Object)((String)response.getBody()));
            }
        };
    }

    @PatchMapping(value={"/**"}, consumes={"application/vnd.api+json", "application/vnd.api+json; ext=jsonpatch"}, produces={"application/vnd.api+json"})
    public Callable<ResponseEntity<String>> elidePatch(@RequestHeader HttpHeaders requestHeaders, @RequestParam MultiValueMap<String, String> allRequestParams, final @RequestBody String body, HttpServletRequest request, Authentication authentication) {
        Map requestHeadersCleaned = this.headerProcessor.process((Map)requestHeaders);
        String prefix = this.settings.getJsonApi().getPath();
        String baseUrl = this.getBaseUrl(prefix);
        String pathname = this.getPath(request, prefix);
        final Route route = this.routeResolver.resolve("application/vnd.api+json", baseUrl, pathname, requestHeadersCleaned, allRequestParams);
        final AuthenticationUser user = new AuthenticationUser(authentication);
        return new Callable<ResponseEntity<String>>(){

            @Override
            public ResponseEntity<String> call() throws Exception {
                ElideResponse response = JsonApiController.this.jsonApi.patch(route, body, user, UUID.randomUUID());
                return ResponseEntity.status((int)response.getStatus()).body((Object)((String)response.getBody()));
            }
        };
    }

    @DeleteMapping(value={"/**"}, produces={"application/vnd.api+json"})
    public Callable<ResponseEntity<String>> elideDelete(@RequestHeader HttpHeaders requestHeaders, @RequestParam MultiValueMap<String, String> allRequestParams, HttpServletRequest request, Authentication authentication) {
        Map requestHeadersCleaned = this.headerProcessor.process((Map)requestHeaders);
        String prefix = this.settings.getJsonApi().getPath();
        String baseUrl = this.getBaseUrl(prefix);
        String pathname = this.getPath(request, prefix);
        final Route route = this.routeResolver.resolve("application/vnd.api+json", baseUrl, pathname, requestHeadersCleaned, allRequestParams);
        final AuthenticationUser user = new AuthenticationUser(authentication);
        return new Callable<ResponseEntity<String>>(){

            @Override
            public ResponseEntity<String> call() throws Exception {
                ElideResponse response = JsonApiController.this.jsonApi.delete(route, null, user, UUID.randomUUID());
                return ResponseEntity.status((int)response.getStatus()).body((Object)((String)response.getBody()));
            }
        };
    }

    @DeleteMapping(value={"/**"}, consumes={"application/vnd.api+json"})
    public Callable<ResponseEntity<String>> elideDeleteRelation(@RequestHeader HttpHeaders requestHeaders, @RequestParam MultiValueMap<String, String> allRequestParams, final @RequestBody String body, HttpServletRequest request, Authentication authentication) {
        Map requestHeadersCleaned = this.headerProcessor.process((Map)requestHeaders);
        String prefix = this.settings.getJsonApi().getPath();
        String baseUrl = this.getBaseUrl(prefix);
        String pathname = this.getPath(request, prefix);
        final Route route = this.routeResolver.resolve("application/vnd.api+json", baseUrl, pathname, requestHeadersCleaned, allRequestParams);
        final AuthenticationUser user = new AuthenticationUser(authentication);
        return new Callable<ResponseEntity<String>>(){

            @Override
            public ResponseEntity<String> call() throws Exception {
                ElideResponse response = JsonApiController.this.jsonApi.delete(route, body, user, UUID.randomUUID());
                return ResponseEntity.status((int)response.getStatus()).body((Object)((String)response.getBody()));
            }
        };
    }

    private String getPath(HttpServletRequest request, String prefix) {
        String pathname = (String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
        return pathname.replaceFirst(prefix, "");
    }

    protected String getBaseUrl(String prefix) {
        Object baseUrl = this.elide.getElideSettings().getBaseUrl();
        if (StringUtils.isEmpty((CharSequence)baseUrl)) {
            baseUrl = ServletUriComponentsBuilder.fromCurrentContextPath().build().toUriString();
        }
        if (prefix.length() > 1) {
            baseUrl = ((String)baseUrl).endsWith("/") ? ((String)baseUrl).substring(0, ((String)baseUrl).length() - 1) + prefix : (String)baseUrl + prefix;
        }
        return baseUrl;
    }
}

