/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.spring.orm.jpa;

import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.datastores.jpa.SupplierEntityManager;
import com.yahoo.elide.datastores.jpa.transaction.AbstractJpaTransaction;
import com.yahoo.elide.datastores.jpql.porting.QueryLogger;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import java.util.function.Consumer;
import org.springframework.orm.jpa.EntityManagerHolder;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class PlatformJpaTransaction
extends AbstractJpaTransaction {
    private final PlatformTransactionManager transactionManager;
    private final TransactionDefinition definition;
    private final EntityManagerFactory entityManagerFactory;
    private TransactionStatus status;

    public PlatformJpaTransaction(PlatformTransactionManager transactionManager, TransactionDefinition definition, EntityManagerFactory entityManagerFactory, EntityManager em, Consumer<EntityManager> jpaTransactionCancel, QueryLogger logger, boolean delegateToInMemoryStore, boolean isScrollEnabled) {
        super(em, jpaTransactionCancel, logger, delegateToInMemoryStore, isScrollEnabled);
        this.transactionManager = transactionManager;
        this.definition = definition;
        this.entityManagerFactory = entityManagerFactory;
    }

    public void begin() {
        this.status = this.transactionManager.getTransaction(this.definition);
        EntityManager entityManager = this.em;
        if (entityManager instanceof SupplierEntityManager) {
            SupplierEntityManager supplierEntityManager = (SupplierEntityManager)entityManager;
            EntityManagerHolder entityManagerHolder = (EntityManagerHolder)TransactionSynchronizationManager.getResource((Object)this.entityManagerFactory);
            if (entityManagerHolder != null) {
                supplierEntityManager.setEntityManager(entityManagerHolder.getEntityManager());
            } else {
                supplierEntityManager.setEntityManager(this.entityManagerFactory.createEntityManager());
            }
        } else {
            throw new IllegalStateException("Expected entity manager to be supplied by EntityManagerProxySupplier");
        }
    }

    public void commit(RequestScope scope) {
        if (this.isOpen()) {
            super.commit(scope);
            this.transactionManager.commit(this.status);
        }
    }

    public void rollback() {
        if (this.isOpen()) {
            try {
                super.rollback();
            }
            finally {
                this.transactionManager.rollback(this.status);
            }
        }
    }

    public boolean isOpen() {
        return this.em.isOpen() && this.status != null && !this.status.isCompleted();
    }
}

