/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.spring.orm.jpa;

import com.yahoo.elide.datastores.jpa.JpaDataStore;
import com.yahoo.elide.datastores.jpa.transaction.JpaTransaction;
import com.yahoo.elide.spring.orm.jpa.PlatformJpaTransaction;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import java.util.function.Consumer;
import org.hibernate.Session;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;

public class PlatformJpaTransactionSupplier
implements JpaDataStore.JpaTransactionSupplier {
    private final boolean delegateToInMemoryStore;
    private final PlatformTransactionManager transactionManager;
    private final TransactionDefinition transactionDefinition;
    private final EntityManagerFactory entityManagerFactory;
    private final Consumer<EntityManager> txCancel = em -> ((Session)em.unwrap(Session.class)).cancelQuery();

    public PlatformJpaTransactionSupplier(TransactionDefinition transactionDefinition, PlatformTransactionManager transactionManager, EntityManagerFactory entityManagerFactory, boolean delegateToInMemoryStore) {
        this.transactionDefinition = transactionDefinition;
        this.delegateToInMemoryStore = delegateToInMemoryStore;
        this.transactionManager = transactionManager;
        this.entityManagerFactory = entityManagerFactory;
    }

    public JpaTransaction get(EntityManager entityManager) {
        return new PlatformJpaTransaction(this.transactionManager, this.transactionDefinition, this.entityManagerFactory, entityManager, this.txCancel, JpaDataStore.DEFAULT_LOGGER, this.delegateToInMemoryStore, true);
    }
}

