/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.standalone;

import com.codahale.metrics.servlet.InstrumentedFilter;
import com.codahale.metrics.servlets.AdminServlet;
import com.codahale.metrics.servlets.HealthCheckServlet;
import com.codahale.metrics.servlets.MetricsServlet;
import com.yahoo.elide.resources.DefaultOpaqueUserFunction;
import com.yahoo.elide.security.checks.Check;
import com.yahoo.elide.standalone.config.ElideResourceConfig;
import com.yahoo.elide.standalone.config.ElideStandaloneSettings;
import java.util.EnumSet;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.ws.rs.core.SecurityContext;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElideStandalone {
    private static final Logger log = LoggerFactory.getLogger(ElideStandalone.class);
    private final ElideStandaloneSettings elideStandaloneSettings;
    private Server jettyServer;

    public ElideStandalone(ElideStandaloneSettings elideStandaloneSettings) {
        this.elideStandaloneSettings = elideStandaloneSettings;
    }

    public ElideStandalone(Map<String, Class<? extends Check>> checkMappings) {
        this(checkMappings, SecurityContext::getUserPrincipal);
    }

    public ElideStandalone(final Map<String, Class<? extends Check>> checkMappings, final DefaultOpaqueUserFunction userExtractionFn) {
        this(new ElideStandaloneSettings(){

            @Override
            public Map<String, Class<? extends Check>> getCheckMappings() {
                return checkMappings;
            }

            @Override
            public DefaultOpaqueUserFunction getUserExtractionFunction() {
                return userExtractionFn;
            }
        });
    }

    public void start() throws Exception {
        this.start(true);
    }

    public void start(boolean block) throws Exception {
        ServletHolder jerseyServlet;
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/");
        log.info("Starting jetty server on port: {}", (Object)this.elideStandaloneSettings.getPort());
        this.jettyServer = new Server(this.elideStandaloneSettings.getPort());
        this.jettyServer.setHandler((Handler)context);
        context.setAttribute("elideStandaloneSettings", (Object)this.elideStandaloneSettings);
        if (this.elideStandaloneSettings.enableJSONAPI()) {
            jerseyServlet = context.addServlet(ServletContainer.class, this.elideStandaloneSettings.getJsonApiPathSpec());
            jerseyServlet.setInitOrder(0);
            jerseyServlet.setInitParameter("jersey.config.server.provider.packages", "com.yahoo.elide.resources");
            jerseyServlet.setInitParameter("javax.ws.rs.Application", ElideResourceConfig.class.getCanonicalName());
        }
        if (this.elideStandaloneSettings.enableGraphQL()) {
            jerseyServlet = context.addServlet(ServletContainer.class, this.elideStandaloneSettings.getGraphQLApiPathSepc());
            jerseyServlet.setInitOrder(0);
            jerseyServlet.setInitParameter("jersey.config.server.provider.packages", "com.yahoo.elide.graphql");
            jerseyServlet.setInitParameter("javax.ws.rs.Application", ElideResourceConfig.class.getCanonicalName());
        }
        if (this.elideStandaloneSettings.enableServiceMonitoring()) {
            FilterHolder instrumentedFilterHolder = new FilterHolder(InstrumentedFilter.class);
            instrumentedFilterHolder.setName("instrumentedFilter");
            instrumentedFilterHolder.setAsyncSupported(true);
            context.addFilter(instrumentedFilterHolder, "/*", EnumSet.of(DispatcherType.REQUEST));
            context.setAttribute(HealthCheckServlet.HEALTH_CHECK_REGISTRY, (Object)ElideResourceConfig.getHealthCheckRegistry());
            context.setAttribute(InstrumentedFilter.REGISTRY_ATTRIBUTE, (Object)ElideResourceConfig.getMetricRegistry());
            context.setAttribute(MetricsServlet.METRICS_REGISTRY, (Object)ElideResourceConfig.getMetricRegistry());
            context.addServlet(AdminServlet.class, "/stats/*");
        }
        if (!this.elideStandaloneSettings.enableSwagger().isEmpty()) {
            jerseyServlet = context.addServlet(ServletContainer.class, this.elideStandaloneSettings.getSwaggerPathSepc());
            jerseyServlet.setInitOrder(0);
            jerseyServlet.setInitParameter("jersey.config.server.provider.packages", "com.yahoo.elide.contrib.swagger.resources");
            jerseyServlet.setInitParameter("javax.ws.rs.Application", ElideResourceConfig.class.getCanonicalName());
        }
        this.elideStandaloneSettings.updateServletContextHandler(context);
        try {
            this.jettyServer.start();
            log.info("Jetty started!");
            if (block) {
                this.jettyServer.join();
            }
        }
        catch (Exception e) {
            log.error("Unexpected exception caught: {}", (Object)e.getMessage(), (Object)e);
            throw e;
        }
        finally {
            if (block) {
                this.jettyServer.destroy();
            }
        }
    }

    public void stop() throws Exception {
        this.jettyServer.stop();
        this.jettyServer.destroy();
    }
}

