/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.standalone;

import com.yahoo.elide.standalone.PersistenceUnitInfoImpl;
import com.yahoo.elide.utils.ClassScanner;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.persistence.Entity;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceUnitInfo;
import org.hibernate.jpa.boot.internal.EntityManagerFactoryBuilderImpl;
import org.hibernate.jpa.boot.internal.PersistenceUnitInfoDescriptor;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;

public class Util {
    public static EntityManagerFactory getEntityManagerFactory(String modelPackageName, Properties options) {
        if (options.isEmpty()) {
            options.put("hibernate.show_sql", "true");
            options.put("hibernate.hbm2ddl.auto", "create");
            options.put("hibernate.dialect", "org.hibernate.dialect.MySQL5Dialect");
            options.put("hibernate.current_session_context_class", "thread");
            options.put("hibernate.jdbc.use_scrollable_resultset", "true");
            options.put("hibernate.jdbc.batch_size", "50");
            options.put("hibernate.jdbc.fetch_size", "50");
            options.put("hibernate.default_batch_fetch_size", "100");
            options.putIfAbsent("hibernate.connection.provider_class", "com.zaxxer.hikari.hibernate.HikariConnectionProvider");
            options.putIfAbsent("hibernate.hikari.connectionTimeout", "20000");
            options.putIfAbsent("hibernate.hikari.maximumPoolSize", "30");
            options.putIfAbsent("hibernate.hikari.idleTimeout", "30000");
            options.put("javax.persistence.jdbc.driver", "com.mysql.jdbc.Driver");
            options.put("javax.persistence.jdbc.url", "jdbc:mysql://localhost/elide?serverTimezone=UTC");
            options.put("javax.persistence.jdbc.user", "elide");
            options.put("javax.persistence.jdbc.password", "elide123");
        }
        PersistenceUnitInfoImpl persistenceUnitInfo = new PersistenceUnitInfoImpl("elide-stand-alone", Util.getAllEntities(modelPackageName), options);
        return new EntityManagerFactoryBuilderImpl((PersistenceUnitDescriptor)new PersistenceUnitInfoDescriptor((PersistenceUnitInfo)persistenceUnitInfo), new HashMap()).build();
    }

    public static List<String> getAllEntities(String packageName) {
        return ClassScanner.getAnnotatedClasses((String)packageName, Entity.class).stream().map(Class::getName).collect(Collectors.toList());
    }
}

