/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.standalone.config;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.yahoo.elide.Elide;
import com.yahoo.elide.ElideSettings;
import com.yahoo.elide.core.DataStore;
import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.resources.DefaultOpaqueUserFunction;
import com.yahoo.elide.standalone.Util;
import com.yahoo.elide.standalone.config.ElideStandaloneSettings;
import io.swagger.models.Swagger;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Context;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.InstanceBinding;
import org.glassfish.jersey.server.ResourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElideResourceConfig
extends ResourceConfig {
    private static final Logger log = LoggerFactory.getLogger(ElideResourceConfig.class);
    private final ElideStandaloneSettings settings;
    private final ServiceLocator injector;
    public static final String ELIDE_STANDALONE_SETTINGS_ATTR = "elideStandaloneSettings";
    private static MetricRegistry metricRegistry = null;
    private static HealthCheckRegistry healthCheckRegistry = null;

    @Inject
    public ElideResourceConfig(final ServiceLocator injector, @Context ServletContext servletContext) {
        this.injector = injector;
        this.settings = (ElideStandaloneSettings)servletContext.getAttribute(ELIDE_STANDALONE_SETTINGS_ATTR);
        this.register(new AbstractBinder(){

            protected void configure() {
                ((InstanceBinding)this.bind(Util.getAllEntities(ElideResourceConfig.this.settings.getModelPackageName())).to(Set.class)).named("elideAllModels");
            }
        });
        this.register(new AbstractBinder(){

            protected void configure() {
                ElideSettings elideSettings = ElideResourceConfig.this.settings.getElideSettings(injector);
                Elide elide = new Elide(elideSettings);
                ((InstanceBinding)this.bind(elide).to(Elide.class)).named("elide");
                ((InstanceBinding)this.bind(ElideResourceConfig.this.settings.getUserExtractionFunction()).to(DefaultOpaqueUserFunction.class)).named("elideUserExtractionFunction");
                this.bind(elideSettings).to(ElideSettings.class);
                this.bind(elideSettings.getDictionary()).to(EntityDictionary.class);
                ((InstanceBinding)this.bind(elideSettings.getDataStore()).to(DataStore.class)).named("elideDataStore");
            }
        });
        this.register(new org.glassfish.hk2.utilities.binding.AbstractBinder(){

            protected void configure() {
                Map<String, Swagger> swaggerDocs = ElideResourceConfig.this.settings.enableSwagger();
                if (!swaggerDocs.isEmpty()) {
                    this.bind(swaggerDocs).named("swagger").to((TypeLiteral)new TypeLiteral<Map<String, Swagger>>(){});
                }
            }
        });
        this.registerFilters(this.settings.getFilters());
        this.additionalConfiguration(this.settings.getApplicationConfigurator());
    }

    private void additionalConfiguration(Consumer<ResourceConfig> configurator) {
        this.injector.inject(configurator);
        configurator.accept(this);
    }

    private void registerFilters(List<Class<?>> filters) {
        filters.forEach(arg_0 -> ((ElideResourceConfig)this).register(arg_0));
    }

    public static MetricRegistry getMetricRegistry() {
        if (metricRegistry == null) {
            metricRegistry = new MetricRegistry();
        }
        return metricRegistry;
    }

    public static HealthCheckRegistry getHealthCheckRegistry() {
        if (healthCheckRegistry == null) {
            healthCheckRegistry = new HealthCheckRegistry();
        }
        return healthCheckRegistry;
    }
}

