/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.standalone.config;

import com.yahoo.elide.ElideSettings;
import com.yahoo.elide.ElideSettingsBuilder;
import com.yahoo.elide.Injector;
import com.yahoo.elide.audit.AuditLogger;
import com.yahoo.elide.audit.Slf4jLogger;
import com.yahoo.elide.core.DataStore;
import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.core.filter.dialect.JoinFilterDialect;
import com.yahoo.elide.core.filter.dialect.RSQLFilterDialect;
import com.yahoo.elide.core.filter.dialect.SubqueryFilterDialect;
import com.yahoo.elide.datastores.jpa.JpaDataStore;
import com.yahoo.elide.datastores.jpa.transaction.NonJtaTransaction;
import com.yahoo.elide.resources.DefaultOpaqueUserFunction;
import com.yahoo.elide.security.checks.Check;
import com.yahoo.elide.standalone.Util;
import io.swagger.models.Swagger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.function.Consumer;
import javax.persistence.EntityManagerFactory;
import javax.ws.rs.core.SecurityContext;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.server.ResourceConfig;

public interface ElideStandaloneSettings {
    default public Map<String, Class<? extends Check>> getCheckMappings() {
        return Collections.emptyMap();
    }

    default public ElideSettings getElideSettings(final ServiceLocator injector) {
        EntityManagerFactory entityManagerFactory = Util.getEntityManagerFactory(this.getModelPackageName(), this.getDatabaseProperties());
        JpaDataStore dataStore = new JpaDataStore(() -> entityManagerFactory.createEntityManager(), em -> new NonJtaTransaction(em), new Class[0]);
        EntityDictionary dictionary = new EntityDictionary(this.getCheckMappings(), new Injector(){

            public void inject(Object entity) {
                injector.inject(entity);
            }

            public <T> T instantiate(Class<T> cls) {
                return (T)injector.create(cls);
            }
        });
        dictionary.scanForSecurityChecks();
        ElideSettingsBuilder builder = new ElideSettingsBuilder((DataStore)dataStore).withUseFilterExpressions(true).withEntityDictionary(dictionary).withJoinFilterDialect((JoinFilterDialect)new RSQLFilterDialect(dictionary)).withSubqueryFilterDialect((SubqueryFilterDialect)new RSQLFilterDialect(dictionary)).withAuditLogger(this.getAuditLogger());
        if (this.enableIS06081Dates()) {
            builder = builder.withISO8601Dates("yyyy-MM-dd'T'HH:mm'Z'", TimeZone.getTimeZone("UTC"));
        }
        return builder.build();
    }

    default public DefaultOpaqueUserFunction getUserExtractionFunction() {
        return SecurityContext::getUserPrincipal;
    }

    default public int getPort() {
        return 8080;
    }

    default public String getModelPackageName() {
        return "com.yourcompany.elide.models";
    }

    default public String getJsonApiPathSpec() {
        return "/api/v1/*";
    }

    default public String getGraphQLApiPathSepc() {
        return "/graphql/api/v1";
    }

    default public String getSwaggerPathSepc() {
        return "/swagger/*";
    }

    default public boolean enableJSONAPI() {
        return true;
    }

    default public boolean enableGraphQL() {
        return true;
    }

    default public boolean enableIS06081Dates() {
        return true;
    }

    default public boolean enableServiceMonitoring() {
        return true;
    }

    default public Map<String, Swagger> enableSwagger() {
        return new HashMap<String, Swagger>();
    }

    default public List<Class<?>> getFilters() {
        return Collections.emptyList();
    }

    default public Consumer<ResourceConfig> getApplicationConfigurator() {
        return x -> {};
    }

    default public Properties getDatabaseProperties() {
        return new Properties();
    }

    default public void updateServletContextHandler(ServletContextHandler servletContextHandler) {
    }

    default public AuditLogger getAuditLogger() {
        return new Slf4jLogger();
    }
}

