/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.contrib.swagger;

import com.fasterxml.jackson.databind.type.SimpleType;
import com.yahoo.elide.annotation.CreatePermission;
import com.yahoo.elide.annotation.DeletePermission;
import com.yahoo.elide.annotation.ReadPermission;
import com.yahoo.elide.annotation.UpdatePermission;
import com.yahoo.elide.contrib.swagger.model.Resource;
import com.yahoo.elide.contrib.swagger.property.Relationship;
import com.yahoo.elide.core.EntityDictionary;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.converter.ModelConverter;
import io.swagger.converter.ModelConverterContext;
import io.swagger.jackson.ModelResolver;
import io.swagger.models.Model;
import io.swagger.models.properties.Property;
import io.swagger.util.Json;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class JsonApiModelResolver
extends ModelResolver {
    private final EntityDictionary dictionary;

    public JsonApiModelResolver(EntityDictionary dictionary) {
        super(Json.mapper());
        this.dictionary = dictionary;
    }

    public Model resolve(Type type, ModelConverterContext context, Iterator<ModelConverter> next) {
        String typeAlias;
        if (type instanceof SimpleType) {
            type = ((SimpleType)type).getRawClass();
        }
        if (!(type instanceof Class)) {
            return super.resolve(type, context, next);
        }
        Class clazz = (Class)type;
        try {
            typeAlias = this.dictionary.getJsonAliasFor(clazz);
        }
        catch (IllegalArgumentException e) {
            return super.resolve(type, context, next);
        }
        Resource entitySchema = new Resource();
        entitySchema.setSecurityDescription(this.getClassPermissions(clazz));
        List attributeNames = this.dictionary.getAttributes(clazz);
        for (String attributeName : attributeNames) {
            Class attributeClazz = this.dictionary.getType(clazz, attributeName);
            Property attribute = this.processAttribute(clazz, attributeName, attributeClazz, context, next);
            entitySchema.addAttribute(attributeName, attribute);
        }
        List relationshipNames = this.dictionary.getRelationships(clazz);
        for (String relationshipName : relationshipNames) {
            Class relationshipType;
            Relationship relationship = this.processRelationship(clazz, relationshipName, relationshipType = this.dictionary.getParameterizedType(clazz, relationshipName));
            if (relationship == null) continue;
            entitySchema.addRelationship(relationshipName, (Property)relationship);
        }
        entitySchema.name(typeAlias);
        return entitySchema;
    }

    private Property processAttribute(Class<?> clazz, String attributeName, Class<?> attributeClazz, ModelConverterContext context, Iterator<ModelConverter> next) {
        Property attribute = super.resolveProperty(attributeClazz, context, null, next);
        String permissions = this.getFieldPermissions(clazz, attributeName);
        String description = this.getFieldDescription(clazz, attributeName);
        attribute.setDescription((String)StringUtils.defaultIfEmpty((CharSequence)this.joinNonEmpty("\n", description, permissions), null));
        attribute.setExample((Object)StringUtils.defaultIfEmpty((CharSequence)this.getFieldExample(clazz, attributeName), null));
        attribute.setReadOnly(Boolean.valueOf(this.getFieldReadOnly(clazz, attributeName)));
        attribute.setRequired(this.getFieldRequired(clazz, attributeName));
        return attribute;
    }

    private Relationship processRelationship(Class<?> clazz, String relationshipName, Class<?> relationshipClazz) {
        Relationship relationship = null;
        try {
            relationship = new Relationship(this.dictionary.getJsonAliasFor(relationshipClazz));
        }
        catch (IllegalArgumentException e) {
            return relationship;
        }
        String description = this.getFieldDescription(clazz, relationshipName);
        String permissions = this.getFieldPermissions(clazz, relationshipName);
        relationship.setDescription((String)StringUtils.defaultIfEmpty((CharSequence)this.joinNonEmpty("\n", description, permissions), null));
        relationship.setExample(StringUtils.defaultIfEmpty((CharSequence)this.getFieldExample(clazz, relationshipName), null));
        relationship.setReadOnly(this.getFieldReadOnly(clazz, relationshipName));
        relationship.setRequired(this.getFieldRequired(clazz, relationshipName));
        return relationship;
    }

    private ApiModelProperty getApiModelProperty(Class<?> clazz, String fieldName) {
        return (ApiModelProperty)this.dictionary.getAttributeOrRelationAnnotation(clazz, ApiModelProperty.class, fieldName);
    }

    private boolean getFieldRequired(Class<?> clazz, String fieldName) {
        ApiModelProperty property = this.getApiModelProperty(clazz, fieldName);
        return property != null && property.required();
    }

    private boolean getFieldReadOnly(Class<?> clazz, String fieldName) {
        ApiModelProperty property = this.getApiModelProperty(clazz, fieldName);
        return property != null && property.readOnly();
    }

    private String getFieldExample(Class<?> clazz, String fieldName) {
        ApiModelProperty property = this.getApiModelProperty(clazz, fieldName);
        return property == null ? "" : property.example();
    }

    private String getFieldDescription(Class<?> clazz, String fieldName) {
        ApiModelProperty property = this.getApiModelProperty(clazz, fieldName);
        return property == null ? "" : property.value();
    }

    protected String getClassPermissions(Class<?> clazz) {
        String createPermissions = this.getCreatePermission(clazz);
        String deletePermissions = this.getDeletePermission(clazz);
        createPermissions = createPermissions == null ? "" : "Create Permissions : (" + createPermissions + ")";
        deletePermissions = deletePermissions == null ? "" : "Delete Permissions : (" + deletePermissions + ")";
        return this.joinNonEmpty("\n", createPermissions, deletePermissions);
    }

    private String joinNonEmpty(String delimiter, String ... elements) {
        return Arrays.stream(elements).filter(StringUtils::isNotBlank).collect(Collectors.joining(delimiter));
    }

    protected String getFieldPermissions(Class<?> clazz, String fieldName) {
        String readPermissions = this.getReadPermission(clazz, fieldName);
        String updatePermissions = this.getUpdatePermission(clazz, fieldName);
        readPermissions = readPermissions == null ? "" : "Read Permissions : (" + readPermissions + ")";
        updatePermissions = updatePermissions == null ? "" : "Update Permissions : (" + updatePermissions + ")";
        return this.joinNonEmpty("\n", readPermissions, updatePermissions);
    }

    protected String getReadPermission(Class<?> clazz, String fieldName) {
        ReadPermission classPermission = (ReadPermission)this.dictionary.getAnnotation(clazz, ReadPermission.class);
        ReadPermission fieldPermission = (ReadPermission)this.dictionary.getAttributeOrRelationAnnotation(clazz, ReadPermission.class, fieldName);
        if (fieldPermission != null) {
            return fieldPermission.expression();
        }
        if (classPermission != null) {
            return classPermission.expression();
        }
        return null;
    }

    protected String getUpdatePermission(Class<?> clazz, String fieldName) {
        UpdatePermission classPermission = (UpdatePermission)this.dictionary.getAnnotation(clazz, UpdatePermission.class);
        UpdatePermission fieldPermission = (UpdatePermission)this.dictionary.getAttributeOrRelationAnnotation(clazz, UpdatePermission.class, fieldName);
        if (fieldPermission != null) {
            return fieldPermission.expression();
        }
        if (classPermission != null) {
            return classPermission.expression();
        }
        return null;
    }

    protected String getCreatePermission(Class<?> clazz) {
        CreatePermission classPermission = (CreatePermission)this.dictionary.getAnnotation(clazz, CreatePermission.class);
        if (classPermission != null) {
            return classPermission.expression();
        }
        return null;
    }

    protected String getDeletePermission(Class<?> clazz) {
        DeletePermission classPermission = (DeletePermission)this.dictionary.getAnnotation(clazz, DeletePermission.class);
        if (classPermission != null) {
            return classPermission.expression();
        }
        return null;
    }
}

