/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.contrib.swagger.resources;

import com.yahoo.elide.contrib.swagger.SwaggerBuilder;
import io.swagger.models.Swagger;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/doc")
@Produces(value={"application/json"})
public class DocEndpoint {
    protected Map<String, String> documents = new HashMap<String, String>();

    @Inject
    public DocEndpoint(@Named(value="swagger") Map<String, Swagger> docs) {
        docs.forEach((key, value) -> this.documents.put((String)key, SwaggerBuilder.getDocument(value)));
    }

    @GET
    @Path(value="/")
    public Response list() {
        String body = "[" + this.documents.keySet().stream().map(key -> '\"' + key + '\"').collect(Collectors.joining(",")) + "]";
        return Response.ok((Object)body).build();
    }

    @GET
    @Path(value="/{name}")
    public Response get(@PathParam(value="name") String name) {
        if (this.documents.containsKey(name)) {
            return Response.ok((Object)this.documents.get(name)).build();
        }
        return Response.status((int)404).entity((Object)("Unknown document: " + name)).build();
    }
}

