/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.swagger;

import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.Json31;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.core.util.Yaml31;
import io.swagger.v3.oas.models.OpenAPI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class OpenApiDocument {
    public static final String DEFAULT_TITLE = "Elide Service";
    private final Map<String, String> documents = new ConcurrentHashMap<String, String>(2);
    private final Supplier<OpenAPI> openApi;
    private final Version version;

    public OpenApiDocument(OpenAPI openApi, Version version) {
        this(() -> openApi, version);
    }

    public OpenApiDocument(Supplier<OpenAPI> openApi, Version version) {
        this.openApi = openApi;
        this.version = version;
    }

    public String ofMediaType(String mediaType) {
        String key = mediaType;
        key = "application/yaml".equalsIgnoreCase(key) ? "application/yaml" : "application/json";
        return this.documents.computeIfAbsent(key, type -> OpenApiDocument.of(this.openApi.get(), this.version, type));
    }

    public static String of(OpenAPI openApi, Version version, String mediaType) {
        if ("application/yaml".equalsIgnoreCase(mediaType)) {
            if (Version.OPENAPI_3_1.equals((Object)version)) {
                return Yaml31.pretty((Object)openApi);
            }
            return Yaml.pretty((Object)openApi);
        }
        if (Version.OPENAPI_3_1.equals((Object)version)) {
            return Json31.pretty((Object)openApi);
        }
        return Json.pretty((Object)openApi);
    }

    public static enum Version {
        OPENAPI_3_0("3.0"),
        OPENAPI_3_1("3.1");

        private final String value;

        private Version(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static Version from(String version) {
            if (version.startsWith(OPENAPI_3_1.getValue())) {
                return OPENAPI_3_1;
            }
            if (version.startsWith(OPENAPI_3_0.getValue())) {
                return OPENAPI_3_0;
            }
            throw new IllegalArgumentException("Invalid OpenAPI version. Only versions 3.0 and 3.1 are supported.");
        }
    }

    public static class MediaType {
        public static final String APPLICATION_JSON = "application/json";
        public static final String APPLICATION_YAML = "application/yaml";

        private MediaType() {
        }
    }
}

