/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.swagger.converter;

import com.fasterxml.jackson.databind.type.SimpleType;
import com.google.common.base.Preconditions;
import com.yahoo.elide.annotation.CreatePermission;
import com.yahoo.elide.annotation.DeletePermission;
import com.yahoo.elide.annotation.Include;
import com.yahoo.elide.annotation.ReadPermission;
import com.yahoo.elide.annotation.UpdatePermission;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.type.ClassType;
import com.yahoo.elide.core.utils.coerce.converters.Serde;
import com.yahoo.elide.swagger.models.media.Relationship;
import com.yahoo.elide.swagger.models.media.Resource;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverterContext;
import io.swagger.v3.core.jackson.ModelResolver;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.annotations.media.Schema;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class JsonApiModelResolver
extends ModelResolver {
    private final EntityDictionary dictionary;

    public JsonApiModelResolver(EntityDictionary dictionary) {
        super(Json.mapper());
        this.dictionary = dictionary;
    }

    public io.swagger.v3.oas.models.media.Schema<?> resolve(AnnotatedType annotatedType, ModelConverterContext context, Iterator<ModelConverter> next) {
        Type type = annotatedType.getType();
        if (!(type instanceof Class || type instanceof SimpleType || type instanceof com.yahoo.elide.core.type.Type)) {
            return super.resolve(annotatedType, context, next);
        }
        com.yahoo.elide.core.type.Type clazzType = null;
        if (type instanceof SimpleType) {
            type = ((SimpleType)type).getRawClass();
            clazzType = ClassType.of((Class)((Class)type));
        } else if (type instanceof com.yahoo.elide.core.type.Type) {
            clazzType = (com.yahoo.elide.core.type.Type)type;
        } else if (type instanceof Class) {
            clazzType = ClassType.of((Class)((Class)type));
        }
        if (!this.dictionary.hasBinding(clazzType) || !this.dictionary.getEntityBinding(clazzType).isElideModel()) {
            return super.resolve(annotatedType, context, next);
        }
        return this.getEntitySchema(clazzType, context, next);
    }

    private Resource getEntitySchema(com.yahoo.elide.core.type.Type<?> clazzType, ModelConverterContext context, Iterator<ModelConverter> next) {
        Schema schema;
        Resource entitySchema = new Resource();
        entitySchema.name(this.dictionary.getJsonAliasFor(clazzType));
        entitySchema.description(this.getSchemaDescription(clazzType));
        entitySchema.setSecurityDescription(this.getClassPermissions(clazzType));
        Include include = this.getInclude(clazzType);
        if (include != null && !StringUtils.isBlank((CharSequence)include.friendlyName())) {
            entitySchema.setTitle(include.friendlyName());
        }
        if ((schema = this.getSchema(clazzType)) != null && !StringUtils.isBlank((CharSequence)schema.title())) {
            entitySchema.setTitle(schema.title());
        }
        this.populateAttributes(entitySchema, clazzType, context, next);
        this.populateRelationships(entitySchema, clazzType);
        return entitySchema;
    }

    private void populateAttributes(Resource entitySchema, com.yahoo.elide.core.type.Type<?> clazzType, ModelConverterContext context, Iterator<ModelConverter> next) {
        ArrayList<String> requiredAttributes = new ArrayList<String>();
        List attributeNames = this.dictionary.getAttributes(clazzType);
        for (String attributeName : attributeNames) {
            com.yahoo.elide.core.type.Type attributeType = this.dictionary.getType(clazzType, attributeName);
            io.swagger.v3.oas.models.media.Schema<?> attribute = this.processAttribute(clazzType, attributeName, attributeType, context, next, requiredAttributes);
            entitySchema.addAttribute(attributeName, attribute);
        }
        if (!requiredAttributes.isEmpty()) {
            entitySchema.getAttributes().required(requiredAttributes);
        }
    }

    private void populateRelationships(Resource entitySchema, com.yahoo.elide.core.type.Type<?> clazzType) {
        Schema schema;
        ArrayList<String> requiredRelationships = new ArrayList<String>();
        List relationshipNames = this.dictionary.getRelationships(clazzType);
        for (String relationshipName : relationshipNames) {
            com.yahoo.elide.core.type.Type relationshipType;
            Relationship relationship = this.processRelationship(clazzType, relationshipName, relationshipType = this.dictionary.getParameterizedType(clazzType, relationshipName), requiredRelationships);
            if (relationship == null) continue;
            entitySchema.addRelationship(relationshipName, relationship);
        }
        if (!requiredRelationships.isEmpty()) {
            entitySchema.getRelationships().required(requiredRelationships);
        }
        entitySchema.name(this.getSchemaName(clazzType));
        Include include = this.getInclude(clazzType);
        if (include != null && !StringUtils.isBlank((CharSequence)include.friendlyName())) {
            entitySchema.setTitle(include.friendlyName());
        }
        if ((schema = this.getSchema(clazzType)) != null && !StringUtils.isBlank((CharSequence)schema.title())) {
            entitySchema.setTitle(schema.title());
        }
    }

    protected String getSchemaName(com.yahoo.elide.core.type.Type<?> type) {
        Object schemaName = this.dictionary.getJsonAliasFor(type);
        String apiVersion = EntityDictionary.getModelVersion(type);
        if (!"".equals(apiVersion)) {
            schemaName = "v" + apiVersion + "_" + (String)schemaName;
        }
        return schemaName;
    }

    private Class<?> getSerdeSerializedClass(Serde serde) {
        Class attributeTypeClass = Object.class;
        try {
            for (Type type : serde.getClass().getGenericInterfaces()) {
                ParameterizedType parameterizedType;
                if (!(type instanceof ParameterizedType) || !Serde.class.equals((Object)(parameterizedType = (ParameterizedType)type).getRawType())) continue;
                attributeTypeClass = (Class)parameterizedType.getActualTypeArguments()[0];
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            if (Object.class.equals(attributeTypeClass)) {
                for (Method method : serde.getClass().getDeclaredMethods()) {
                    Class<?> returnType;
                    if (!"serialize".equals(method.getName()) || Object.class.equals(returnType = method.getReturnType())) continue;
                    return returnType;
                }
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return attributeTypeClass;
    }

    private io.swagger.v3.oas.models.media.Schema<?> processAttribute(com.yahoo.elide.core.type.Type<?> clazzType, String attributeName, com.yahoo.elide.core.type.Type<?> attributeType, ModelConverterContext context, Iterator<ModelConverter> next, List<String> required) {
        io.swagger.v3.oas.models.media.Schema attribute;
        Preconditions.checkState((boolean)(attributeType instanceof ClassType));
        Class<?> attributeTypeClass = ((ClassType)attributeType).getCls();
        Serde serde = (Serde)this.dictionary.getSerdeLookup().apply(attributeTypeClass);
        if (serde != null) {
            attributeTypeClass = this.getSerdeSerializedClass(serde);
        }
        if ((attribute = super.resolve(new AnnotatedType().type(attributeTypeClass), context, next)) == null) {
            attribute = super.resolve(new AnnotatedType().resolveAsRef(true).type(attributeTypeClass), context, next);
        }
        String description = this.getFieldDescription(clazzType, attributeName);
        String permissions = this.getFieldPermissions(clazzType, attributeName);
        attribute.setDescription((String)StringUtils.defaultIfEmpty((CharSequence)this.joinNonEmpty("\n", description, permissions), null));
        attribute.setExample((Object)StringUtils.defaultIfEmpty((CharSequence)this.getFieldExample(clazzType, attributeName), null));
        attribute.setReadOnly(Boolean.valueOf(this.getFieldReadOnly(clazzType, attributeName)));
        attribute.setWriteOnly(Boolean.valueOf(this.getFieldWriteOnly(clazzType, attributeName)));
        attribute.setRequired(this.getFieldRequiredProperties(clazzType, attributeName));
        if (this.getFieldRequired(clazzType, attributeName)) {
            required.add(attributeName);
        }
        return attribute;
    }

    private Relationship processRelationship(com.yahoo.elide.core.type.Type<?> clazz, String relationshipName, com.yahoo.elide.core.type.Type<?> relationshipClazz, List<String> required) {
        Relationship relationship = null;
        try {
            relationship = new Relationship(this.dictionary.getJsonAliasFor(relationshipClazz));
        }
        catch (IllegalArgumentException e) {
            return relationship;
        }
        String description = this.getFieldDescription(clazz, relationshipName);
        String permissions = this.getFieldPermissions(clazz, relationshipName);
        relationship.setDescription((String)StringUtils.defaultIfEmpty((CharSequence)this.joinNonEmpty("\n", description, permissions), null));
        relationship.setExample(StringUtils.defaultIfEmpty((CharSequence)this.getFieldExample(clazz, relationshipName), null));
        relationship.setReadOnly(this.getFieldReadOnly(clazz, relationshipName));
        relationship.setWriteOnly(this.getFieldWriteOnly(clazz, relationshipName));
        relationship.setRequired(this.getFieldRequiredProperties(clazz, relationshipName));
        if (this.getFieldRequired(clazz, relationshipName)) {
            required.add(relationshipName);
        }
        return relationship;
    }

    private Include getInclude(com.yahoo.elide.core.type.Type<?> clazz) {
        return (Include)this.dictionary.getAnnotation(clazz, Include.class);
    }

    private Schema getSchema(com.yahoo.elide.core.type.Type<?> clazz) {
        return (Schema)this.dictionary.getAnnotation(clazz, Schema.class);
    }

    private String getSchemaDescription(com.yahoo.elide.core.type.Type<?> clazz) {
        Schema schema = this.getSchema(clazz);
        if (schema == null) {
            String description = EntityDictionary.getEntityDescription(clazz);
            if (StringUtils.isEmpty((CharSequence)description)) {
                return null;
            }
            return description;
        }
        return schema.description();
    }

    private Schema getSchema(com.yahoo.elide.core.type.Type<?> clazz, String fieldName) {
        return (Schema)this.dictionary.getAttributeOrRelationAnnotation(clazz, Schema.class, fieldName);
    }

    private List<String> getFieldRequiredProperties(com.yahoo.elide.core.type.Type<?> clazz, String fieldName) {
        Schema property = this.getSchema(clazz, fieldName);
        return property != null ? Arrays.asList(property.requiredProperties()) : Collections.emptyList();
    }

    private boolean getFieldRequired(com.yahoo.elide.core.type.Type<?> clazz, String fieldName) {
        Schema property = this.getSchema(clazz, fieldName);
        return property != null && (Schema.RequiredMode.REQUIRED.equals((Object)property.requiredMode()) || property.required());
    }

    private boolean getFieldReadOnly(com.yahoo.elide.core.type.Type<?> clazz, String fieldName) {
        Schema property = this.getSchema(clazz, fieldName);
        return property != null && (Schema.AccessMode.READ_ONLY.equals((Object)property.accessMode()) || property.readOnly());
    }

    private boolean getFieldWriteOnly(com.yahoo.elide.core.type.Type<?> clazz, String fieldName) {
        Schema property = this.getSchema(clazz, fieldName);
        return property != null && (Schema.AccessMode.WRITE_ONLY.equals((Object)property.accessMode()) || property.writeOnly());
    }

    private String getFieldExample(com.yahoo.elide.core.type.Type<?> clazz, String fieldName) {
        Schema property = this.getSchema(clazz, fieldName);
        return property == null ? "" : property.example();
    }

    private String getFieldDescription(com.yahoo.elide.core.type.Type<?> clazz, String fieldName) {
        Schema property = this.getSchema(clazz, fieldName);
        return property == null ? "" : property.description();
    }

    protected String getClassPermissions(com.yahoo.elide.core.type.Type<?> clazz) {
        Object createPermissions = this.getCreatePermission(clazz);
        Object deletePermissions = this.getDeletePermission(clazz);
        createPermissions = createPermissions == null ? "" : "Create Permissions : (" + (String)createPermissions + ")";
        deletePermissions = deletePermissions == null ? "" : "Delete Permissions : (" + (String)deletePermissions + ")";
        return this.joinNonEmpty("\n", new String[]{createPermissions, deletePermissions});
    }

    private String joinNonEmpty(String delimiter, String ... elements) {
        return Arrays.stream(elements).filter(StringUtils::isNotBlank).collect(Collectors.joining(delimiter));
    }

    protected String getFieldPermissions(com.yahoo.elide.core.type.Type<?> clazz, String fieldName) {
        Object readPermissions = this.getReadPermission(clazz, fieldName);
        Object updatePermissions = this.getUpdatePermission(clazz, fieldName);
        readPermissions = readPermissions == null ? "" : "Read Permissions : (" + (String)readPermissions + ")";
        updatePermissions = updatePermissions == null ? "" : "Update Permissions : (" + (String)updatePermissions + ")";
        return this.joinNonEmpty("\n", new String[]{readPermissions, updatePermissions});
    }

    protected String getReadPermission(com.yahoo.elide.core.type.Type<?> clazz, String fieldName) {
        ReadPermission classPermission = (ReadPermission)this.dictionary.getAnnotation(clazz, ReadPermission.class);
        ReadPermission fieldPermission = (ReadPermission)this.dictionary.getAttributeOrRelationAnnotation(clazz, ReadPermission.class, fieldName);
        if (fieldPermission != null) {
            return fieldPermission.expression();
        }
        if (classPermission != null) {
            return classPermission.expression();
        }
        return null;
    }

    protected String getUpdatePermission(com.yahoo.elide.core.type.Type<?> clazz, String fieldName) {
        UpdatePermission classPermission = (UpdatePermission)this.dictionary.getAnnotation(clazz, UpdatePermission.class);
        UpdatePermission fieldPermission = (UpdatePermission)this.dictionary.getAttributeOrRelationAnnotation(clazz, UpdatePermission.class, fieldName);
        if (fieldPermission != null) {
            return fieldPermission.expression();
        }
        if (classPermission != null) {
            return classPermission.expression();
        }
        return null;
    }

    protected String getCreatePermission(com.yahoo.elide.core.type.Type<?> clazz) {
        CreatePermission classPermission = (CreatePermission)this.dictionary.getAnnotation(clazz, CreatePermission.class);
        if (classPermission != null) {
            return classPermission.expression();
        }
        return null;
    }

    protected String getDeletePermission(com.yahoo.elide.core.type.Type<?> clazz) {
        DeletePermission classPermission = (DeletePermission)this.dictionary.getAnnotation(clazz, DeletePermission.class);
        if (classPermission != null) {
            return classPermission.expression();
        }
        return null;
    }
}

