/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.swagger.resources;

import com.yahoo.elide.Elide;
import com.yahoo.elide.ElideSettings;
import com.yahoo.elide.core.request.route.ApiVersionValidator;
import com.yahoo.elide.core.request.route.BasicApiVersionValidator;
import com.yahoo.elide.core.request.route.FlexibleRouteResolver;
import com.yahoo.elide.core.request.route.NullRouteResolver;
import com.yahoo.elide.core.request.route.Route;
import com.yahoo.elide.core.request.route.RouteResolver;
import com.yahoo.elide.swagger.OpenApiDocument;
import io.swagger.v3.oas.models.OpenAPI;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

@Path(value="/")
public class ApiDocsEndpoint {
    protected Map<Pair<String, String>, OpenApiDocument> documents = new HashMap<Pair<String, String>, OpenApiDocument>();
    protected final RouteResolver routeResolver;

    @Inject
    public ApiDocsEndpoint(@Named(value="apiDocs") List<ApiDocsRegistration> docs, @Named(value="elide") Elide elide, Optional<RouteResolver> optionalRouteResolver) {
        docs.forEach(doc -> {
            String apiVersion = doc.getApiVersion();
            apiVersion = apiVersion == null ? "" : apiVersion;
            String apiPath = doc.path;
            this.documents.put((Pair<String, String>)Pair.of((Object)apiVersion, (Object)apiPath), new OpenApiDocument(doc.document, OpenApiDocument.Version.from(doc.version)));
        });
        this.routeResolver = optionalRouteResolver.orElseGet(() -> {
            Set apiVersions = elide.getElideSettings().getEntityDictionary().getApiVersions();
            if (apiVersions.size() == 1 && apiVersions.contains("")) {
                return new NullRouteResolver();
            }
            return new FlexibleRouteResolver((ApiVersionValidator)new BasicApiVersionValidator(), () -> ((ElideSettings)elide.getElideSettings()).getBaseUrl());
        });
    }

    @GET
    @Path(value="{path:.*}")
    @Produces(value={"application/json"})
    public Response listJson(@PathParam(value="path") String path, @Context UriInfo uriInfo, @Context HttpHeaders headers) {
        Route route = this.routeResolver.resolve("application/json", "", path, (Map)headers.getRequestHeaders(), (Map)uriInfo.getQueryParameters());
        String name = route.getPath();
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (name.isBlank()) {
            return this.list(route.getApiVersion(), "application/json");
        }
        return this.get(route.getApiVersion(), name, "application/json");
    }

    @GET
    @Produces(value={"application/json"})
    public Response listJson(@Context UriInfo uriInfo, @Context HttpHeaders headers) {
        return this.listJson("", uriInfo, headers);
    }

    @GET
    @Path(value="{path:.*}")
    @Produces(value={"application/yaml"})
    public Response listYaml(@PathParam(value="path") String path, @Context UriInfo uriInfo, @Context HttpHeaders headers) {
        Route route = this.routeResolver.resolve("application/yaml", "", path, (Map)headers.getRequestHeaders(), (Map)uriInfo.getQueryParameters());
        String name = route.getPath();
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (name.isBlank()) {
            return this.list(route.getApiVersion(), "application/yaml");
        }
        return this.get(route.getApiVersion(), name, "application/yaml");
    }

    @GET
    @Produces(value={"application/yaml"})
    public Response listYaml(@Context UriInfo uriInfo, @Context HttpHeaders headers) {
        return this.listYaml("", uriInfo, headers);
    }

    public Response list(String apiVersion, String mediaType) {
        Optional<Pair> pair;
        String safeApiVersion = apiVersion == null ? "" : apiVersion;
        List<String> documentPaths = this.documents.keySet().stream().filter(key -> ((String)key.getLeft()).equals(safeApiVersion)).map(Pair::getRight).toList();
        if (documentPaths.size() == 1 && (pair = this.documents.keySet().stream().filter(key -> ((String)key.getLeft()).equals(safeApiVersion)).findFirst()).isPresent()) {
            return Response.ok((Object)this.documents.get(pair.get()).ofMediaType(mediaType)).build();
        }
        String body = documentPaths.stream().map(key -> "\"" + key + "\"").collect(Collectors.joining(",", "[", "]"));
        return Response.ok((Object)body).build();
    }

    public Response get(String apiVersion, String name, String mediaType) {
        String safeApiVersion = apiVersion == null ? "" : apiVersion;
        Pair lookupKey = Pair.of((Object)safeApiVersion, (Object)name);
        if (this.documents.containsKey(lookupKey)) {
            return Response.ok((Object)this.documents.get(lookupKey).ofMediaType(mediaType)).build();
        }
        return Response.status((int)404).entity((Object)("Unknown document: " + name)).build();
    }

    public static class ApiDocsRegistration {
        private String path;
        private Supplier<OpenAPI> document;
        private String version;
        private String apiVersion;

        public String getPath() {
            return this.path;
        }

        public Supplier<OpenAPI> getDocument() {
            return this.document;
        }

        public String getVersion() {
            return this.version;
        }

        public String getApiVersion() {
            return this.apiVersion;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public void setDocument(Supplier<OpenAPI> document) {
            this.document = document;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public void setApiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ApiDocsRegistration)) {
                return false;
            }
            ApiDocsRegistration other = (ApiDocsRegistration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            Supplier<OpenAPI> this$document = this.getDocument();
            Supplier<OpenAPI> other$document = other.getDocument();
            if (this$document == null ? other$document != null : !this$document.equals(other$document)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$apiVersion = this.getApiVersion();
            String other$apiVersion = other.getApiVersion();
            return !(this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ApiDocsRegistration;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            Supplier<OpenAPI> $document = this.getDocument();
            result = result * 59 + ($document == null ? 43 : $document.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $apiVersion = this.getApiVersion();
            result = result * 59 + ($apiVersion == null ? 43 : $apiVersion.hashCode());
            return result;
        }

        public String toString() {
            return "ApiDocsEndpoint.ApiDocsRegistration(path=" + this.getPath() + ", document=" + this.getDocument() + ", version=" + this.getVersion() + ", apiVersion=" + this.getApiVersion() + ")";
        }

        public ApiDocsRegistration(String path, Supplier<OpenAPI> document, String version, String apiVersion) {
            this.path = path;
            this.document = document;
            this.version = version;
            this.apiVersion = apiVersion;
        }
    }
}

