/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.contrib.testhelpers.graphql.elements;

import com.yahoo.elide.contrib.testhelpers.graphql.elements.Definition;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;

public class Document
implements Serializable {
    private static final long serialVersionUID = -1388610970958604545L;
    @NonNull
    private final List<Definition> definitions;

    public String toQuery() {
        return this.getDefinitions().stream().map(Definition::toGraphQLSpec).collect(Collectors.joining(" "));
    }

    public String toResponse() {
        String response = this.getDefinitions().stream().map(definition -> String.format("{\"data\":%s}", definition.toResponse())).collect(Collectors.joining(", "));
        if (this.getDefinitions().size() != 1) {
            return String.format("[%s]", response);
        }
        return response;
    }

    public Document(@NonNull List<Definition> definitions) {
        if (definitions == null) {
            throw new NullPointerException("definitions is marked non-null but is null");
        }
        this.definitions = definitions;
    }

    @NonNull
    private List<Definition> getDefinitions() {
        return this.definitions;
    }
}

