/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.contrib.testhelpers.graphql.elements;

import com.yahoo.elide.contrib.testhelpers.graphql.elements.Node;
import com.yahoo.elide.contrib.testhelpers.graphql.elements.Selection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;

public class Edges
extends Selection {
    private static final long serialVersionUID = 1860183539630769326L;
    @NonNull
    private final List<Node> nodes;

    @Override
    public String toGraphQLSpec() {
        return String.format("edges {%s}", this.getNodes().get(0).toGraphQLSpec());
    }

    @Override
    public String toResponse() {
        return String.format("\"edges\":[%s]", Edges.attachNodes(this.getNodes()));
    }

    private static String attachNodes(List<Node> nodes) {
        if (nodes.isEmpty()) {
            return "";
        }
        return nodes.stream().map(Node::toResponse).collect(Collectors.joining(","));
    }

    public Edges(@NonNull List<Node> nodes) {
        if (nodes == null) {
            throw new NullPointerException("nodes is marked non-null but is null");
        }
        this.nodes = nodes;
    }

    @NonNull
    public List<Node> getNodes() {
        return this.nodes;
    }
}

