/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.contrib.testhelpers.graphql.elements;

import com.yahoo.elide.contrib.testhelpers.graphql.elements.Definition;
import com.yahoo.elide.contrib.testhelpers.graphql.elements.SelectionSet;
import com.yahoo.elide.contrib.testhelpers.graphql.elements.VariableDefinitions;
import lombok.NonNull;

public abstract class TypedOperation
extends Definition {
    private static final long serialVersionUID = 5049217577677973567L;
    @NonNull
    private final String operationType;
    private final String name;
    private final VariableDefinitions variableDefinitions;
    @NonNull
    private final SelectionSet selectionSet;

    @Override
    public String toGraphQLSpec() {
        return String.format("%s %s%s%s", this.getOperationType(), this.getName() == null ? "" : this.getName(), this.getVariableDefinitions() == null ? "" : this.getVariableDefinitions().toGraphQLSpec() + " ", this.getSelectionSet().toGraphQLSpec());
    }

    public TypedOperation(@NonNull String operationType, String name, VariableDefinitions variableDefinitions, @NonNull SelectionSet selectionSet) {
        if (operationType == null) {
            throw new NullPointerException("operationType is marked non-null but is null");
        }
        if (selectionSet == null) {
            throw new NullPointerException("selectionSet is marked non-null but is null");
        }
        this.operationType = operationType;
        this.name = name;
        this.variableDefinitions = variableDefinitions;
        this.selectionSet = selectionSet;
    }

    @NonNull
    private String getOperationType() {
        return this.operationType;
    }

    private String getName() {
        return this.name;
    }

    private VariableDefinitions getVariableDefinitions() {
        return this.variableDefinitions;
    }

    @NonNull
    private SelectionSet getSelectionSet() {
        return this.selectionSet;
    }
}

