/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.contrib.testhelpers.graphql.elements;

import com.yahoo.elide.contrib.testhelpers.graphql.elements.Definition;
import java.util.Objects;
import lombok.NonNull;

public class VariableDefinition
extends Definition {
    private static final long serialVersionUID = -899567129301468808L;
    @NonNull
    private final String variable;
    @NonNull
    private final String type;
    private final Object defaultValue;

    @Override
    public String toGraphQLSpec() {
        return String.format("$%s: %s%s", this.getVariable(), this.getType(), Objects.isNull(this.getDefaultValue()) ? "" : String.format("=%s", this.getDefaultValue()));
    }

    public VariableDefinition(@NonNull String variable, @NonNull String type, Object defaultValue) {
        if (variable == null) {
            throw new NullPointerException("variable is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.variable = variable;
        this.type = type;
        this.defaultValue = defaultValue;
    }

    @NonNull
    private String getVariable() {
        return this.variable;
    }

    @NonNull
    private String getType() {
        return this.type;
    }

    private Object getDefaultValue() {
        return this.defaultValue;
    }
}

