/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.test.graphql;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.yahoo.elide.test.graphql.elements.Argument;
import com.yahoo.elide.test.graphql.elements.Arguments;
import com.yahoo.elide.test.graphql.elements.Definition;
import com.yahoo.elide.test.graphql.elements.Document;
import com.yahoo.elide.test.graphql.elements.Edges;
import com.yahoo.elide.test.graphql.elements.Field;
import com.yahoo.elide.test.graphql.elements.Mutation;
import com.yahoo.elide.test.graphql.elements.Node;
import com.yahoo.elide.test.graphql.elements.Query;
import com.yahoo.elide.test.graphql.elements.Selection;
import com.yahoo.elide.test.graphql.elements.SelectionSet;
import com.yahoo.elide.test.graphql.elements.VariableDefinition;
import com.yahoo.elide.test.graphql.elements.VariableDefinitions;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;

public final class GraphQLDSL {
    public static final boolean QUOTE_VALUE = true;
    public static final boolean UNQUOTED_VALUE = false;
    private static final ObjectMapper BASE_MAPPER = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).setSerializationInclusion(JsonInclude.Include.NON_DEFAULT).setSerializationInclusion(JsonInclude.Include.NON_EMPTY);

    public static String toJson(Object object) {
        try {
            return BASE_MAPPER.writer().writeValueAsString(object);
        }
        catch (JsonProcessingException exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    public static Document document(Definition ... definitions) {
        return new Document(Arrays.asList(definitions));
    }

    public static SelectionSet selection(Selection selection) {
        return new SelectionSet(new LinkedHashSet<Selection>(Collections.singleton(selection)));
    }

    public static SelectionSet selections(Selection ... selections) {
        return new SelectionSet(Arrays.stream(selections).collect(Collectors.toCollection(LinkedHashSet::new)));
    }

    public static Mutation mutation(String name, VariableDefinitions variableDefinitions, SelectionSet selectionSet) {
        return new Mutation(name, variableDefinitions, selectionSet);
    }

    public static Mutation mutation(SelectionSet selectionSet) {
        return new Mutation(null, null, selectionSet);
    }

    public static Query query(String name, VariableDefinitions variableDefinitions, SelectionSet selectionSet) {
        return new Query(name, variableDefinitions, selectionSet);
    }

    public static Query query(SelectionSet selectionSet) {
        return new Query(null, null, selectionSet);
    }

    public static VariableDefinitions variableDefinitions(VariableDefinition ... variableDefinitions) {
        return new VariableDefinitions(Arrays.asList(variableDefinitions));
    }

    public static VariableDefinition variableDefinition(String variable, String type) {
        return new VariableDefinition(variable, type, null);
    }

    public static Selection field(String name, String value) {
        return new Field(null, name, Arguments.emptyArgument(), (Serializable)((Object)Field.quoteValue(value)));
    }

    public static Selection field(String name, Number value) {
        return new Field(null, name, Arguments.emptyArgument(), value);
    }

    public static Selection field(String name, Boolean value) {
        return new Field(null, name, Arguments.emptyArgument(), value);
    }

    public static Selection field(String name, String value, boolean quoted) {
        return new Field(null, name, Arguments.emptyArgument(), (Serializable)((Object)(quoted ? Field.quoteValue(value) : value)));
    }

    public static Selection field(String name, SelectionSet ... selectionSet) {
        return GraphQLDSL.field(null, name, selectionSet);
    }

    public static Selection field(String alias, String name, SelectionSet ... selectionSet) {
        ImmutableList ss = ImmutableList.copyOf((Object[])selectionSet);
        return new Field(alias, name, Arguments.emptyArgument(), GraphQLDSL.relayWrap((List<SelectionSet>)ss));
    }

    public static Selection field(String name, Arguments arguments, SelectionSet ... selectionSet) {
        return new Field(null, name, arguments, GraphQLDSL.relayWrap(Arrays.asList(selectionSet)));
    }

    public static Selection field(String alias, String name, Arguments arguments, SelectionSet ... selectionSet) {
        return new Field(alias, name, arguments, GraphQLDSL.relayWrap(Arrays.asList(selectionSet)));
    }

    public static Selection field(String name) {
        return Field.scalarField(name);
    }

    public static Selection field(String name, Arguments arguments) {
        return new Field(null, name, arguments, null);
    }

    public static Selection field(String name, String alias, Arguments arguments) {
        return new Field(alias, name, arguments, null);
    }

    public static Arguments arguments(Argument ... arguments) {
        return new Arguments(Arrays.asList(arguments));
    }

    public static Arguments argument(Argument argument) {
        return new Arguments(Collections.singletonList(argument));
    }

    public static Argument argument(String name, Object value) {
        return GraphQLDSL.argument(name, value, false);
    }

    public static Argument argument(String name, Object value, boolean quoted) {
        if (value instanceof String) {
            value = quoted ? Field.quoteValue(value.toString()) : value;
            return new Argument(name, value);
        }
        try {
            return new Argument(name, BASE_MAPPER.configure(JsonGenerator.Feature.QUOTE_FIELD_NAMES, false).writeValueAsString(value));
        }
        catch (JsonProcessingException exception) {
            throw new IllegalStateException(String.format("Cannot serialize %s", value), exception);
        }
    }

    private static SelectionSet relayWrap(List<SelectionSet> selectionSet) {
        Edges edges = new Edges(selectionSet.stream().map(Node::new).collect(Collectors.toList()));
        return new SelectionSet(new LinkedHashSet<Selection>(Collections.singleton(edges)));
    }
}

