/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.test.graphql.elements;

import com.yahoo.elide.test.graphql.elements.Definition;
import com.yahoo.elide.test.graphql.elements.Selection;
import com.yahoo.elide.test.graphql.elements.SelectionSet;
import java.util.stream.Collectors;
import lombok.NonNull;

public class Node
extends Selection {
    private static final long serialVersionUID = 2525022170227460587L;
    @NonNull
    private final SelectionSet fields;

    @Override
    public String toGraphQLSpec() {
        return String.format("node %s", this.getFields().toGraphQLSpec());
    }

    @Override
    public String toResponse() {
        return String.format("{\"node\":{%s}}", Node.serializeNode(this));
    }

    private static String serializeNode(Node node) {
        return node.getFields().getSelections().stream().map(Definition::toResponse).collect(Collectors.joining(","));
    }

    public Node(@NonNull SelectionSet fields) {
        if (fields == null) {
            throw new NullPointerException("fields is marked non-null but is null");
        }
        this.fields = fields;
    }

    @NonNull
    public SelectionSet getFields() {
        return this.fields;
    }
}

