//
// This file generated by rdl 1.5.1. Do not modify!
//

package com.yahoo.rdl;

public class RdlSchema {

    private final static Schema INSTANCE = build();
    public static Schema instance() {
        return INSTANCE;
    }

    private static Schema build() {
        SchemaBuilder sb = new SchemaBuilder("rdl");
        sb.version(3);
        sb.comment("This defines the schema for a schema, the output of the RDL parser. This can be used to represent schemas in JSON, Protobuf, Avro, etc, from a single definition.");

        sb.stringType("Identifier")
            .comment("All names need to be of this restricted string type")
            .pattern("[a-zA-Z_]+[a-zA-Z_0-9]*");

        sb.stringType("NamespacedIdentifier")
            .comment("A Namespace is a dotted compound name, using reverse domain name order (i.e. \"com.yahoo.auth\")")
            .pattern("([a-zA-Z_]+[a-zA-Z_0-9]*)(\\.[a-zA-Z_]+[a-zA-Z_0-9])*");

    

    

        sb.enumType("BaseType")
            .element("Bool")
            .element("Int8")
            .element("Int16")
            .element("Int32")
            .element("Int64")
            .element("Float32")
            .element("Float64")
            .element("Bytes")
            .element("String")
            .element("Timestamp")
            .element("Symbol")
            .element("UUID")
            .element("Array")
            .element("Map")
            .element("Struct")
            .element("Enum")
            .element("Union")
            .element("Any");

        sb.stringType("ExtendedAnnotation")
            .comment("ExtendedAnnotation - parsed and preserved, but has no defined meaning in RDL. Such annotations must begin with \"x_\", and may have an associated string literal value (the value will be \"\" if the annotation is just a flag).")
            .pattern("x_[a-zA-Z_0-9]*");

        sb.structType("TypeDef")
            .comment("TypeDef is the basic type definition.")
            .field("type", "TypeRef", false, "The type this type is derived from. For base types, it is the same as the name")
            .field("name", "TypeName", false, "The name of the type")
            .field("comment", "String", true, "The comment for the type")
            .mapField("annotations", "ExtendedAnnotation", "String", true, "additional annotations starting with \"x_\"");

        sb.structType("AliasTypeDef", "TypeDef")
            .comment("AliasTypeDef is used for type definitions that add no additional attributes, and thus just create an alias");

        sb.structType("BytesTypeDef", "TypeDef")
            .comment("Bytes allow the restriction by fixed size, or min/max size.")
            .field("size", "Int32", true, "Fixed size")
            .field("minSize", "Int32", true, "Min size")
            .field("maxSize", "Int32", true, "Max size");

        sb.structType("StringTypeDef", "TypeDef")
            .comment("Strings allow the restriction by regular expression pattern or by an explicit set of values. An optional maximum size may be asserted")
            .field("pattern", "String", true, "A regular expression that must be matched. Mutually exclusive with values")
            .arrayField("values", "String", true, "A set of allowable values")
            .field("minSize", "Int32", true, "Min size")
            .field("maxSize", "Int32", true, "Max size");

        sb.unionType("Number")
            .comment("A numeric is any of the primitive numeric types")
            .variant("Int8")
            .variant("Int16")
            .variant("Int32")
            .variant("Int64")
            .variant("Float32")
            .variant("Float64");

        sb.structType("NumberTypeDef", "TypeDef")
            .comment("A number type definition allows the restriction of numeric values.")
            .field("min", "Number", true, "Min value")
            .field("max", "Number", true, "Max value");

        sb.structType("ArrayTypeDef", "TypeDef")
            .comment("Array types can be restricted by item type and size")
            .field("items", "TypeRef", false, "The type of the items, default to any type", null)
            .field("size", "Int32", true, "If present, indicate the fixed size.")
            .field("minSize", "Int32", true, "If present, indicate the min size")
            .field("maxSize", "Int32", true, "If present, indicate the max size");

        sb.structType("MapTypeDef", "TypeDef")
            .comment("Map types can be restricted by key type, item type and size")
            .field("keys", "TypeRef", false, "The type of the keys, default to String.", null)
            .field("items", "TypeRef", false, "The type of the items, default to Any type", null)
            .field("size", "Int32", true, "If present, indicates the fixed size.")
            .field("minSize", "Int32", true, "If present, indicate the min size")
            .field("maxSize", "Int32", true, "If present, indicate the max size");

        sb.structType("StructFieldDef")
            .comment("Each field in a struct_field_spec is defined by this type")
            .field("name", "Identifier", false, "The name of the field")
            .field("type", "TypeRef", false, "The type of the field")
            .field("optional", "Bool", false, "The field may be omitted even if specified", false)
            .field("default", "Any", true, "If field is absent, what default value should be assumed.")
            .field("comment", "String", true, "The comment for the field")
            .field("items", "TypeRef", true, "For map or array fields, the type of the items")
            .field("keys", "TypeRef", true, "For map type fields, the type of the keys")
            .mapField("annotations", "ExtendedAnnotation", "String", true, "additional annotations starting with \"x_\"");

        sb.structType("StructTypeDef", "TypeDef")
            .comment("A struct can restrict specific named fields to specific types. By default, any field not specified is allowed, and can be of any type. Specifying closed means only those fields explicitly")
            .arrayField("fields", "StructFieldDef", false, "The fields in this struct. By default, open Structs can have any fields in addition to these")
            .field("closed", "Bool", false, "indicates that only the specified fields are acceptable. Default is open (any fields)", false);

        sb.structType("EnumElementDef")
            .comment("EnumElementDef defines one of the elements of an Enum")
            .field("symbol", "Identifier", false, "The identifier representing the value")
            .field("comment", "String", true, "the comment for the element")
            .mapField("annotations", "ExtendedAnnotation", "String", true, "additional annotations starting with \"x_\"");

        sb.structType("EnumTypeDef", "TypeDef")
            .comment("Define an enumerated type. Each value of the type is represented by a symbolic identifier.")
            .arrayField("elements", "EnumElementDef", false, "The enumeration of the possible elements");

        sb.structType("UnionTypeDef", "TypeDef")
            .comment("Define a type as one of any other specified type.")
            .arrayField("variants", "TypeRef", false, "The type names of constituent types. Union types get expanded, this is a flat list");

        sb.unionType("Type")
            .comment("A Type can be specified by any of the above specialized Types, determined by the value of the the 'type' field")
            .variant("BaseType")
            .variant("StructTypeDef")
            .variant("MapTypeDef")
            .variant("ArrayTypeDef")
            .variant("EnumTypeDef")
            .variant("UnionTypeDef")
            .variant("StringTypeDef")
            .variant("BytesTypeDef")
            .variant("NumberTypeDef")
            .variant("AliasTypeDef");

        sb.structType("ResourceInput")
            .comment("ResourceOutput defines input characteristics of a Resource")
            .field("name", "Identifier", false, "the formal name of the input")
            .field("type", "TypeRef", false, "The type of the input")
            .field("comment", "String", true, "The optional comment")
            .field("pathParam", "Bool", false, "true of this input is a path parameter", false)
            .field("queryParam", "String", true, "if present, the name of the query param name")
            .field("header", "String", true, "If present, the name of the header the input is associated with")
            .field("pattern", "String", true, "If present, the pattern associated with the pathParam (i.e. wildcard path matches)")
            .field("default", "Any", true, "If present, the default value for optional params")
            .field("optional", "Bool", false, "If present, indicates that the input is optional", false)
            .field("flag", "Bool", false, "If present, indicates the queryparam is of flag style (no value)", false)
            .field("context", "String", true, "If present, indicates the parameter comes form the implementation context")
            .mapField("annotations", "ExtendedAnnotation", "String", true, "additional annotations starting with \"x_\"");

        sb.structType("ResourceOutput")
            .comment("ResourceOutput defines output characteristics of a Resource")
            .field("name", "Identifier", false, "the formal name of the output")
            .field("type", "TypeRef", false, "The type of the output")
            .field("header", "String", false, "the name of the header associated with this output")
            .field("comment", "String", true, "The optional comment for the output")
            .field("optional", "Bool", false, "If present, indicates that the output is optional (the server decides)", false)
            .mapField("annotations", "ExtendedAnnotation", "String", true, "additional annotations starting with \"x_\"");

        sb.structType("ResourceAuth")
            .comment("ResourceAuth defines authentication and authorization attributes of a resource. Presence of action, resource, or domain implies authentication; the authentication flag alone is required only when no authorization is done.")
            .field("authenticate", "Bool", false, "if present and true, then the requester must be authenticated", false)
            .field("action", "String", true, "the action to authorize access to. This forces authentication")
            .field("resource", "String", true, "the resource identity to authorize access to")
            .field("domain", "String", true, "if present, the alternate domain to check access to. This is rare.");

        sb.structType("ExceptionDef")
            .comment("ExceptionDef describes the exception a symbolic response code maps to.")
            .field("type", "String", false, "The type of the exception")
            .field("comment", "String", true, "the optional comment for the exception");

        sb.structType("Resource")
            .comment("A Resource of a REST service")
            .field("type", "TypeRef", false, "The type of the resource")
            .field("method", "String", false, "The method for the action (typically GET, POST, etc for HTTP access)")
            .field("path", "String", false, "The resource path template")
            .field("comment", "String", true, "The optional comment")
            .arrayField("inputs", "ResourceInput", true, "An Array named inputs")
            .arrayField("outputs", "ResourceOutput", true, "An Array of named outputs")
            .field("auth", "ResourceAuth", true, "The optional authentication or authorization directive")
            .field("expected", "String", false, "The expected symbolic response code", "OK")
            .arrayField("alternatives", "String", true, "The set of alternative but non-error response codes")
            .mapField("exceptions", "String", "ExceptionDef", true, "A map of symbolic response code to Exception definitions")
            .field("async", "Bool", true, "A hint to server implementations that this resource would be better implemented with async I/O")
            .mapField("annotations", "ExtendedAnnotation", "String", true, "additional annotations starting with \"x_\"")
            .arrayField("consumes", "String", true, "Optional hint for resource acceptable input types")
            .arrayField("produces", "String", true, "Optional hint for resource output content types")
            .field("name", "Identifier", true, "The optional name of the resource");

        sb.structType("Schema")
            .comment("A Schema is a container for types and resources. It is self-contained (no external references). and is the output of the RDL parser.")
            .field("namespace", "NamespacedIdentifier", true, "The namespace for the schema")
            .field("name", "Identifier", true, "The name of the schema")
            .field("version", "Int32", true, "The version of the schema")
            .field("comment", "String", true, "The comment for the entire schema")
            .arrayField("types", "Type", true, "The types this schema defines.")
            .arrayField("resources", "Resource", true, "The resources for a service this schema defines")
            .field("base", "String", true, "the base path for resources in the schema.")
            .mapField("annotations", "ExtendedAnnotation", "String", true, "additional annotations starting with \"x_\"");



        return sb.build();
    }

}
