/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.rdl;

import com.yahoo.rdl.Struct;
import com.yahoo.rdl.Timestamp;
import com.yahoo.rdl.Value;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public final class Array
implements Iterable<Object>,
List<Object> {
    private static final int MIN_CAP = 16;
    private static final int MAX_GROWTH = 128;
    private Object[] values;
    private int count;

    public Array(int cap) {
        int n = cap < 16 ? 16 : cap;
        this.values = new Object[n];
        this.count = 0;
    }

    public Array() {
        this(16);
    }

    public Array(List<Object> lst) {
        this(lst.size());
        this.addAll((Collection<? extends Object>)lst);
    }

    public static Array empty() {
        return new Array();
    }

    public static Array from(Iterable<?> items) {
        if (items == null) {
            return null;
        }
        Array a = new Array();
        for (Object obj : items) {
            a.add(obj);
        }
        return a;
    }

    @Override
    public boolean add(Object o) {
        if (this.count == this.values.length) {
            int oldCap = this.values.length;
            int newCap = oldCap < 128 ? oldCap * 2 : oldCap + 128;
            Object[] newValues = new Object[newCap];
            System.arraycopy(this.values, 0, newValues, 0, this.count);
            this.values = newValues;
        }
        this.values[this.count++] = o;
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Object> i) {
        boolean changed = false;
        for (Object object : i) {
            this.add(object);
            changed = true;
        }
        return changed;
    }

    public Array with(Object o) {
        this.add(o);
        return this;
    }

    public Array without(Object o) {
        this.remove(o);
        return this;
    }

    public Array slice(int start, int end) {
        int count = this.size();
        if (start < 0) {
            start = 0;
        }
        if (end > count || end < 0) {
            end = count;
        }
        if (end < start) {
            end = start;
        }
        if (end > start) {
            Array a = new Array(end - start);
            for (int i = start; i < end; ++i) {
                a.add(this.get(i));
            }
            return a;
        }
        return Array.empty();
    }

    public Array copy() {
        return this.slice(0, -1);
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public Object get(int idx) {
        return this.values[idx];
    }

    public String getString(int idx) {
        return (String)this.get(idx);
    }

    public Struct getStruct(int idx) {
        return (Struct)this.get(idx);
    }

    public Array getArray(int idx) {
        return (Array)this.get(idx);
    }

    public Timestamp getTimestamp(int idx) {
        return Timestamp.fromObject(this.get(idx));
    }

    public byte[] getBytes(int idx) {
        return (byte[])this.get(idx);
    }

    public boolean getBoolean(int idx) {
        return Value.asBoolean(this.get(idx));
    }

    public byte getByte(int idx) {
        return Value.asByte(this.get(idx));
    }

    public short getShort(int idx) {
        return Value.asShort(this.get(idx));
    }

    public int getInt(int idx) {
        return Value.asInt(this.get(idx));
    }

    public long getLong(int idx) {
        return Value.asLong(this.get(idx));
    }

    public float getFloat(int idx) {
        return Value.asFloat(this.get(idx));
    }

    public double getDouble(int idx) {
        return Value.asDouble(this.get(idx));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendToString(sb, "");
        return sb.toString();
    }

    void appendToString(StringBuilder sb, String indent) {
        int count = this.size();
        if (count > 0) {
            Object o;
            sb.append("[");
            String newIndent = null;
            if (count == 1 && !((o = this.get(0)) instanceof Array) && !(o instanceof Struct)) {
                Value.appendToString(o, sb, null);
                sb.append("]");
                return;
            }
            if (indent != null) {
                newIndent = indent + "    ";
                sb.append("\n");
                sb.append(newIndent);
            }
            for (int i = 0; i < count; ++i) {
                Object item;
                if (i > 0) {
                    if (newIndent != null) {
                        sb.append(",\n");
                        sb.append(newIndent);
                    } else {
                        sb.append(", ");
                    }
                }
                if ((item = this.get(i)) != null) {
                    Value.appendToString(item, sb, newIndent);
                    continue;
                }
                sb.append("null");
            }
            if (indent != null) {
                sb.append("\n");
                sb.append(indent);
            }
            sb.append("]");
        } else {
            sb.append("[]");
        }
    }

    @Override
    public Iterator<Object> iterator() {
        return new TypedArrayIterator<Object>(this.values);
    }

    public Iterable<Struct> asStructs() {
        return new Value.TypedIterable<Struct>(this);
    }

    public Iterable<String> asStrings() {
        return new Value.TypedIterable<String>(this);
    }

    @Override
    public boolean equals(Object another) {
        if (another == this) {
            return true;
        }
        if (another instanceof Array) {
            Array other = (Array)another;
            if (this.count == other.count) {
                for (int i = 0; i < this.count; ++i) {
                    if (Value.equals(this.values[i], other.values[i])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public List<Object> subList(int fromIndex, int toIndex) {
        if (toIndex >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        int size = toIndex - fromIndex;
        if (size <= 0) {
            return Array.empty();
        }
        Array a = new Array(size);
        for (int i = fromIndex; i < toIndex; ++i) {
            a.add(this.values[i]);
        }
        return a;
    }

    @Override
    public int indexOf(Object o) {
        if (o == null) {
            for (int i = 0; i < this.count; ++i) {
                if (this.values[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.count; ++i) {
                if (!o.equals(this.values[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o == null) {
            for (int i = this.count - 1; i >= 0; --i) {
                if (this.values[i] != null) continue;
                return i;
            }
        } else {
            for (int i = this.count - 1; i >= 0; --i) {
                if (!o.equals(this.values[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public void clear() {
        this.count = 0;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public boolean remove(Object o) {
        int i = this.indexOf(o);
        if (i < 0) {
            return false;
        }
        this.remove(i);
        return true;
    }

    @Override
    public Object remove(int index) {
        if (index < 0 || index >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        Object result = this.values[index];
        --this.count;
        int tail = this.count - index;
        if (tail > 0) {
            System.arraycopy(this.values, index + 1, this.values, index, tail);
        }
        this.values[this.count] = null;
        return result;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        Object[] newValues = new Object[this.values.length];
        int n = 0;
        for (int i = 0; i < this.count; ++i) {
            if (!c.contains(this.values[i])) {
                newValues[n++] = this.values[i];
                continue;
            }
            changed = true;
        }
        this.values = newValues;
        this.count = n;
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean changed = false;
        Object[] newValues = new Object[this.values.length];
        int n = 0;
        for (int i = 0; i < this.count; ++i) {
            if (c.contains(this.values[i])) {
                newValues[n++] = this.values[i];
                continue;
            }
            changed = true;
        }
        this.values = newValues;
        this.count = n;
        return changed;
    }

    @Override
    public Object set(int index, Object element) {
        if (index >= this.count || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        Object result = this.values[index];
        this.values[index] = element;
        return result;
    }

    @Override
    public void add(int index, Object element) {
        if (index > this.count || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (index == this.count) {
            this.add(element);
        } else {
            if (this.count == this.values.length) {
                int oldCap = this.values.length;
                int newCap = oldCap < 128 ? oldCap * 2 : oldCap + 128;
                Object[] newValues = new Object[newCap];
                System.arraycopy(this.values, 0, newValues, 0, index);
                System.arraycopy(this.values, index, newValues, index + 1, this.count - index);
                this.values = newValues;
            } else {
                System.arraycopy(this.values, index, this.values, index + 1, this.count - index);
            }
            this.values[index] = element;
            ++this.count;
        }
    }

    @Override
    public boolean addAll(int index, Collection<? extends Object> c) {
        boolean changed;
        boolean bl = changed = c.size() > 0;
        if (index > this.count || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (index == this.count) {
            this.addAll(c);
        } else {
            int oldCap = this.values.length;
            int cSize = c.size();
            int newSize = this.count + cSize;
            if (newSize >= oldCap) {
                int newCap = oldCap + cSize;
                Object[] objectArray = new Object[newCap];
                System.arraycopy(this.values, 0, objectArray, 0, index);
                System.arraycopy(this.values, index, objectArray, index + cSize, this.count - index);
                this.values = objectArray;
            } else {
                System.arraycopy(this.values, index, this.values, index + cSize, this.count - index);
            }
            for (Object object : c) {
                this.values[index++] = object;
            }
        }
        return changed;
    }

    @Override
    public ListIterator<Object> listIterator() {
        return new ListArrayIterator(0);
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        return new ListArrayIterator(index);
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.count];
        System.arraycopy(this.values, 0, result, 0, this.count);
        return result;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    public class ListArrayIterator
    implements ListIterator<Object> {
        int i;

        ListArrayIterator(int start) {
            this.i = start;
        }

        @Override
        public boolean hasNext() {
            return this.i < Array.this.count;
        }

        @Override
        public boolean hasPrevious() {
            return this.i > 0;
        }

        @Override
        public Object next() {
            return Array.this.values[this.i++];
        }

        @Override
        public int nextIndex() {
            return this.i;
        }

        @Override
        public int previousIndex() {
            return this.i - 1;
        }

        @Override
        public Object previous() {
            return Array.this.values[--this.i];
        }

        @Override
        public void add(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public class TypedArrayIterator<T>
    implements Iterator<T> {
        T[] array;
        int i;

        TypedArrayIterator(T[] a) {
            this.array = a;
            this.i = 0;
        }

        @Override
        public boolean hasNext() {
            return this.i < Array.this.count;
        }

        @Override
        public T next() {
            return this.array[this.i++];
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

