/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.rdl;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.yahoo.rdl.RdlOptional;
import java.io.IOException;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(using=NumberJsonDeserializer.class)
public final class Number {
    @JsonIgnore
    public NumberVariant variant;
    @RdlOptional
    public Byte Int8;
    @RdlOptional
    public Short Int16;
    @RdlOptional
    public Integer Int32;
    @RdlOptional
    public Long Int64;
    @RdlOptional
    public Float Float32;
    @RdlOptional
    public Double Float64;

    public boolean equals(Object another) {
        if (this != another) {
            if (another == null || another.getClass() != Number.class) {
                return false;
            }
            Number a = (Number)another;
            if (this.variant == a.variant) {
                switch (this.variant) {
                    case Int8: {
                        return this.Int8.equals(a.Int8);
                    }
                    case Int16: {
                        return this.Int16.equals(a.Int16);
                    }
                    case Int32: {
                        return this.Int32.equals(a.Int32);
                    }
                    case Int64: {
                        return this.Int64.equals(a.Int64);
                    }
                    case Float32: {
                        return this.Float32.equals(a.Float32);
                    }
                    case Float64: {
                        return this.Float64.equals(a.Float64);
                    }
                }
            }
        }
        return false;
    }

    public Number() {
    }

    public Number(Byte int8) {
        this.variant = NumberVariant.Int8;
        this.Int8 = int8;
    }

    public Number(Short int16) {
        this.variant = NumberVariant.Int16;
        this.Int16 = int16;
    }

    public Number(Integer int32) {
        this.variant = NumberVariant.Int32;
        this.Int32 = int32;
    }

    public Number(Long int64) {
        this.variant = NumberVariant.Int64;
        this.Int64 = int64;
    }

    public Number(Float float32) {
        this.variant = NumberVariant.Float32;
        this.Float32 = float32;
    }

    public Number(Double float64) {
        this.variant = NumberVariant.Float64;
        this.Float64 = float64;
    }

    public static class NumberJsonDeserializer
    extends JsonDeserializer<Number> {
        public Number deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonToken tok = jp.nextToken();
            if (tok != JsonToken.FIELD_NAME) {
                throw new IOException("Cannot deserialize Number - no valid variant present");
            }
            String svariant = jp.getCurrentName();
            tok = jp.nextToken();
            Number t = null;
            if (tok == JsonToken.VALUE_NUMBER_INT || tok == JsonToken.VALUE_NUMBER_FLOAT) {
                switch (svariant) {
                    case "Int8": {
                        t = new Number(jp.getByteValue());
                        break;
                    }
                    case "Int16": {
                        t = new Number(jp.getShortValue());
                        break;
                    }
                    case "Int32": {
                        t = new Number(jp.getIntValue());
                        break;
                    }
                    case "Int64": {
                        t = new Number(jp.getLongValue());
                        break;
                    }
                    case "Float32": {
                        t = new Number(Float.valueOf(jp.getFloatValue()));
                        break;
                    }
                    case "Float64": {
                        t = new Number(jp.getDoubleValue());
                        break;
                    }
                    default: {
                        throw new IOException("Cannot deserialize Number - bad type variant: " + svariant);
                    }
                }
                tok = jp.nextToken();
                return t;
            }
            throw new IOException("Cannot deserialize Number - no variant present");
        }
    }

    public static enum NumberVariant {
        Int8,
        Int16,
        Int32,
        Int64,
        Float32,
        Float64;

    }
}

