/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.rdl;

import com.yahoo.rdl.EnumElementDef;
import com.yahoo.rdl.EnumTypeDef;
import com.yahoo.rdl.ExceptionDef;
import com.yahoo.rdl.Number;
import com.yahoo.rdl.NumberTypeDef;
import com.yahoo.rdl.Resource;
import com.yahoo.rdl.ResourceAuth;
import com.yahoo.rdl.ResourceInput;
import com.yahoo.rdl.ResourceOutput;
import com.yahoo.rdl.Schema;
import com.yahoo.rdl.StringTypeDef;
import com.yahoo.rdl.StructFieldDef;
import com.yahoo.rdl.StructTypeDef;
import com.yahoo.rdl.Type;
import com.yahoo.rdl.UnionTypeDef;
import java.util.ArrayList;
import java.util.HashMap;

public class SchemaBuilder {
    Schema schema;

    public SchemaBuilder(String name) {
        this.schema = new Schema().name(name);
        this.schema.types = new ArrayList<Type>();
        this.schema.resources = new ArrayList<Resource>();
    }

    public SchemaBuilder namespace(String namespace) {
        this.schema.namespace = namespace;
        return this;
    }

    public SchemaBuilder version(int version) {
        this.schema.version = version;
        return this;
    }

    public SchemaBuilder comment(String comment) {
        this.schema.comment = comment;
        return this;
    }

    public SchemaBuilder base(String base) {
        this.schema.base = base;
        return this;
    }

    public StringTypeBuilder stringType(String tname) {
        return new StringTypeBuilder(tname);
    }

    public NumberTypeBuilder numberType(String tname, String sname) {
        return new NumberTypeBuilder(tname, sname);
    }

    public StructTypeBuilder structType(String tname) {
        return new StructTypeBuilder(tname, "Struct");
    }

    public StructTypeBuilder structType(String tname, String sname) {
        return new StructTypeBuilder(tname, sname);
    }

    public EnumTypeBuilder enumType(String tname) {
        return new EnumTypeBuilder(tname);
    }

    public UnionTypeBuilder unionType(String tname) {
        return new UnionTypeBuilder(tname);
    }

    public ResourceBuilder resource(String rtype, String rmethod, String rpath) {
        return new ResourceBuilder(rtype, rmethod, rpath);
    }

    public Schema build() {
        if (this.schema.types != null && this.schema.types.size() == 0) {
            this.schema.types = null;
        }
        if (this.schema.resources != null && this.schema.resources.size() == 0) {
            this.schema.resources = null;
        }
        return this.schema;
    }

    public class ResourceBuilder {
        Resource rez;

        ResourceBuilder(String rtype, String rmethod, String rpath) {
            this.rez = new Resource().type(rtype).method(rmethod).path(rpath);
            SchemaBuilder.this.schema.resources.add(this.rez);
        }

        public ResourceBuilder comment(String comment) {
            this.rez.comment = comment;
            return this;
        }

        public ResourceBuilder name(String name) {
            this.rez.name = name;
            return this;
        }

        private ResourceInput addInput(String iname, String itype, String comment) {
            ResourceInput in = new ResourceInput().name(iname).type(itype);
            if (comment != null && comment.length() > 0) {
                in.comment(comment);
            }
            if (this.rez.inputs == null) {
                this.rez.inputs = new ArrayList<ResourceInput>();
            }
            this.rez.inputs.add(in);
            return in;
        }

        public ResourceBuilder input(String iname, String itype, String comment) {
            this.addInput(iname, itype, comment);
            return this;
        }

        public ResourceBuilder pathParam(String iname, String itype, String comment) {
            ResourceInput in = this.addInput(iname, itype, comment);
            in.pathParam(true);
            return this;
        }

        public ResourceBuilder queryParam(String iparam, String iname, String itype, Object _default, String comment) {
            ResourceInput in = this.addInput(iname, itype, comment);
            in.queryParam(iparam);
            if (_default != null) {
                in._default(_default);
            } else {
                in.optional(true);
            }
            return this;
        }

        public ResourceBuilder headerParam(String iparam, String iname, String itype, Object _default, String comment) {
            ResourceInput in = this.addInput(iname, itype, comment);
            in.header(iparam);
            in.optional(true);
            if (_default != null) {
                in._default(_default);
            } else {
                in.optional(true);
            }
            return this;
        }

        public ResourceBuilder output(String header, String name, String type, String comment) {
            ResourceOutput out = new ResourceOutput().header(header).name(name).type(type);
            if (comment != null && comment.length() > 0) {
                out.comment(comment);
            }
            if (this.rez.outputs == null) {
                this.rez.outputs = new ArrayList<ResourceOutput>();
            }
            this.rez.outputs.add(out);
            return this;
        }

        public ResourceBuilder auth(String action, String resource) {
            return this.auth(action, resource, false);
        }

        public ResourceBuilder auth(String action, String resource, boolean authenticate) {
            return this.auth(action, resource, authenticate, null);
        }

        public ResourceBuilder auth(String action, String resource, boolean authenticate, String domain) {
            ResourceAuth auth = new ResourceAuth().action(action).resource(resource).authenticate(authenticate);
            if (domain != null && domain.length() > 0) {
                auth.domain(domain);
            }
            this.rez.auth = auth;
            return this;
        }

        public ResourceBuilder expected(String sym) {
            this.rez.expected = sym;
            return this;
        }

        public ResourceBuilder exception(String sym, String type, String comment) {
            ExceptionDef exc = new ExceptionDef().type(type);
            if (comment != null && comment.length() > 0) {
                exc.comment(comment);
            }
            if (this.rez.exceptions == null) {
                this.rez.exceptions = new HashMap<String, ExceptionDef>();
            }
            this.rez.exceptions.put(sym, exc);
            return this;
        }

        public ResourceBuilder async() {
            this.rez.async = true;
            return this;
        }
    }

    public class NumberTypeBuilder {
        NumberTypeDef td;

        NumberTypeBuilder(String name, String supername) {
            this.td = new NumberTypeDef().type(supername).name(name);
            Type t = new Type(this.td);
            SchemaBuilder.this.schema.types.add(t);
        }

        public NumberTypeBuilder comment(String comment) {
            this.td.comment = comment;
            return this;
        }

        public NumberTypeBuilder min(int min) {
            this.td.min = new Number(min);
            return this;
        }

        public NumberTypeBuilder min(long min) {
            this.td.min = new Number(min);
            return this;
        }

        public NumberTypeBuilder min(double min) {
            this.td.min = new Number(min);
            return this;
        }

        public NumberTypeBuilder max(int max) {
            this.td.max = new Number(max);
            return this;
        }

        public NumberTypeBuilder max(long max) {
            this.td.max = new Number(max);
            return this;
        }

        public NumberTypeBuilder max(double max) {
            this.td.max = new Number(max);
            return this;
        }
    }

    public class StringTypeBuilder {
        StringTypeDef td;

        StringTypeBuilder(String name) {
            this.td = new StringTypeDef().type("String").name(name);
            Type t = new Type(this.td);
            SchemaBuilder.this.schema.types.add(t);
        }

        public StringTypeBuilder comment(String comment) {
            this.td.comment = comment;
            return this;
        }

        public StringTypeBuilder pattern(String pattern) {
            this.td.pattern = pattern;
            return this;
        }

        public StringTypeBuilder maxSize(int size) {
            this.td.maxSize = size;
            return this;
        }
    }

    public class UnionTypeBuilder {
        UnionTypeDef td;

        UnionTypeBuilder(String name) {
            this.td = new UnionTypeDef().type("Union").name(name).variants(new ArrayList<String>());
            Type t = new Type(this.td);
            SchemaBuilder.this.schema.types.add(t);
        }

        public UnionTypeBuilder comment(String comment) {
            this.td.comment = comment;
            return this;
        }

        public UnionTypeBuilder variant(String variant) {
            this.td.variants.add(variant);
            return this;
        }
    }

    public class EnumTypeBuilder {
        EnumTypeDef td;

        EnumTypeBuilder(String name) {
            this.td = new EnumTypeDef().type("Enum").name(name).elements(new ArrayList<EnumElementDef>());
            Type t = new Type(this.td);
            SchemaBuilder.this.schema.types.add(t);
        }

        public EnumTypeBuilder comment(String comment) {
            this.td.comment = comment;
            return this;
        }

        public EnumTypeBuilder element(String sym) {
            return this.element(sym, null);
        }

        public EnumTypeBuilder element(String sym, String comment) {
            EnumElementDef ed = new EnumElementDef().symbol(sym);
            if (comment != null) {
                ed.comment(comment);
            }
            this.td.elements.add(ed);
            return this;
        }
    }

    public class StructTypeBuilder {
        StructTypeDef td;

        StructTypeBuilder(String name, String superName) {
            this.td = new StructTypeDef().type(superName).name(name).fields(new ArrayList<StructFieldDef>());
            Type t = new Type(this.td);
            SchemaBuilder.this.schema.types.add(t);
        }

        public StructTypeBuilder comment(String comment) {
            this.td.comment = comment;
            return this;
        }

        public StructTypeBuilder field(String fname, String ftype, boolean optional, String comment) {
            return this.field(fname, ftype, optional, comment, null);
        }

        public StructTypeBuilder field(String fname, String ftype, boolean optional, String comment, Object _default) {
            StructFieldDef fd = new StructFieldDef().name(fname).type(ftype).optional(optional).comment(comment)._default(_default);
            this.td.fields.add(fd);
            return this;
        }

        public StructTypeBuilder arrayField(String fname, String fitems, boolean optional, String comment) {
            StructFieldDef fd = new StructFieldDef().name(fname).type("Array").items(fitems).optional(optional).comment(comment);
            this.td.fields.add(fd);
            return this;
        }

        public StructTypeBuilder mapField(String fname, String fkeys, String fitems, boolean optional, String comment) {
            StructFieldDef fd = new StructFieldDef().name(fname).type("Map").keys(fkeys).items(fitems).optional(optional).comment(comment);
            this.td.fields.add(fd);
            return this;
        }
    }
}

