/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.rdl;

import com.yahoo.rdl.Timestamp;
import com.yahoo.rdl.UUID;
import com.yahoo.rdl.Value;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Struct
implements Iterable<Field>,
Map<String, Object> {
    private static final int MIN_CAP = 16;
    private static final int MAX_GROWTH = 128;
    private String[] names;
    private Object[] values;
    private int count;

    public Struct(int cap) {
        int n = cap < 16 ? 16 : cap;
        this.names = new String[n];
        this.values = new Object[n];
        this.count = 0;
    }

    public Struct() {
        this(16);
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    public Iterable<String> names() {
        return new TypedArrayIterable<String>(this.names);
    }

    @Override
    public Collection<Object> values() {
        ArrayList<Object> lst = new ArrayList<Object>(this.count);
        for (int i = 0; i < this.count; ++i) {
            lst.add(this.values[i]);
        }
        return lst;
    }

    @Override
    public Iterator<Field> iterator() {
        return new StructIterator();
    }

    public void append(String name, Object val) {
        if (this.count == this.names.length) {
            int oldCap = this.names.length;
            int newCap = oldCap < 128 ? oldCap * 2 : oldCap + 128;
            String[] newNames = new String[newCap];
            System.arraycopy(this.names, 0, newNames, 0, this.count);
            Object[] newValues = new Object[newCap];
            System.arraycopy(this.values, 0, newValues, 0, this.count);
            this.names = newNames;
            this.values = newValues;
        }
        this.names[this.count] = name;
        this.values[this.count++] = val;
    }

    @Override
    public Object put(String name, Object val) {
        Object result = null;
        int i = this.find(name);
        if (i < 0) {
            this.append(name, val);
        } else {
            result = this.values[i];
            this.values[i] = val;
        }
        return result;
    }

    @Override
    public Object remove(Object name) {
        return this.remove((String)name);
    }

    public Object remove(String name) {
        Object result = null;
        int i = this.find(name);
        if (i >= 0) {
            result = this.values[i];
            --this.count;
            if (i < this.count) {
                System.arraycopy(this.names, i + 1, this.names, i, this.count - i);
                System.arraycopy(this.values, i + 1, this.values, i, this.count - i);
            }
            this.names[this.count] = null;
            this.values[this.count] = null;
        }
        return result;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        for (Map.Entry<? extends String, ? extends Object> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    public Struct with(String key, Object val) {
        this.put(key, val);
        return this;
    }

    public Struct withNonNull(String key, Object val) {
        if (val != null) {
            this.put(key, val);
        }
        return this;
    }

    public Struct with(Struct another) {
        this.putAll(another);
        return this;
    }

    public Struct without(String key) {
        this.remove(key);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendToString(sb, "");
        return sb.toString();
    }

    void appendToString(StringBuilder sb, String indent) {
        if (this.isEmpty()) {
            sb.append("{}");
        } else {
            sb.append("{");
            String newIndent = null;
            if (indent != null) {
                newIndent = indent + "    ";
                sb.append("\n");
                sb.append(newIndent);
            }
            for (int i = 0; i < this.count; ++i) {
                if (i > 0) {
                    if (newIndent != null) {
                        sb.append(",\n");
                        sb.append(newIndent);
                    } else {
                        sb.append(", ");
                    }
                }
                sb.append(this.names[i]);
                sb.append(": ");
                Value.appendToString(this.values[i], sb, newIndent);
            }
            if (newIndent != null) {
                sb.append("\n");
                sb.append(indent);
            }
            sb.append("}");
        }
    }

    @Override
    public boolean equals(Object another) {
        if (another == this) {
            return true;
        }
        if (another instanceof Struct) {
            Struct other = (Struct)another;
            if (this.count == other.count) {
                for (int i = 0; i < this.count; ++i) {
                    String k = this.names[i];
                    Object v = this.values[i];
                    Object o = other.get(k);
                    if (o == v) continue;
                    if (o == null) {
                        return false;
                    }
                    if (Value.equals(v, o)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public boolean has(String name) {
        return this.find(name) >= 0;
    }

    public String[] sortedNames() {
        Object[] result = new String[this.count];
        System.arraycopy(this.names, 0, result, 0, this.count);
        Arrays.sort(result);
        return result;
    }

    private int find(String name) {
        for (int i = 0; i < this.count; ++i) {
            if (!name.equals(this.names[i])) continue;
            return i;
        }
        return -1;
    }

    public Object get(String name) {
        int i = this.find(name);
        if (i < 0) {
            return null;
        }
        return this.values[i];
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        Object v = this.get(name);
        return v == null ? defaultValue : Value.asBoolean(v);
    }

    public boolean getBoolean(String name) {
        return this.getBoolean(name, false);
    }

    public byte getByte(String name, byte defaultValue) {
        Object v = this.get(name);
        return v == null ? defaultValue : Value.asByte(v);
    }

    public byte getByte(String name) {
        return this.getByte(name, (byte)0);
    }

    public short getShort(String name, short defaultValue) {
        Object v = this.get(name);
        return v == null ? defaultValue : Value.asShort(v);
    }

    public short getShort(String name) {
        return this.getShort(name, (short)0);
    }

    public int getInt(String name, int defaultValue) {
        Object v = this.get(name);
        return v == null ? defaultValue : Value.asInt(v);
    }

    public int getInt(String name) {
        return this.getInt(name, 0);
    }

    public long getLong(String name, long defaultValue) {
        Object v = this.get(name);
        return v == null ? defaultValue : Value.asLong(v);
    }

    public long getLong(String name) {
        return this.getLong(name, 0L);
    }

    public float getFloat(String name, float defaultValue) {
        Object v = this.get(name);
        return v == null ? defaultValue : Value.asFloat(v);
    }

    public float getFloat(String name) {
        return this.getFloat(name, 0.0f);
    }

    public double getDouble(String name, double defaultValue) {
        Object v = this.get(name);
        return v == null ? defaultValue : Value.asDouble(v);
    }

    public double getDouble(String name) {
        return this.getDouble(name, 0.0);
    }

    public byte[] getBytes(String name) {
        Object b = this.get(name);
        return b == null ? null : Value.asBytes(b);
    }

    public String getString(String name) {
        Object o = this.get(name);
        if (o == null) {
            return null;
        }
        return Value.asString(o);
    }

    public String getString(String name, String defaultValue) {
        Object o = this.get(name);
        if (o == null) {
            return defaultValue;
        }
        return (String)o;
    }

    public Struct getStruct(String name) {
        return (Struct)this.get(name);
    }

    public Timestamp getTimestamp(String name) {
        return Timestamp.fromObject(this.get(name));
    }

    public UUID getUUID(String name) {
        return UUID.fromObject(this.get(name));
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashSet<Map.Entry<String, Object>> set = new HashSet<Map.Entry<String, Object>>();
        for (int i = 0; i < this.count; ++i) {
            set.add(new Entry(this.names[i], this.values[i]));
        }
        return set;
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < this.count; ++i) {
            set.add(this.names[i]);
        }
        return set;
    }

    @Override
    public void clear() {
        this.count = 0;
    }

    @Override
    public Object get(Object name) {
        return this.get((String)name);
    }

    @Override
    public boolean containsKey(Object name) {
        return this.has((String)name);
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            for (int i = 0; i < this.count; ++i) {
                if (this.values[i] != null) continue;
                return true;
            }
        } else {
            for (int i = 0; i < this.count; ++i) {
                if (!Value.equals(value, this.values[i])) continue;
                return true;
            }
        }
        return false;
    }

    class Entry
    implements Map.Entry<String, Object> {
        String key;
        Object value;

        Entry(String k, Object v) {
            this.key = k;
            this.value = v;
        }

        @Override
        public Object setValue(Object v) {
            Object o = this.value;
            this.value = v;
            return o;
        }

        public void setKey(String k) {
            this.key = k;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public String getKey() {
            return this.key;
        }
    }

    class StructIterator
    implements Iterator<Field> {
        int pos = 0;

        private StructIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pos < Struct.this.count;
        }

        @Override
        public Field next() {
            return new Field(this.pos++);
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }

    public class Field {
        private int idx;

        private Field(int i) {
            this.idx = i;
        }

        public String name() {
            return Struct.this.names[this.idx];
        }

        public Object value() {
            return Struct.this.values[this.idx];
        }
    }

    public class TypedArrayIterable<T>
    implements Iterable<T> {
        T[] array;

        TypedArrayIterable(T[] a) {
            this.array = a;
        }

        @Override
        public Iterator<T> iterator() {
            return new TypedArrayIterator<T>(this.array);
        }
    }

    public class TypedArrayIterator<T>
    implements Iterator<T> {
        T[] array;
        int i;

        TypedArrayIterator(T[] a) {
            this.array = a;
            this.i = 0;
        }

        @Override
        public boolean hasNext() {
            return this.i < Struct.this.count;
        }

        @Override
        public T next() {
            return this.array[this.i++];
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

