/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.rdl;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;

@JsonSerialize(using=SymbolJsonSerializer.class)
@JsonDeserialize(using=SymbolJsonDeserializer.class)
public final class Symbol {
    public final String name;
    private static ConcurrentHashMap<String, Symbol> symtab = new ConcurrentHashMap();

    private Symbol(String n) {
        this.name = n;
    }

    public static Symbol intern(String name) {
        Symbol sym = symtab.get(name);
        if (sym == null) {
            sym = new Symbol(name);
            symtab.put(name, sym);
        }
        return sym;
    }

    public String toString() {
        return this.name;
    }

    public static class SymbolJsonDeserializer
    extends JsonDeserializer<Symbol> {
        public Symbol deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            String s = jp.getText();
            return Symbol.intern(s);
        }
    }

    public static class SymbolJsonSerializer
    extends JsonSerializer<Symbol> {
        public void serialize(Symbol value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeString(value.name);
        }
    }
}

