/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.rdl;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

@JsonSerialize(using=TimestampJsonSerializer.class)
@JsonDeserialize(using=TimestampJsonDeserializer.class)
public class Timestamp {
    String repr;
    private static final long UNINITIALIZED = Long.MAX_VALUE;
    private long normalizedMillis = Long.MAX_VALUE;

    Timestamp(String s) {
        this.repr = s;
    }

    private static String num(int n, int width) {
        String s = String.valueOf(n);
        while (s.length() < width) {
            s = "0" + s;
        }
        return s;
    }

    private static Date rfc3339ToDate(String rfc3339) {
        String s = rfc3339;
        if (s == null || s.length() < 19) {
            return null;
        }
        if (!s.endsWith("Z")) {
            int i = s.lastIndexOf(43);
            if (i < 0) {
                i = s.lastIndexOf(45);
            }
            s = s.substring(0, i + 3) + rfc3339.substring(i + 4);
        } else {
            s = s.substring(0, s.length() - 1) + "-0000";
        }
        try {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSZ").parse(s);
        }
        catch (ParseException parseException) {
            try {
                return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").parse(s);
            }
            catch (ParseException parseException2) {
                return null;
            }
        }
    }

    public static Timestamp fromObject(Object o) {
        if (o instanceof Timestamp) {
            return (Timestamp)o;
        }
        if (o instanceof String) {
            return Timestamp.fromString((String)o);
        }
        if (o instanceof Long) {
            return Timestamp.fromMillis((Long)o);
        }
        if (o instanceof Date) {
            return Timestamp.fromDate((Date)o);
        }
        throw new ClassCastException("Not a Timestamp: " + o.getClass());
    }

    public static Timestamp fromString(String s) {
        Date d = Timestamp.rfc3339ToDate(s);
        if (d == null) {
            return null;
        }
        return Timestamp.fromMillis(d.getTime());
    }

    public static Timestamp fromCurrentTime() {
        long millis = System.currentTimeMillis();
        return Timestamp.fromMillis(millis);
    }

    public static Timestamp fromMillis(long millis) {
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        cal.setTimeInMillis(millis);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        int hour = cal.get(11);
        int min = cal.get(12);
        int sec = cal.get(13);
        int ms = cal.get(14);
        String s = year + "-" + Timestamp.num(month, 2) + "-" + Timestamp.num(day, 2) + "T" + Timestamp.num(hour, 2) + ":" + Timestamp.num(min, 2) + ":" + Timestamp.num(sec, 2) + "." + Timestamp.num(ms, 3) + "Z";
        return new Timestamp(s);
    }

    public static Timestamp fromDate(Date d) {
        return new Timestamp(Timestamp.rfc3339FromDate(d));
    }

    public Date toDate() {
        return Timestamp.rfc3339ToDate(this.repr);
    }

    private static String rfc3339FromDate(Date d) {
        String iso8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSZ").format(d);
        if (iso8601.endsWith("Z")) {
            return iso8601;
        }
        int len = iso8601.length();
        return iso8601.substring(0, len - 2) + ":" + iso8601.substring(len - 2);
    }

    private static Date rfc1123ToDate(String rfc1123) {
        SimpleDateFormat fmt = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss zzz");
        fmt.setTimeZone(TimeZone.getTimeZone("GMT"));
        return fmt.parse(rfc1123, new ParsePosition(0));
    }

    private static String rfc1123FromDate(Date d) {
        SimpleDateFormat fmt = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss zzz");
        fmt.setTimeZone(TimeZone.getTimeZone("GMT"));
        return fmt.format(d);
    }

    public String toString() {
        return this.repr;
    }

    public boolean equals(Object another) {
        if (another instanceof Timestamp) {
            return this.repr.equals(another.toString());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long millis() {
        if (this.normalizedMillis == Long.MAX_VALUE) {
            Timestamp timestamp = this;
            synchronized (timestamp) {
                if (this.normalizedMillis == Long.MAX_VALUE) {
                    Date d = Timestamp.rfc3339ToDate(this.repr);
                    if (d == null) {
                        return 0L;
                    }
                    this.normalizedMillis = d.getTime();
                }
            }
        }
        return this.normalizedMillis;
    }

    public static class TimestampJsonDeserializer
    extends JsonDeserializer<Timestamp> {
        public Timestamp deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            String s = jp.getText();
            return Timestamp.fromString(s);
        }
    }

    public static class TimestampJsonSerializer
    extends JsonSerializer<Timestamp> {
        public void serialize(Timestamp value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeString(value.toString());
        }
    }
}

