/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.rdl;

import com.yahoo.rdl.Schema;
import com.yahoo.rdl.Type;
import java.util.HashMap;
import java.util.Map;

public class TypeRegistry {
    Schema schema;
    Map<String, Type> types;

    public TypeRegistry(Schema schema) {
        this.schema = schema;
        this.types = new HashMap<String, Type>();
        if (schema.types != null) {
            for (Type t : schema.types) {
                String name = TypeRegistry.typeName(t);
                this.types.put(name, t);
            }
        }
    }

    public Type findType(String name) {
        return this.types.get(name);
    }

    public static String typeName(Type type) {
        switch (type.variant) {
            case BaseType: 
            case StructTypeDef: {
                return type.StructTypeDef.name;
            }
            case MapTypeDef: {
                return type.MapTypeDef.name;
            }
            case ArrayTypeDef: {
                return type.ArrayTypeDef.name;
            }
            case EnumTypeDef: {
                return type.EnumTypeDef.name;
            }
            case UnionTypeDef: {
                return type.UnionTypeDef.name;
            }
            case StringTypeDef: {
                return type.StringTypeDef.name;
            }
            case BytesTypeDef: {
                return type.BytesTypeDef.name;
            }
            case NumberTypeDef: {
                return type.NumberTypeDef.name;
            }
            case AliasTypeDef: {
                return type.AliasTypeDef.name;
            }
        }
        return null;
    }
}

