/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.rdl;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.yahoo.rdl.UUIDGenerator;
import java.io.IOException;
import java.net.URL;

@JsonSerialize(using=UUIDJsonSerializer.class)
@JsonDeserialize(using=UUIDJsonDeserializer.class)
public class UUID {
    public static boolean debug = false;
    public static final UUID NAMESPACE_X500 = UUID.fromString("6ba7b814-9dad-11d1-80b4-00c04fd430c8");
    public static final UUID NAMESPACE_URL = UUID.fromString("6ba7b811-9dad-11d1-80b4-00c04fd430c8");
    public static final UUID NAMESPACE_DNS = UUID.fromString("6ba7b810-9dad-11d1-80b4-00c04fd430c8");
    public static final UUID NAMESPACE_OID = UUID.fromString("6ba7b812-9dad-11d1-80b4-00c04fd430c8");
    String repr;
    static Object lock = new Object();
    static byte[] node = null;

    private UUID(String s) {
        this.repr = s;
    }

    private UUID(byte[] bytes) {
        this.repr = UUIDGenerator.toString(bytes);
    }

    public boolean equals(Object another) {
        if (another instanceof UUID) {
            return this.repr.equals(((UUID)another).repr);
        }
        return false;
    }

    public int hashCode() {
        return this.repr.hashCode();
    }

    public String toString() {
        return this.repr;
    }

    public byte[] toBytes() {
        return UUIDGenerator.toBytes(this.repr);
    }

    public static UUID fromString(String s) {
        UUID u = UUID.parse(s);
        if (u == null && (u = UUID.fromURL(s)) == null) {
            if ("NAMESPACE_URL".equals(s)) {
                u = NAMESPACE_URL;
            } else if ("NAMESPACE_DNS".equals(s)) {
                u = NAMESPACE_DNS;
            } else if ("NAMESPACE_OID".equals(s)) {
                u = NAMESPACE_OID;
            } else if ("NAMESPACE_X500".equals(s)) {
                u = NAMESPACE_X500;
            }
        }
        return u;
    }

    public static UUID fromBytes(byte[] bytes) {
        if (bytes != null && bytes.length == 16) {
            return new UUID(bytes);
        }
        return null;
    }

    public static UUID fromObject(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof UUID) {
            return (UUID)o;
        }
        if (o instanceof String) {
            return UUID.fromString((String)o);
        }
        if (o instanceof byte[]) {
            return UUID.fromBytes((byte[])o);
        }
        return (UUID)o;
    }

    static UUID parse(String s) {
        int len = s.length();
        String urnPrefix = "urn:uuid:";
        if (len == 45 && s.startsWith(urnPrefix)) {
            s = s.substring(urnPrefix.length());
            len -= urnPrefix.length();
        }
        if (len == 36 && s.charAt(8) == '-' && s.charAt(13) == '-' && s.charAt(18) == '-' && s.charAt(23) == '-') {
            try {
                Long.parseLong(s.substring(0, 8), 16);
                Integer.parseInt(s.substring(9, 13), 16);
                Integer.parseInt(s.substring(14, 18), 16);
                Integer.parseInt(s.substring(19, 23), 16);
                Long.parseLong(s.substring(24, 36), 16);
                UUID u = new UUID(s);
                int v = u.version();
                if (v != 1 && v != 3 && v != 4 && v != 5) {
                    return null;
                }
                return u;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean isUUID(Object v) {
        if (v instanceof UUID) {
            return UUID.parse(String.valueOf(v)) != null;
        }
        return false;
    }

    public long millis() {
        return UUIDGenerator.timestampToMillis(this.ticks());
    }

    public int version() {
        String s = this.repr;
        char c = s.charAt(14);
        return c - 48;
    }

    public long ticks() {
        String s = this.repr;
        char c = s.charAt(14);
        int ver = c - 48;
        if (ver != 1) {
            return 0L;
        }
        long result = Integer.parseInt(s.substring(15, 18), 16);
        result = (result << 16) + (long)Integer.parseInt(s.substring(9, 13), 16);
        result = (result << 32) + Long.parseLong(s.substring(0, 8), 16);
        return result;
    }

    public static boolean validate(String s) {
        try {
            UUID.parse(s);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] bytesFromTime(long ticks) {
        Object object = lock;
        synchronized (object) {
            if (node == null) {
                node = UUIDGenerator.getRandomNode();
            }
        }
        return UUIDGenerator.type1(node, ticks);
    }

    public static String stringFromMillis(long millis) {
        long ticks = UUIDGenerator.timestampFromMillis(millis);
        return UUIDGenerator.toString(UUID.bytesFromTime(ticks));
    }

    public static UUID fromMillis(long millis) {
        return new UUID(UUID.stringFromMillis(millis));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] bytesFromCurrentTime() {
        Object object = lock;
        synchronized (object) {
            if (node == null) {
                node = UUIDGenerator.getRandomNode();
            }
        }
        return UUIDGenerator.type1(node);
    }

    public static String stringFromCurrentTime() {
        return UUIDGenerator.toString(UUID.bytesFromCurrentTime());
    }

    public static UUID fromCurrentTime() {
        return new UUID(UUID.stringFromCurrentTime());
    }

    public static UUID fromURL(String url) {
        try {
            URL u = new URL(url);
            return UUID.fromURL(u);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static UUID fromURL(URL url) {
        return new UUID(UUIDGenerator.type3(url.toString(), UUIDGenerator.URL_NAMESPACE));
    }

    public static UUID fromName(UUID namespace, String name) {
        byte[] uuid = UUIDGenerator.type3(name, namespace.toBytes());
        return new UUID(UUIDGenerator.toString(uuid));
    }

    public int compareTo(UUID another) {
        byte[] obytes;
        int ob;
        byte[] bytes = this.toBytes();
        int b = bytes[0] & 0xFF;
        if (b == (ob = (obytes = another.toBytes())[0] & 0xFF)) {
            for (int i = 1; i < 16 && (b = bytes[i] & 0xFF) == (ob = obytes[i] & 0xFF); ++i) {
            }
        }
        return b - ob;
    }

    public static void main(String[] args) {
        String ns = null;
        String name = null;
        switch (args.length) {
            case 1: {
                ns = null;
                name = args[0];
                break;
            }
            case 2: {
                ns = args[0];
                name = args[1];
                break;
            }
        }
        if (name == null) {
            System.out.println(UUID.fromCurrentTime());
        } else if (ns == null) {
            if ("-h".equals(name)) {
                System.out.println("Usage: uuid");
                System.out.println("   Produce a type 1 UUID.");
                System.out.println("Usage: uuid url");
                System.out.println("   Produce a type 3 UUID in the 'URL' namespace for the specified URL");
                System.out.println("Usage: uuid namespace name");
                System.out.println("   Produce a type 3 UUID in the specified namespace for the specified name");
                System.out.println("   The namspace can be either a known UUID or a URL");
                System.out.println("Usage: -h");
                System.out.println("   print this help");
                System.out.println("Reference: http://tools.ietf.org/rfc/rfc4122.txt");
            } else {
                UUID u = UUID.fromString(name);
                if (u == null) {
                    System.out.println("Invalid url/name");
                    System.exit(1);
                }
                System.out.println(u);
            }
        } else {
            UUID u = UUID.fromString(ns);
            if (u == null) {
                System.out.println("Namespace not a UUID or absolute URL: " + ns);
                System.exit(1);
            } else {
                System.out.println(UUID.fromName(u, name));
            }
        }
    }

    public static class UUIDJsonDeserializer
    extends JsonDeserializer<UUID> {
        public UUID deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            String s = jp.getText();
            return UUID.fromString(s);
        }
    }

    public static class UUIDJsonSerializer
    extends JsonSerializer<UUID> {
        public void serialize(UUID value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeString(value.toString());
        }
    }
}

