/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.rdl;

import java.net.NetworkInterface;
import java.net.SocketException;
import java.security.MessageDigest;
import java.util.Enumeration;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;

class UUIDGenerator {
    private static final byte[] xURL_NAMESPACE = new byte[]{17, -47, -99, -83, 107, -89, -72, 17, -128, -76, 0, -64, 79, -44, 48, -56};
    public static final byte[] URL_NAMESPACE = UUIDGenerator.standardBytes(xURL_NAMESPACE);
    private static Random rng = new Random();
    private static int clockSeq = rng.nextInt() & 0x3FFF;
    private static long prevMillis = 0L;
    private static final int JITTER = 256;
    private static AtomicInteger counter = new AtomicInteger(rng.nextInt() % 256);

    UUIDGenerator() {
    }

    static byte[] standardBytes(byte[] sortableBytes) {
        byte[] std = new byte[16];
        UUIDGenerator.copyToStandardBytes(sortableBytes, std);
        return std;
    }

    private static void copyToStandardBytes(byte[] b, byte[] result) {
        System.arraycopy(b, 8, result, 8, 8);
        result[0] = b[4];
        result[1] = b[5];
        result[2] = b[6];
        result[3] = b[7];
        result[4] = b[2];
        result[5] = b[3];
        result[6] = b[0];
        result[7] = b[1];
    }

    private static void copyFromStandardBytes(byte[] b, byte[] result) {
        System.arraycopy(b, 8, result, 8, 8);
        result[4] = b[0];
        result[5] = b[1];
        result[6] = b[2];
        result[7] = b[3];
        result[2] = b[4];
        result[3] = b[5];
        result[0] = b[6];
        result[1] = b[7];
    }

    public static byte[] getRandomNode() {
        byte[] result = new byte[6];
        rng.nextBytes(result);
        return result;
    }

    public static byte[] getEthernetNode() {
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface nif = e.nextElement();
                if (!nif.getDisplayName().startsWith("e")) continue;
                byte[] node = nif.getHardwareAddress();
                return node;
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return null;
    }

    public static long timestampToMillis(long timestamp) {
        return timestamp / 10000L - 12219292800000L;
    }

    public static long timestampFromMillis(long millis) {
        return (millis + 12219292800000L) * 10000L;
    }

    public static long timestamp() {
        long now = System.currentTimeMillis();
        int ticks = 0;
        if (now < prevMillis) {
            long sleepMillis = prevMillis - now + 1L;
            System.err.println("WARNING: clock went backwards, pausing for " + sleepMillis + " ms");
            UUIDGenerator.pause(sleepMillis);
            return UUIDGenerator.timestamp();
        }
        if (now == prevMillis) {
            ticks = counter.incrementAndGet();
            if (ticks == 9744) {
                UUIDGenerator.pause(1L);
                return UUIDGenerator.timestamp();
            }
        } else {
            prevMillis = now;
            counter.set(ticks %= 256);
        }
        return UUIDGenerator.timestampFromMillis(now) + (long)ticks;
    }

    private static void pause(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static byte[] type1(byte[] node) {
        return UUIDGenerator.type1(node, UUIDGenerator.timestamp());
    }

    public static byte[] type1(byte[] node, long ticks) {
        byte[] b = new byte[16];
        b[4] = (byte)(ticks >> 24);
        b[5] = (byte)(ticks >> 16);
        b[6] = (byte)(ticks >> 8);
        b[7] = (byte)ticks;
        b[3] = (byte)(ticks >> 32);
        b[2] = (byte)(ticks >> 40);
        b[0] = (byte)((ticks >> 56 & 0xFL) + 16L);
        b[1] = (byte)(ticks >> 48);
        int clk = 32768 + clockSeq;
        b[8] = (byte)(clk >> 8);
        b[9] = (byte)clk;
        System.arraycopy(node, 0, b, 10, 6);
        return UUIDGenerator.standardBytes(b);
    }

    public static byte[] type3(String str, byte[] namespace) {
        byte[] data = str.getBytes();
        byte[] context = new byte[16 + data.length];
        System.arraycopy(namespace, 0, context, 0, 16);
        System.arraycopy(data, 0, context, 16, data.length);
        try {
            MessageDigest hash = MessageDigest.getInstance("MD5");
            byte[] digest = hash.digest(context);
            byte[] b = new byte[16];
            System.arraycopy(digest, 0, b, 0, 16);
            b[0] = (byte)(digest[6] & 0xF | 0x30);
            b[1] = digest[7];
            b[2] = digest[4];
            b[3] = digest[5];
            b[4] = digest[0];
            b[5] = digest[1];
            b[6] = digest[2];
            b[7] = digest[3];
            b[8] = (byte)(digest[8] & 0x3F | 0x80);
            return UUIDGenerator.standardBytes(b);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static byte[] type4() {
        return UUIDGenerator.toBytes(UUID.randomUUID().toString());
    }

    public static byte[] type5(String uri, byte[] namespace) {
        byte[] data = uri.getBytes();
        byte[] context = new byte[16 + data.length];
        System.arraycopy(namespace, 0, context, 0, 16);
        System.arraycopy(data, 0, context, 16, data.length);
        try {
            MessageDigest hash = MessageDigest.getInstance("SHA1");
            byte[] digest = hash.digest(context);
            byte[] b = new byte[16];
            System.arraycopy(digest, 0, b, 0, 16);
            b[0] = (byte)(digest[6] & 0xF | 0x50);
            b[1] = digest[7];
            b[2] = digest[4];
            b[3] = digest[5];
            b[4] = digest[0];
            b[5] = digest[1];
            b[6] = digest[2];
            b[7] = digest[3];
            b[8] = (byte)(digest[8] & 0x3F | 0x80);
            return UUIDGenerator.standardBytes(b);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static byte[] toBytes(UUID uuid) {
        long hi = uuid.getMostSignificantBits();
        long lo = uuid.getLeastSignificantBits();
        byte[] b = new byte[]{(byte)(hi >> 8), (byte)hi, (byte)(hi >> 24), (byte)(hi >> 16), (byte)(hi >> 56), (byte)(hi >> 48), (byte)(hi >> 40), (byte)(hi >> 32), (byte)(lo >> 56), (byte)(lo >> 48), (byte)(lo >> 40), (byte)(lo >> 32), (byte)(lo >> 24), (byte)(lo >> 16), (byte)(lo >> 8), (byte)lo};
        return UUIDGenerator.standardBytes(b);
    }

    public static byte[] toBytes(String uuid) {
        int i;
        byte[] std = new byte[16];
        byte[] b = new byte[16];
        int j = 0;
        for (i = 0; i < 8; i += 2) {
            std[j++] = (byte)Integer.parseInt(uuid.substring(i, i + 2), 16);
        }
        for (i = 9; i < 13; i += 2) {
            std[j++] = (byte)Integer.parseInt(uuid.substring(i, i + 2), 16);
        }
        for (i = 14; i < 18; i += 2) {
            std[j++] = (byte)Integer.parseInt(uuid.substring(i, i + 2), 16);
        }
        for (i = 19; i < 23; i += 2) {
            std[j++] = (byte)Integer.parseInt(uuid.substring(i, i + 2), 16);
        }
        for (i = 24; i < 36; i += 2) {
            std[j++] = (byte)Integer.parseInt(uuid.substring(i, i + 2), 16);
        }
        return std;
    }

    public static UUID toJavaUUID(byte[] std) {
        byte[] b = std;
        long l0 = (((long)b[4] & 0xFFL) << 56) + (((long)b[5] & 0xFFL) << 48) + (((long)b[6] & 0xFFL) << 40) + (((long)b[7] & 0xFFL) << 32) + (((long)b[2] & 0xFFL) << 24) + (((long)b[3] & 0xFFL) << 16) + (((long)b[0] & 0xFFL) << 8) + ((long)b[1] & 0xFFL);
        long l1 = (((long)b[8] & 0xFFL) << 56) + (((long)b[9] & 0xFFL) << 48) + (((long)b[10] & 0xFFL) << 40) + (((long)b[11] & 0xFFL) << 32) + (((long)b[12] & 0xFFL) << 24) + (((long)b[13] & 0xFFL) << 16) + (((long)b[14] & 0xFFL) << 8) + ((long)b[15] & 0xFFL);
        return new UUID(l0, l1);
    }

    public static UUID toUUID(String uuid) {
        return UUID.fromString(uuid);
    }

    public static String toString(byte[] std) {
        char[] hex = new char[32];
        int i = 0;
        for (byte b : std) {
            hex[i++] = Character.forDigit(b >> 4 & 0xF, 16);
            hex[i++] = Character.forDigit(b & 0xF, 16);
        }
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < 8; ++i) {
            sb.append(hex[i]);
        }
        sb.append('-');
        for (i = 8; i < 12; ++i) {
            sb.append(hex[i]);
        }
        sb.append('-');
        for (i = 12; i < 16; ++i) {
            sb.append(hex[i]);
        }
        sb.append('-');
        for (i = 16; i < 20; ++i) {
            sb.append(hex[i]);
        }
        sb.append('-');
        for (i = 20; i < 32; ++i) {
            sb.append(hex[i]);
        }
        return sb.toString();
    }
}

