/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.rdl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.yahoo.rdl.ArrayTypeDef;
import com.yahoo.rdl.BaseType;
import com.yahoo.rdl.EnumElementDef;
import com.yahoo.rdl.EnumTypeDef;
import com.yahoo.rdl.MapTypeDef;
import com.yahoo.rdl.Number;
import com.yahoo.rdl.NumberTypeDef;
import com.yahoo.rdl.Schema;
import com.yahoo.rdl.StringTypeDef;
import com.yahoo.rdl.StructFieldDef;
import com.yahoo.rdl.StructTypeDef;
import com.yahoo.rdl.Timestamp;
import com.yahoo.rdl.Type;
import com.yahoo.rdl.UUID;
import com.yahoo.rdl.UnionTypeDef;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Validator {
    Schema schema;
    HashMap<String, Type> types;

    static Result valid() {
        return new Result(true, null);
    }

    static Result error(String context, String msg) {
        if (context.length() > 0) {
            msg = msg + " in " + context;
        }
        return new Result(false, msg);
    }

    public Validator(Schema schema) {
        this.schema = schema;
        this.types = new HashMap();
        this.types.put("Bool", new Type(BaseType.Bool));
        this.types.put("Int8", new Type(BaseType.Int8));
        this.types.put("Int16", new Type(BaseType.Int16));
        this.types.put("Int32", new Type(BaseType.Int32));
        this.types.put("Int64", new Type(BaseType.Int64));
        this.types.put("Float32", new Type(BaseType.Float32));
        this.types.put("Float64", new Type(BaseType.Float64));
        this.types.put("Bytes", new Type(BaseType.Bytes));
        this.types.put("String", new Type(BaseType.String));
        this.types.put("Timestamp", new Type(BaseType.Timestamp));
        this.types.put("UUID", new Type(BaseType.UUID));
        this.types.put("Array", new Type(BaseType.Array));
        this.types.put("Map", new Type(BaseType.Map));
        this.types.put("Struct", new Type(BaseType.Struct));
        this.types.put("Enum", new Type(BaseType.Enum));
        this.types.put("Union", new Type(BaseType.Union));
        this.types.put("Any", new Type(BaseType.Any));
        for (Type t : schema.types) {
            String name = null;
            switch (t.variant) {
                case BaseType: {
                    name = String.valueOf((Object)t.BaseType);
                    break;
                }
                case StructTypeDef: {
                    name = t.StructTypeDef.name;
                    break;
                }
                case MapTypeDef: {
                    name = t.MapTypeDef.name;
                    break;
                }
                case ArrayTypeDef: {
                    name = t.ArrayTypeDef.name;
                    break;
                }
                case EnumTypeDef: {
                    name = t.EnumTypeDef.name;
                    break;
                }
                case UnionTypeDef: {
                    name = t.UnionTypeDef.name;
                    break;
                }
                case StringTypeDef: {
                    name = t.StringTypeDef.name;
                    break;
                }
                case BytesTypeDef: {
                    name = t.BytesTypeDef.name;
                    break;
                }
                case NumberTypeDef: {
                    name = t.NumberTypeDef.name;
                    break;
                }
                case AliasTypeDef: {
                    name = t.AliasTypeDef.name;
                }
            }
            this.types.put(name, t);
        }
    }

    Type type(String name) {
        return this.types.get(name);
    }

    public Result validate(Object data, String typename) {
        return this.validate(data, typename, typename, "data");
    }

    public Result validate(Object data, String typename, String alias, String context) {
        Type t = this.type(typename);
        if (t == null) {
            return Validator.error("", "No such type: " + typename);
        }
        return this.validate(data, t, alias, context);
    }

    public Result validate(Object data, Type t, String alias, String context) {
        switch (t.variant) {
            case BaseType: {
                return this.validateBaseType(data, t.BaseType, alias, context);
            }
            case StructTypeDef: {
                return this.validateStructType(data, t.StructTypeDef, context);
            }
            case MapTypeDef: {
                return this.validateMapType(data, t.MapTypeDef, context);
            }
            case ArrayTypeDef: {
                return this.validateArrayType(data, t.ArrayTypeDef, context);
            }
            case EnumTypeDef: {
                return this.validateEnumType(data, t.EnumTypeDef, context);
            }
            case UnionTypeDef: {
                return this.validateUnionType(data, t.UnionTypeDef, context);
            }
            case StringTypeDef: {
                return this.validateStringType(data, t.StringTypeDef, context);
            }
            case BytesTypeDef: {
                break;
            }
            case NumberTypeDef: {
                return this.validateNumberType(data, t.NumberTypeDef, context);
            }
            case AliasTypeDef: {
                return this.validate(data, t.AliasTypeDef.type, t.AliasTypeDef.name, context);
            }
        }
        return Validator.error(context, "NYI: " + (Object)((Object)t.variant));
    }

    Type fieldType(String type, String items, String keys) {
        if ("Array".equalsIgnoreCase(type)) {
            ArrayTypeDef atype = new ArrayTypeDef().type(type);
            if (items != null) {
                atype.items(items);
            }
            return new Type(atype);
        }
        return this.type(type);
    }

    Result validateMapType(Object data, MapTypeDef typedef, String context) {
        if (data instanceof Map) {
            Map map = (Map)data;
            int size = map.size();
            if (typedef.size != null && size != typedef.size) {
                return Validator.error(context, "Bad map size for type " + typedef.name + ", expected " + typedef.size + ", got " + size);
            }
            if (typedef.minSize != null && size < typedef.minSize) {
                return Validator.error(context, "Bad map size for type " + typedef.name + ", expected no smaller than " + typedef.minSize + ", got " + size);
            }
            if (typedef.maxSize != null && size < typedef.maxSize) {
                return Validator.error(context, "Bad map size for type " + typedef.name + ", expected no larger than " + typedef.maxSize + ", got " + size);
            }
            Type kt = this.type(typedef.keys);
            if (kt == null) {
                return Validator.error("", "No such type: " + typedef.keys);
            }
            Type it = this.type(typedef.items);
            if (it == null) {
                return Validator.error("", "No such type: " + typedef.items);
            }
            int i = 0;
            for (Map.Entry e : map.entrySet()) {
                Result tmp = this.validate(e.getKey(), kt, typedef.keys, context + "[key]value");
                if (!tmp.valid) {
                    return tmp;
                }
                tmp = this.validate(e.getValue(), it, typedef.items, context + "[" + i + "]");
                if (tmp.valid) continue;
                return tmp;
            }
        }
        return Validator.valid();
    }

    Result validateArrayType(Object data, ArrayTypeDef typedef, String context) {
        if (data instanceof List) {
            List lst = (List)data;
            if (typedef.size != null && lst.size() != typedef.size.intValue()) {
                return Validator.error(context, "Bad array size for type " + typedef.name + ", expected " + typedef.size + ", got " + lst.size());
            }
            if (typedef.minSize != null && lst.size() < typedef.minSize) {
                return Validator.error(context, "Bad array size for type " + typedef.name + ", expected no smaller than " + typedef.minSize + ", got " + lst.size());
            }
            if (typedef.maxSize != null && lst.size() < typedef.maxSize) {
                return Validator.error(context, "Bad array size for type " + typedef.name + ", expected no larger than " + typedef.maxSize + ", got " + lst.size());
            }
            if (typedef.items != null) {
                Type it = this.type(typedef.items);
                if (it == null) {
                    return Validator.error("", "No such type: " + typedef.items);
                }
                int i = 0;
                for (Object item : lst) {
                    Result tmp = this.validate(item, it, typedef.items, context + "[" + i + "]");
                    if (tmp.valid) continue;
                    return tmp;
                }
            }
        }
        return Validator.valid();
    }

    Result validateStructType(Object data, StructTypeDef typedef, String context) {
        if (data instanceof Map) {
            Map map = (Map)data;
            ArrayList<StructFieldDef> fields = new ArrayList<StructFieldDef>();
            this.flattenFields(typedef, fields);
            for (StructFieldDef field : fields) {
                if (!map.containsKey(field.name)) {
                    if (field.optional || field._default != null) continue;
                    return Validator.error(context, "Missing required field '" + field.name + "' for type " + typedef.name);
                }
                Type ftype = this.fieldType(field.type, field.items, field.keys);
                Result tmp = this.validate(map.get(field.name), ftype, field.type, context + "." + field.name);
                if (tmp.valid) continue;
                return tmp;
            }
            return Validator.valid();
        }
        return this.validateObject(data, typedef, context);
    }

    String pretty(Object o) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.enable(SerializationFeature.INDENT_OUTPUT);
            mapper.disable(SerializationFeature.WRITE_NULL_MAP_VALUES);
            return mapper.writeValueAsString(o);
        }
        catch (Exception e) {
            return String.valueOf(o);
        }
    }

    String javaFieldName(String rdlFieldName) {
        switch (rdlFieldName) {
            case "default": {
                return "_default";
            }
        }
        return rdlFieldName;
    }

    void flattenFields(StructTypeDef typedef, List<StructFieldDef> fields) {
        if (!typedef.type.equalsIgnoreCase("Struct")) {
            Type t = this.type(typedef.type);
            this.flattenFields(t.StructTypeDef, fields);
        }
        fields.addAll(typedef.fields);
    }

    Result validateObject(Object data, StructTypeDef typedef, String context) {
        Class<?> cl = data.getClass();
        ArrayList<StructFieldDef> fields = new ArrayList<StructFieldDef>();
        this.flattenFields(typedef, fields);
        for (StructFieldDef f : fields) {
            String fname = f.name;
            fname = this.javaFieldName(fname);
            try {
                Field field = cl.getField(fname);
                try {
                    Result tmp;
                    Object td;
                    Object fdata = field.get(data);
                    if (fdata == null) {
                        if (f._default != null) {
                            field.set(data, f._default);
                            continue;
                        }
                        if (f.optional) continue;
                        return Validator.error(context, "Missing required field: " + fname + " for type " + typedef.name);
                    }
                    if (f.keys != null) {
                        td = new MapTypeDef().type("Map").keys(f.keys).items(f.items);
                        tmp = this.validateMapType(fdata, (MapTypeDef)td, context);
                        if (!tmp.valid) {
                            return tmp;
                        }
                    } else if (f.items != null) {
                        td = new ArrayTypeDef().type("Array").items(f.items);
                        tmp = this.validateArrayType(fdata, (ArrayTypeDef)td, context);
                        if (!tmp.valid) {
                            return tmp;
                        }
                    }
                    Result tmp2 = this.validate(fdata, f.type, f.type, context + "." + fname);
                    if (tmp2.valid) continue;
                    return tmp2;
                }
                catch (IllegalAccessException e) {
                    return Validator.error(context, "Inaccessible field in object: " + fname + " for type " + typedef.name);
                }
            }
            catch (NoSuchFieldException e) {
                return Validator.error(context, "Missing field in object: " + fname + " for type " + typedef.name);
            }
        }
        return Validator.valid();
    }

    Result validateStringType(Object data, StringTypeDef typedef, String context) {
        if (data != null && data instanceof String) {
            String s = (String)data;
            int len = s.length();
            if (typedef.maxSize != null && len > typedef.maxSize) {
                return Validator.error(context, "String larger than maxSize of " + typedef.maxSize + " for type " + typedef.name);
            }
            if (typedef.minSize != null && len < typedef.minSize) {
                return Validator.error(context, "String smaller than minSize of " + typedef.minSize + " for type " + typedef.name);
            }
            if (typedef.pattern != null && !s.matches(typedef.pattern)) {
                return Validator.error(context, "String pattern mismatch (expected \"" + typedef.pattern + "\")  for type " + typedef.name);
            }
        }
        return Validator.valid();
    }

    long longValueOf(Number n) {
        switch (n.variant) {
            case Int8: {
                return n.Int8.byteValue();
            }
            case Int16: {
                return n.Int16.shortValue();
            }
            case Int32: {
                return n.Int32.intValue();
            }
            case Int64: {
                return n.Int64;
            }
        }
        return 0L;
    }

    double doubleValueOf(Number n) {
        switch (n.variant) {
            case Float32: {
                return n.Float32.floatValue();
            }
            case Float64: {
                return n.Float64;
            }
        }
        return 0.0;
    }

    Result checkNumber(java.lang.Number n, Number ref, boolean checkMin, String context, String tname) {
        switch (ref.variant) {
            case Int8: 
            case Int16: 
            case Int32: 
            case Int64: {
                long nref = this.longValueOf(ref);
                if (checkMin) {
                    if (n.longValue() < nref) {
                        return Validator.error(context, "Number smaller than min of " + nref + " for type " + tname);
                    }
                } else if (n.longValue() > nref) {
                    return Validator.error(context, "Number larger than max of " + nref + " for type " + tname);
                }
                return null;
            }
        }
        double dref = this.doubleValueOf(ref);
        if (checkMin) {
            if (n.doubleValue() < dref) {
                return Validator.error(context, "Number smaller than min of " + dref + " for type " + tname);
            }
        } else if (n.doubleValue() > dref) {
            return Validator.error(context, "Number larger than max of " + dref + " for type " + tname);
        }
        return null;
    }

    Result validateNumberType(Object data, NumberTypeDef typedef, String context) {
        if (data != null && data instanceof java.lang.Number) {
            Result r;
            java.lang.Number n = (java.lang.Number)data;
            if (typedef.max != null && (r = this.checkNumber(n, typedef.max, false, context, typedef.name)) != null) {
                return r;
            }
            if (typedef.min != null && (r = this.checkNumber(n, typedef.min, true, context, typedef.name)) != null) {
                return r;
            }
        }
        return Validator.valid();
    }

    Result validateEnumType(Object data, EnumTypeDef typedef, String context) {
        if (data instanceof String) {
            String sym = (String)data;
            for (EnumElementDef ed : typedef.elements) {
                if (!sym.equals(ed.symbol)) continue;
                return Validator.valid();
            }
            return Validator.error(context, "Not a valid " + typedef.name + ", " + data.getClass().getName());
        }
        return Validator.valid();
    }

    Result validateUnionType(Object data, UnionTypeDef typedef, String context) {
        if (data == null) {
            return Validator.valid();
        }
        if (data instanceof Map) {
            Map map = (Map)data;
            for (String variant : typedef.variants) {
                if (!map.containsKey(variant)) continue;
                return this.validate(map.get(variant), variant, variant, context + "<" + variant + ">");
            }
        } else {
            Class<?> cl = data.getClass();
            for (String variant : typedef.variants) {
                try {
                    Field field = cl.getField(variant);
                    try {
                        Object vdata = field.get(data);
                        if (vdata == null) continue;
                        return this.validate(vdata, variant, variant, context + "<" + variant + ">");
                    }
                    catch (IllegalAccessException e) {
                        return Validator.error(context, "Inaccessible field in object: " + variant + " for type " + typedef.name);
                    }
                }
                catch (NoSuchFieldException e) {
                    return Validator.error(context, "Missing field in object: " + variant + " for type " + typedef.name);
                }
            }
        }
        return Validator.error(context, "Not a valid " + typedef.name + ": " + data);
    }

    Result validateBaseType(Object data, BaseType typedef, String alias, String context) {
        switch (typedef) {
            case Bool: {
                if (!(data instanceof Boolean)) break;
                return Validator.valid();
            }
            case Int8: {
                int n;
                if (data instanceof Byte) {
                    return Validator.valid();
                }
                if (!(data instanceof Integer) || (n = ((Integer)data).intValue()) > 127 || n < -128) break;
                return Validator.valid();
            }
            case Int16: {
                int n;
                if (data instanceof Short || data instanceof Byte) {
                    return Validator.valid();
                }
                if (!(data instanceof Integer) || (n = ((Integer)data).intValue()) > Short.MAX_VALUE || n < Short.MIN_VALUE) break;
                return Validator.valid();
            }
            case Int32: {
                if (!(data instanceof Integer) && !(data instanceof Short) && !(data instanceof Byte)) break;
                return Validator.valid();
            }
            case Int64: {
                if (!(data instanceof Long) && !(data instanceof Integer) && !(data instanceof Short) && !(data instanceof Byte)) break;
                return Validator.valid();
            }
            case Float32: {
                if (!(data instanceof Float)) break;
                return Validator.valid();
            }
            case Float64: {
                if (!(data instanceof Double)) break;
                return Validator.valid();
            }
            case String: {
                if (!(data instanceof String)) break;
                return Validator.valid();
            }
            case Bytes: {
                if (!(data instanceof byte[])) break;
                return Validator.valid();
            }
            case Timestamp: {
                Timestamp ts;
                if (data instanceof Timestamp) {
                    return Validator.valid();
                }
                if (!(data instanceof String) || (ts = Timestamp.fromString((String)data)) == null) break;
                return Validator.valid();
            }
            case UUID: {
                UUID u;
                if (data instanceof UUID) {
                    return Validator.valid();
                }
                if (!(data instanceof String) || (u = UUID.fromString((String)data)) == null) break;
                return Validator.valid();
            }
            case Array: {
                if (data != null && !(data instanceof List)) break;
                return Validator.valid();
            }
            case Map: {
                if (data != null && !(data instanceof Map)) break;
                return Validator.valid();
            }
            case Any: {
                return Validator.valid();
            }
        }
        String s = "null";
        if (data != null) {
            s = data.getClass().getName();
        }
        return Validator.error(context, "Not a valid " + alias + ", " + s);
    }

    public static class Result {
        public final boolean valid;
        public final String error;

        Result(boolean v, String e) {
            this.valid = v;
            this.error = e;
        }

        public String toString() {
            if (this.valid) {
                return "<Validation OK>";
            }
            return "<Validation error: " + this.error + ">";
        }
    }
}

