/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.rdl;

import com.yahoo.rdl.Array;
import com.yahoo.rdl.Struct;
import com.yahoo.rdl.Timestamp;
import com.yahoo.rdl.UUID;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Iterator;
import javax.xml.bind.DatatypeConverter;

public class Value {
    static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static boolean asBoolean(Object o) {
        if (o == null) {
            return false;
        }
        return (Boolean)o;
    }

    public static byte asByte(Object o) {
        if (o == null) {
            return 0;
        }
        return ((Number)o).byteValue();
    }

    public static short asShort(Object o) {
        if (o == null) {
            return 0;
        }
        return ((Number)o).shortValue();
    }

    public static int asInt(Object o) {
        if (o == null) {
            return 0;
        }
        return ((Number)o).intValue();
    }

    public static long asLong(Object o) {
        if (o == null) {
            return 0L;
        }
        if (o instanceof String) {
            try {
                return Long.parseLong((String)o);
            }
            catch (NumberFormatException numberFormatException) {
            }
        } else if (o instanceof Timestamp) {
            return ((Timestamp)o).millis();
        }
        return ((Number)o).longValue();
    }

    public static float asFloat(Object o) {
        if (o == null) {
            return 0.0f;
        }
        return ((Number)o).floatValue();
    }

    public static double asDouble(Object o) {
        if (o == null) {
            return 0.0;
        }
        return ((Number)o).doubleValue();
    }

    public static String asString(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof byte[]) {
            return Value.encodeBase64((byte[])o, true);
        }
        if (o instanceof Enum) {
            return ((Enum)o).name();
        }
        return String.valueOf(o);
    }

    public static Timestamp asTimestamp(Object o) {
        if (o == null) {
            return null;
        }
        return Timestamp.fromString(o.toString());
    }

    public static UUID asUUID(Object o) {
        if (o == null) {
            return null;
        }
        return UUID.fromString(o.toString());
    }

    public static byte[] asBytes(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            try {
                return ((String)o).getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
            }
        } else if (o instanceof UUID) {
            return ((UUID)o).toBytes();
        }
        return (byte[])o;
    }

    public static void appendToString(Object o, StringBuilder sb, String indent) {
        if (o == null) {
            sb.append("null");
        } else if (o instanceof Struct) {
            ((Struct)o).appendToString(sb, indent);
        } else if (o instanceof Array) {
            ((Array)o).appendToString(sb, indent);
        } else if (o instanceof String) {
            Value.escapeString(sb, (String)o);
        } else if (o instanceof Timestamp) {
            Value.escapeString(sb, o.toString());
        } else if (o instanceof UUID) {
            Value.escapeString(sb, o.toString());
        } else {
            sb.append(o.toString());
        }
    }

    public static void escapeString(StringBuilder sb, String s) {
        if (s == null) {
            sb.append("\"\"");
        } else {
            int max = s.length();
            char[] chars = new char[max];
            s.getChars(0, max, chars, 0);
            sb.append('\"');
            for (int i = 0; i < max; ++i) {
                char c = chars[i];
                if (c == '\\') {
                    sb.append("\\\\");
                    continue;
                }
                if (c == '\"') {
                    sb.append("\\\"");
                    continue;
                }
                if (c == '\b') {
                    sb.append("\\b");
                    continue;
                }
                if (c == '\n') {
                    sb.append("\\n");
                    continue;
                }
                if (c == '\r') {
                    sb.append("\\r");
                    continue;
                }
                if (c == '\f') {
                    sb.append("\\f");
                    continue;
                }
                if (c == '\t') {
                    sb.append("\\t");
                    continue;
                }
                if (c < ' ') {
                    sb.append("\\u");
                    sb.append(HEX[c >> 12 & 0xF]);
                    sb.append(HEX[c >> 8 & 0xF]);
                    sb.append(HEX[c >> 4 & 0xF]);
                    sb.append(HEX[c & 0xF]);
                    continue;
                }
                sb.append(c);
            }
            sb.append('\"');
        }
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1 instanceof byte[]) {
            if (o2 instanceof byte[]) {
                return Arrays.equals((byte[])o1, (byte[])o2);
            }
            return false;
        }
        if (o1 instanceof Number) {
            if (o2 instanceof Number) {
                if (o1 instanceof Integer) {
                    return ((Number)o2).intValue() == ((Integer)o1).intValue();
                }
                if (o1 instanceof Double) {
                    return ((Number)o2).doubleValue() == ((Double)o1).doubleValue();
                }
                if (o1 instanceof Long) {
                    return ((Number)o2).longValue() == ((Long)o1).longValue();
                }
                if (o1 instanceof Float) {
                    return ((Number)o2).floatValue() == ((Float)o1).floatValue();
                }
                if (o1 instanceof Short) {
                    return ((Number)o2).shortValue() == ((Short)o1).shortValue();
                }
                if (o1 instanceof Byte) {
                    return ((Number)o2).byteValue() == ((Byte)o1).byteValue();
                }
            }
            return false;
        }
        return o1.equals(o2);
    }

    public static String encodeBase64(byte[] bytes, boolean urlSafe) {
        try {
            String b64 = DatatypeConverter.printBase64Binary((byte[])bytes);
            if (urlSafe) {
                b64 = b64.replace("+", "-").replace("/", "_").replace("=", ".");
            }
            return b64;
        }
        catch (Exception err) {
            return null;
        }
    }

    public static byte[] decodeBase64(String encoded, boolean urlSafe) {
        try {
            if (urlSafe) {
                encoded = encoded.replace(".", "=").replace("_", "/").replace("-", "+");
            }
            return DatatypeConverter.parseBase64Binary((String)encoded);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static class TypedIterableIterator<T>
    implements Iterator<T> {
        Iterator<Object> it;

        TypedIterableIterator(Iterator<Object> i) {
            this.it = i;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public T next() {
            return (T)this.it.next();
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }

    public static class TypedIterableIterable<T>
    implements Iterable<T> {
        Iterable<Object> it;

        TypedIterableIterable(Iterable<Object> i) {
            this.it = i;
        }

        @Override
        public Iterator<T> iterator() {
            return new TypedIterableIterator(this.it.iterator());
        }
    }

    public static class TypedIterable<T>
    implements Iterable<T> {
        Array array;

        TypedIterable(Array a) {
            this.array = a;
        }

        @Override
        public Iterator<T> iterator() {
            return new TypedIterator(this.array);
        }
    }

    public static class TypedIterator<T>
    implements Iterator<T> {
        Array values;
        int i;

        TypedIterator(Array a) {
            this.values = a;
            this.i = 0;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.values.size();
        }

        @Override
        public T next() {
            return (T)this.values.get(this.i++);
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

