/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tbin;

import com.yahoo.rdl.TypeRegistry;
import com.yahoo.tbin.TBinDecoder;
import com.yahoo.tbin.TBinEncoder;
import com.yahoo.tbin.TypeDef;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class TBin {
    public static final int CURRENT_VERSION = 1;
    static final int NULL_TAG = 0;
    static final int BOOL_TAG = 1;
    static final int INT8_TAG = 2;
    static final int INT16_TAG = 3;
    static final int INT32_TAG = 4;
    static final int INT64_TAG = 5;
    static final int FLOAT32_TAG = 6;
    static final int FLOAT64_TAG = 7;
    static final int BYTES_TAG = 8;
    static final int STRING_TAG = 9;
    static final int TIMESTAMP_TAG = 10;
    static final int SYMBOL_TAG = 11;
    static final int UUID_TAG = 12;
    static final int ARRAY_TAG = 13;
    static final int MAP_TAG = 14;
    static final int STRUCT_TAG = 15;
    static final int ANY_TAG = 16;
    static final int DEF_ARRAY_TAG = 17;
    static final int DEF_MAP_TAG = 18;
    static final int DEF_STRUCT_TAG = 19;
    static final int DEF_UNION_TAG = 20;
    static final int DEF_ENUM_TAG = 21;
    static final int UNION_TAG = 22;
    static final int ENUM_TAG = 23;
    static final int VERSION_TAG = 24;
    static final int VERSION_TAG_MASK = 248;
    static final int VERSION_DATA_MASK = 7;
    static final int MIN_VERSION_TAG = 24;
    static final int CUR_VERSION_TAG = 24;
    static final int MAX_VERSION_TAG = 31;
    static final int MAX_VERSION = 10;
    static final int TINY_STR_TAG = 32;
    static final int TINY_STR_TAG_MASK = 224;
    static final int TINY_STR_DATA_MASK = 31;
    static final int TINY_STR_MAXLEN = 31;
    static final int FIRST_USER_TAG = 64;
    private static final char[] hexDigits = "0123456789abcdef".toCharArray();

    TBin() {
    }

    public static byte[] bytes(Object o) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            TBinEncoder enc = new TBinEncoder(out);
            enc.encode(o);
            return out.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] bytes(Object o, TypeDef sig) {
        throw new RuntimeException("TBin.bytes(Object, TypeDef) - not implemented");
    }

    public static byte[] bytes(Object o, TypeRegistry reg, String typeName) {
        throw new RuntimeException("TBin.bytes(Object, TypeRegistry, String) - not implemented");
    }

    public static Object fromBytes(byte[] tbinData) {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(tbinData);
            TBinDecoder dec = new TBinDecoder(in);
            return dec.decode();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T fromBytes(byte[] tbinData, Class<T> dataType) {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(tbinData);
            TBinDecoder dec = new TBinDecoder(in);
            return dec.decode(dataType);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String hexByte(byte b) {
        return "" + hexDigits[b >>> 4 & 0xF] + hexDigits[b & 0xF];
    }

    public static String hexByte(int b) {
        return TBin.hexByte((byte)b);
    }

    public static String hex(byte[] bytes, int count) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            byte b = bytes[i];
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(hexDigits[b >>> 4 & 0xF]);
            sb.append(hexDigits[b & 0xF]);
        }
        return sb.toString();
    }

    static void println(Object o) {
        System.out.println(o);
    }

    void panic(Object msg) {
        try {
            throw new RuntimeException("Panic: " + msg);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
            return;
        }
    }
}

