/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tbin;

import com.yahoo.rdl.Array;
import com.yahoo.rdl.Struct;
import com.yahoo.rdl.Symbol;
import com.yahoo.rdl.Timestamp;
import com.yahoo.rdl.UUID;
import com.yahoo.tbin.TBin;
import com.yahoo.tbin.TBinException;
import com.yahoo.tbin.TypeDef;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TBinDecoder
extends TBin {
    private InputStream raw;
    private BufferedInputStream in;
    private ArrayList<String> syms;
    private ArrayList<TypeDef> types;
    private byte[] buf;
    private int dataVersion;
    private int currentCount;

    public TBinDecoder(InputStream in) {
        this.raw = in;
        this.in = new BufferedInputStream(this.raw);
        this.syms = new ArrayList(1000);
        this.types = new ArrayList();
        this.buf = new byte[256];
        this.dataVersion = 0;
        this.currentCount = 0;
    }

    public void close() throws IOException {
        this.in.close();
        this.raw.close();
    }

    public <T> T decode(Class<T> dataClass) throws IOException {
        if (dataClass == Object.class) {
            return (T)this.decode();
        }
        TypeDef dataType = this.nextType();
        return this.decode(dataType, dataClass);
    }

    public <T> T decode(TypeDef type, Class<T> dataClass) throws IOException {
        switch (type.tag) {
            case 1: {
                return (T)new Boolean(this.nextBoolean());
            }
            case 2: {
                return (T)new Byte(this.nextByte());
            }
            case 3: {
                return (T)new Short(this.nextShort());
            }
            case 4: {
                return (T)new Integer(this.nextInt());
            }
            case 5: {
                return (T)new Long(this.nextLong());
            }
            case 6: {
                return (T)new Float(this.nextFloat());
            }
            case 7: {
                return (T)new Double(this.nextDouble());
            }
            case 8: {
                return (T)this.nextByteArray();
            }
            case 9: {
                return (T)this.nextString();
            }
            case 10: {
                return (T)this.nextTimestamp();
            }
            case 11: {
                return (T)this.nextSymbol();
            }
            case 12: {
                return (T)this.nextUUID();
            }
            case 13: {
                return this.decodeArray(type, dataClass);
            }
            case 14: {
                return this.decodeMap(type, dataClass);
            }
            case 15: {
                return this.decodeStruct(type, dataClass);
            }
            case 22: {
                return this.decodeUnion(type, dataClass);
            }
            case 16: {
                return this.decode(this.nextType(), dataClass);
            }
            case 0: {
                return null;
            }
        }
        throw new TBinException("Unsupported type in TBin stream: " + type);
    }

    <T> T decodeArray(TypeDef otype, Class<T> oclass) throws IOException {
        int count = this.nextCount(otype);
        if (List.class.isAssignableFrom(oclass)) {
            try {
                List list = (List)ArrayList.class.newInstance();
                for (int i = 0; i < count; ++i) {
                    list.add(this.decode(otype.items, Object.class));
                }
                return (T)list;
            }
            catch (IllegalAccessException | InstantiationException list) {}
        } else if (oclass == Object.class || oclass == Array.class) {
            Array ary = new Array();
            for (int i = 0; i < count; ++i) {
                TypeDef itemType = this.nextItemType(otype, i);
                Object o = this.decode(itemType);
                ary.add(o);
            }
            return (T)ary;
        }
        throw new TBinException("Cannot instantiate array as target object of class " + oclass.getName());
    }

    <T> T decodeMap(TypeDef otype, Class<T> oclass) throws IOException {
        int count = this.nextCount(otype);
        if (Map.class.isAssignableFrom(oclass)) {
            try {
                Map map = (Map)HashMap.class.newInstance();
                for (int i = 0; i < count; ++i) {
                    Object key = this.decode(otype.keys, Object.class);
                    Object val = this.decode(otype.items, Object.class);
                    map.put(key, val);
                }
                return (T)map;
            }
            catch (IllegalAccessException | InstantiationException map) {}
        } else {
            try {
                T o = oclass.newInstance();
                for (int i = 0; i < count; ++i) {
                    Object key = this.decode(otype.keys, Object.class);
                    String fname = null;
                    if (key instanceof String) {
                        fname = (String)key;
                    } else if (key instanceof Symbol) {
                        fname = ((Symbol)key).name;
                    } else {
                        throw new TBinException("Cannot instantiate map as target object of class " + oclass.getName());
                    }
                    Object val = this.decode(otype.items, Object.class);
                    TypeDef ftype = otype.items;
                    Field f = oclass.getDeclaredField(fname);
                    if (f == null) continue;
                    f.setAccessible(true);
                    f.set(o, val);
                }
                return o;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchFieldException e) {
                throw new TBinException("Cannot instantiate map as target object of class " + oclass.getName());
            }
        }
        throw new TBinException("Cannot instantiate map as target object of class " + oclass.getName());
    }

    <T> T decodeUnion(TypeDef otype, Class<T> oclass) throws IOException {
        int variant = this.readNonNegativeInt();
        TypeDef utype = otype.variants.get(variant - 1);
        try {
            T union = oclass.newInstance();
            Field[] fields = oclass.getFields();
            Field vfield = fields[0];
            Field ufield = fields[variant];
            Class<?> uclass = ufield.getType();
            vfield.setAccessible(true);
            String n = ufield.getName();
            vfield.set(union, Enum.valueOf(vfield.getType(), ufield.getName()));
            ufield.set(union, this.decode(utype, uclass));
            return union;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new TBinException("Cannot instantiate map as target object of class " + oclass.getName());
        }
    }

    <T> T decodeStruct(TypeDef otype, Class<T> oclass) throws IOException {
        T o;
        if (oclass == Struct.class || oclass == Object.class) {
            Struct s = new Struct();
            int fcount = this.nextCount(otype);
            for (int i = 0; i < fcount; ++i) {
                String fname = this.nextItemName(otype, i);
                TypeDef ftype = this.nextItemType(otype, i);
                Object fval = this.decode(ftype, Object.class);
                s.put(fname, fval);
            }
            return (T)s;
        }
        try {
            o = oclass.newInstance();
            int fcount = otype.fields != null ? otype.fields.size() : this.nextCount(otype);
            for (int i = 0; i < fcount; ++i) {
                String fname = this.nextItemName(otype, i);
                TypeDef ftype = this.nextItemType(otype, i);
                fname = this.sanitizeFieldName(fname);
                Field f = oclass.getDeclaredField(fname);
                f.setAccessible(true);
                Class<?> fclass = f.getType();
                this.decodeStructField(o, f, ftype, fclass, oclass);
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchFieldException e) {
            e.printStackTrace();
            throw new TBinException("Cannot instantiate target object of class " + oclass.getName());
        }
        return o;
    }

    String sanitizeFieldName(String fname) {
        if ("default".equals(fname)) {
            return "_" + fname;
        }
        return fname;
    }

    <T, F> void decodeStructField(T o, Field f, TypeDef ftype, Class<F> fclass, Class<T> oclass) throws IOException, IllegalAccessException, InstantiationException {
        switch (ftype.tag) {
            case 1: {
                f.setBoolean(o, this.nextBoolean());
                break;
            }
            case 2: {
                f.setByte(o, this.nextByte());
                break;
            }
            case 3: {
                f.setShort(o, this.nextShort());
                break;
            }
            case 4: {
                f.setInt(o, this.nextInt());
                break;
            }
            case 5: {
                f.setLong(o, this.nextLong());
                break;
            }
            case 6: {
                f.setFloat(o, this.nextFloat());
                break;
            }
            case 7: {
                f.setDouble(o, this.nextDouble());
                break;
            }
            case 8: {
                f.set(o, this.nextByteArray());
                break;
            }
            case 9: {
                f.set(o, this.nextString());
                break;
            }
            case 10: {
                f.set(o, this.nextTimestamp());
                break;
            }
            case 11: {
                f.set(o, this.nextSymbol());
                break;
            }
            case 12: {
                f.set(o, this.nextUUID());
                break;
            }
            case 13: {
                int count = this.nextCount(ftype);
                if (List.class.isAssignableFrom(fclass)) {
                    Class iclass = (Class)((ParameterizedType)f.getGenericType()).getActualTypeArguments()[0];
                    List list = (List)ArrayList.class.newInstance();
                    for (int i = 0; i < count; ++i) {
                        this.decodeInit(ftype.items);
                        list.add(this.decode(ftype.items, iclass));
                    }
                    f.set(o, list);
                    break;
                }
                throw new TBinException("Cannot instantiate array as target object of class " + fclass.getName());
            }
            case 14: {
                int count = this.nextCount(ftype);
                if (Map.class.isAssignableFrom(fclass)) {
                    Class kclass = (Class)((ParameterizedType)f.getGenericType()).getActualTypeArguments()[0];
                    Class iclass = (Class)((ParameterizedType)f.getGenericType()).getActualTypeArguments()[1];
                    Map map = (Map)HashMap.class.newInstance();
                    for (int i = 0; i < count; ++i) {
                        map.put(this.decode(ftype.keys, kclass), this.decode(ftype.items, iclass));
                    }
                    f.set(o, map);
                    break;
                }
                throw new TBinException("Cannot instantiate array as target object of class " + fclass.getName());
            }
            case 15: {
                f.set(o, this.decodeStruct(ftype, fclass));
                break;
            }
            case 16: {
                ftype = this.nextType();
                if (ftype.tag == 13) {
                    int count = this.nextCount(ftype);
                    if (List.class.isAssignableFrom(fclass)) {
                        Class iclass = (Class)((ParameterizedType)f.getGenericType()).getActualTypeArguments()[0];
                        List list = (List)ArrayList.class.newInstance();
                        for (int i = 0; i < count; ++i) {
                            list.add(this.decode(ftype.items, iclass));
                        }
                        f.set(o, list);
                        break;
                    }
                    throw new TBinException("Cannot instantiate array as target object of class " + fclass.getName());
                }
                f.set(o, this.decode(ftype, fclass));
                break;
            }
            default: {
                this.panic("FIX THIS: " + ftype);
            }
        }
    }

    public Object decode() throws IOException {
        return this.decode(this.nextType());
    }

    public Object decode(TypeDef type) throws IOException {
        switch (type.tag) {
            case 1: {
                return this.nextBoolean();
            }
            case 2: {
                return this.nextByte();
            }
            case 3: {
                return this.nextShort();
            }
            case 4: {
                return this.nextInt();
            }
            case 5: {
                return this.nextLong();
            }
            case 6: {
                return Float.valueOf(this.nextFloat());
            }
            case 7: {
                return this.nextDouble();
            }
            case 8: {
                return this.nextByteArray();
            }
            case 9: {
                return this.nextString();
            }
            case 10: {
                return this.nextTimestamp();
            }
            case 11: {
                return this.nextSymbol();
            }
            case 12: {
                return this.nextUUID();
            }
            case 13: {
                int max = this.nextCount(type);
                Array ary = new Array();
                for (int i = 0; i < max; ++i) {
                    TypeDef itemType = this.nextItemType(type, i);
                    Object o = this.decode(itemType);
                    ary.add(o);
                }
                return ary;
            }
            case 14: {
                int max = this.nextCount(type);
                HashMap<Object, Object> map = new HashMap<Object, Object>();
                for (int i = 0; i < max; ++i) {
                    TypeDef ktype = this.nextItemKeyType(type, i);
                    Object k = this.decode(ktype);
                    TypeDef itype = this.nextItemType(type, i);
                    Object v = this.decode(itype);
                    map.put(k, v);
                }
                return map;
            }
            case 15: {
                int max = this.nextCount(type);
                Struct struct = new Struct(max);
                for (int i = 0; i < max; ++i) {
                    String fname = this.nextItemName(type, i);
                    TypeDef ftype = this.nextItemType(type, i);
                    Object o = this.decode(ftype);
                    struct.append(fname, o);
                }
                return struct;
            }
            case 22: {
                int max = this.readNonNegativeInt();
                TypeDef utype = type.variants.get(max - 1);
                switch (utype.tag) {
                    case 15: {
                        if (utype.fields != null) {
                            this.currentCount = utype.fields.size();
                            break;
                        }
                        this.currentCount = this.readNonNegativeInt();
                        break;
                    }
                    default: {
                        throw new RuntimeException("HERE: not handled in union setup: " + utype);
                    }
                }
                return this.decode(utype);
            }
            case 23: {
                this.panic("fix enum here");
            }
            case 16: {
                return this.decode(this.nextType());
            }
            case 0: {
                return null;
            }
        }
        throw new TBinException("Unsupported type in TBin stream: " + type);
    }

    int readNonNegativeInt() throws IOException {
        int n = 0;
        int shift = 0;
        do {
            int b;
            if ((b = this.in.read()) >= 0) {
                n |= (b & 0x7F) << shift;
                if ((b & 0x80) != 0) continue;
                return n;
            }
            throw new TBinException("unexpected end of stream");
        } while ((shift += 7) < 32);
        throw new TBinException("Invalid int encoding");
    }

    int readInt() throws IOException {
        int n = this.readNonNegativeInt();
        return n >>> 1 ^ -(n & 1);
    }

    long readLong() throws IOException {
        long n = 0L;
        int shift = 0;
        do {
            int b;
            if ((b = this.in.read()) >= 0) {
                n |= ((long)b & 0x7FL) << shift;
                if ((b & 0x80) != 0) continue;
                return n >>> 1 ^ -(n & 1L);
            }
            throw new TBinException("Cannot read long, unexpected end of data");
        } while ((shift += 7) < 64);
        throw new IOException("Invalid long encoding");
    }

    double readDouble() throws IOException {
        long bits = this.readLong();
        return Double.longBitsToDouble(bits);
    }

    byte[] readBytes(byte[] b) throws IOException {
        return this.readBytes(b, b.length);
    }

    byte[] readBytes(byte[] b, int count) throws IOException {
        int remaining = count;
        int offset = 0;
        while (remaining > 0) {
            int i = this.in.read(b, offset, remaining);
            if (i < 0) {
                throw new TBinException("unexpected end of data");
            }
            remaining -= i;
            offset += i;
        }
        return b;
    }

    String utf8String(byte[] b, int len) throws IOException {
        return new String(b, 0, len, "UTF-8");
    }

    String readString() throws IOException {
        int n = this.readNonNegativeInt();
        return this.readString(n);
    }

    String readString(int n) throws IOException {
        byte[] b = n < this.buf.length ? this.buf : new byte[n];
        return this.utf8String(this.readBytes(b, n), n);
    }

    Symbol readSymbol() throws IOException {
        int id = this.readNonNegativeInt();
        if (id == this.syms.size()) {
            String name = this.readString();
            this.syms.add(name);
            return Symbol.intern(name);
        }
        return Symbol.intern(this.syms.get(id));
    }

    private void decodeInit(TypeDef type) throws IOException {
        switch (type.tag) {
            case 8: 
            case 9: 
            case 13: 
            case 14: {
                this.currentCount = this.readNonNegativeInt();
                break;
            }
            case 15: {
                if (type.fields != null) {
                    this.currentCount = type.fields.size();
                    break;
                }
                this.currentCount = this.readNonNegativeInt();
                break;
            }
            case 12: {
                this.currentCount = 16;
            }
        }
    }

    public TypeDef nextType() throws IOException {
        int idx;
        int tag = -1;
        TypeDef type = null;
        while (true) {
            if (tag < 0) {
                tag = this.readNonNegativeInt();
                if (this.dataVersion != 0) continue;
                if ((tag & 0xF8) == 24) {
                    this.dataVersion = (tag & 7) + 1;
                    if (this.dataVersion > 1) {
                        throw new TBinException("TBin version not yet supported: " + this.dataVersion);
                    }
                    tag = -1;
                    continue;
                }
                throw new TBinException("unexpected tag in stream, cannot determine TBin version: " + tag);
            }
            if ((tag & 0xE0) == 32) {
                this.currentCount = tag & 0x1F;
                return TypeDef.STRING;
            }
            switch (tag) {
                case 0: {
                    return TypeDef.NULL;
                }
                case 8: {
                    this.currentCount = this.readNonNegativeInt();
                    return TypeDef.BYTES;
                }
                case 9: {
                    this.currentCount = this.readNonNegativeInt();
                    return TypeDef.STRING;
                }
                case 13: {
                    this.currentCount = this.readNonNegativeInt();
                    if (type == null) {
                        return TypeDef.ARRAY;
                    }
                    return type;
                }
                case 14: {
                    this.currentCount = this.readNonNegativeInt();
                    if (type == null) {
                        return TypeDef.MAP;
                    }
                    return type;
                }
                case 15: {
                    this.currentCount = this.readNonNegativeInt();
                    if (type == null) {
                        return TypeDef.STRUCT;
                    }
                    return type;
                }
                case 12: {
                    this.currentCount = 16;
                    return TypeDef.UUID;
                }
                case 1: {
                    return TypeDef.BOOL;
                }
                case 2: {
                    return TypeDef.INT8;
                }
                case 3: {
                    return TypeDef.INT16;
                }
                case 4: {
                    return TypeDef.INT32;
                }
                case 5: {
                    return TypeDef.INT64;
                }
                case 6: {
                    return TypeDef.FLOAT32;
                }
                case 7: {
                    return TypeDef.FLOAT64;
                }
                case 10: {
                    return TypeDef.TIMESTAMP;
                }
                case 11: {
                    return TypeDef.SYMBOL;
                }
            }
            idx = tag - 64;
            if (idx < this.types.size()) break;
            this.decodeTypeDef(tag);
            tag = -1;
        }
        type = this.types.get(idx);
        if (type.tag == 15) {
            this.currentCount = type.fields != null ? type.fields.size() : this.readNonNegativeInt();
            return type;
        }
        if (type.tag == 13 || type.tag == 14) {
            this.currentCount = this.readNonNegativeInt();
            return type;
        }
        throw new RuntimeException("NYI: user-defined types derived from tag " + TBinDecoder.hexByte(tag));
    }

    public int nextCount(TypeDef type) {
        return this.currentCount;
    }

    public String nextItemName(TypeDef type, int idx) throws IOException {
        switch (type.tag) {
            case 15: {
                if (type.fields != null) {
                    return type.fields.get((int)idx).name;
                }
                return this.nextSymbol().name;
            }
        }
        this.panic("NOPE");
        return null;
    }

    public TypeDef nextItemKeyType(TypeDef type, int idx) throws IOException {
        switch (type.tag) {
            case 14: {
                if (type.keys != null) {
                    return type.keys;
                }
                this.panic("no key type for a map?");
                return null;
            }
            case 15: {
                return TypeDef.SYMBOL;
            }
        }
        this.panic("NOPE");
        return null;
    }

    public TypeDef nextItemType(TypeDef type, int idx) throws IOException {
        TypeDef itype = null;
        switch (type.tag) {
            case 13: 
            case 14: {
                if (type.items != null && type.items != TypeDef.ANY) {
                    itype = type.items;
                    break;
                }
                return this.nextType();
            }
            case 15: {
                if (type.fields != null) {
                    itype = type.fields.get((int)idx).type;
                    break;
                }
                return this.nextType();
            }
            default: {
                throw new TBinException("nextItemType called but type is not Array, Map, or Struct");
            }
        }
        switch (itype.tag) {
            case 8: 
            case 9: 
            case 13: 
            case 14: {
                this.currentCount = this.readNonNegativeInt();
                break;
            }
            case 12: {
                this.currentCount = 16;
                break;
            }
            case 15: {
                this.currentCount = itype.fields != null ? itype.fields.size() : this.readNonNegativeInt();
            }
        }
        return itype;
    }

    void decodeTypeDef(int tag) throws IOException {
        int baseTag = this.readNonNegativeInt();
        switch (baseTag) {
            case 19: {
                this.decodeStructTypeDef();
                break;
            }
            case 17: {
                this.decodeArrayTypeDef();
                break;
            }
            case 18: {
                this.decodeMapTypeDef();
                break;
            }
            case 21: {
                this.decodeEnumTypeDef();
                break;
            }
            case 20: {
                this.decodeUnionTypeDef();
                break;
            }
            default: {
                this.panic("decodeTypeDef, baseTag: " + baseTag);
                throw new TBinException("Only struct-based typedefs are permitted: " + baseTag);
            }
        }
    }

    void decodeStructTypeDef() throws IOException {
        int size = this.readNonNegativeInt();
        ArrayList<TypeDef.Field> fields = new ArrayList<TypeDef.Field>(size);
        for (int i = 0; i < size; ++i) {
            TypeDef ftype;
            String fname = this.readString();
            fields.add(new TypeDef.Field(fname, ftype, (ftype = this.decodeType()) == TypeDef.ANY));
        }
        TypeDef type = TypeDef.forStruct(fields);
        this.types.add(type);
    }

    void decodeArrayTypeDef() throws IOException {
        TypeDef items = this.decodeType();
        TypeDef type = TypeDef.forArray(items);
        this.types.add(type);
    }

    void decodeMapTypeDef() throws IOException {
        TypeDef keys = this.decodeType();
        TypeDef items = this.decodeType();
        TypeDef type = TypeDef.forMap(keys, items);
        this.types.add(type);
    }

    void decodeEnumTypeDef() throws IOException {
        int size = this.readNonNegativeInt();
        ArrayList<String> syms = new ArrayList<String>(size);
        syms.add("");
        for (int i = 0; i < size; ++i) {
            syms.add(this.readString());
        }
        TypeDef type = TypeDef.forEnum(syms);
        this.types.add(type);
    }

    void decodeUnionTypeDef() throws IOException {
        int size = this.readNonNegativeInt();
        ArrayList<TypeDef> variants = new ArrayList<TypeDef>(size);
        for (int i = 0; i < size; ++i) {
            variants.add(this.decodeType());
        }
        TypeDef type = TypeDef.forUnion(variants);
        this.types.add(type);
    }

    TypeDef decodeType() throws IOException {
        int tag = this.readNonNegativeInt();
        if (tag >= 64) {
            int idx = tag - 64;
            if (idx >= this.types.size()) {
                throw new TBinException("ref to a undefined tag: 0x" + TBinDecoder.hexByte(tag));
            }
            return this.types.get(idx);
        }
        TypeDef result = TypeDef.forTag(tag);
        if (result == null) {
            throw new TBinException("ref to a undefined type: 0x" + TBinDecoder.hexByte(tag));
        }
        return result;
    }

    public boolean nextBoolean() throws IOException {
        return this.readInt() != 0;
    }

    public byte nextByte() throws IOException {
        byte b = (byte)this.readInt();
        return b;
    }

    public short nextShort() throws IOException {
        short n = (short)this.readInt();
        return n;
    }

    public int nextInt() throws IOException {
        int n = this.readInt();
        return n;
    }

    public long nextLong() throws IOException {
        return this.readLong();
    }

    public float nextFloat() throws IOException {
        int bits = this.readInt();
        return Float.intBitsToFloat(bits);
    }

    public double nextDouble() throws IOException {
        return this.readDouble();
    }

    public byte[] nextByteArray() throws IOException {
        return this.readBytes(new byte[this.currentCount], this.currentCount);
    }

    public String nextString() throws IOException {
        return this.readString(this.currentCount);
    }

    public Timestamp nextTimestamp() throws IOException {
        double d = this.readDouble();
        return Timestamp.fromMillis((long)(d * 1000.0));
    }

    public Symbol nextSymbol() throws IOException {
        return this.readSymbol();
    }

    public UUID nextUUID() throws IOException {
        return UUID.fromBytes(this.readBytes(this.buf, this.currentCount));
    }
}

