/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tbin;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.yahoo.rdl.RdlOptional;
import com.yahoo.rdl.Struct;
import com.yahoo.rdl.Symbol;
import com.yahoo.rdl.Timestamp;
import com.yahoo.rdl.UUID;
import com.yahoo.tbin.TBin;
import com.yahoo.tbin.TBinException;
import com.yahoo.tbin.TypeDef;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TBinEncoder
extends TBin {
    OutputStream raw;
    private BufferedOutputStream out;
    private HashMap<String, Integer> syms;
    private HashMap<String, Integer> types;
    private int nextId = 0;
    private int nextTag = 64;
    private int dataVersion = 0;
    private byte[] buf;

    public TBinEncoder(OutputStream out) throws IOException {
        this.raw = out;
        this.syms = new HashMap(100);
        this.types = TBinEncoder.primitiveTypes();
        this.out = new BufferedOutputStream(this.raw);
        this.nextId = 0;
        this.nextTag = 64;
        this.buf = new byte[256];
        this.emitNonNegativeInt(24);
    }

    static HashMap<String, Integer> primitiveTypes() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("Null", 0);
        map.put("Bool", 1);
        map.put("Int8", 2);
        map.put("Int16", 3);
        map.put("Int32", 4);
        map.put("Int64", 5);
        map.put("Float32", 6);
        map.put("Float64", 7);
        map.put("Bytes", 8);
        map.put("String", 9);
        map.put("Timestamp", 10);
        map.put("Symbol", 11);
        map.put("UUID", 12);
        map.put("Array", 13);
        map.put("Map", 14);
        map.put("Struct", 15);
        map.put("Any", 16);
        return map;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void encode(Object o) throws IOException {
        if (o == null) {
            this.encodeNull();
        } else if (o instanceof String) {
            this.encodeString((String)o);
        } else if (o instanceof Boolean) {
            this.encodeBoolean((Boolean)o);
        } else if (o instanceof Number) {
            if (o instanceof Integer) {
                this.encodeInteger((Integer)o);
            } else if (o instanceof Double) {
                this.encodeDouble((Double)o);
            } else if (o instanceof Long) {
                this.encodeLong((Long)o);
            } else if (o instanceof Byte) {
                this.encodeByte((Byte)o);
            } else if (o instanceof Short) {
                this.encodeShort((Short)o);
            } else {
                if (!(o instanceof Float)) throw new TBinException("Unsupported Number subtype: " + o.getClass().getName());
                this.encodeFloat(((Float)o).floatValue());
            }
        } else if (o instanceof Struct) {
            Struct s = (Struct)o;
            this.encodeStruct(s.size());
            for (Struct.Field f : s) {
                this.emitSymbol(f.name());
                this.encode(f.value());
            }
        } else if (o instanceof Map) {
            Map m = (Map)o;
            this.encodeMap(m.size());
            for (Object k : m.keySet()) {
                this.encode(k);
                this.encode(m.get(k));
            }
        } else if (o instanceof List) {
            List l = (List)o;
            this.encodeArray(l.size());
            for (Object v : l) {
                this.encode(v);
            }
        } else if (o instanceof Timestamp) {
            this.encodeTimestamp((Timestamp)o);
        } else if (o instanceof Symbol) {
            this.encodeSymbol(((Symbol)o).name);
        } else if (o instanceof UUID) {
            this.encodeUUID((UUID)o);
        } else {
            this.encodeObject(o);
        }
        this.out.flush();
    }

    void encodeObject(Object o) throws IOException {
        TypeDef type = TypeDef.NULL;
        if (o != null) {
            type = TypeDef.forClass(o.getClass());
        }
        int tag = this.encodeTypeDef(type);
        this.emitNonNegativeInt(tag);
        this.encodeTypedValue(o);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void encodeTypedValue(Object o) throws IOException {
        if (o == null) {
            throw new TBinException("Cannot encode a missing typed value");
        }
        if (o instanceof String) {
            this.emitString((String)o);
        } else if (o instanceof Boolean) {
            this.emitBoolean((Boolean)o);
        } else if (o instanceof Number) {
            if (o instanceof Integer) {
                this.emitInt((Integer)o);
            } else if (o instanceof Double) {
                this.emitDouble((Double)o);
            } else if (o instanceof Long) {
                this.emitLong((Long)o);
            } else if (o instanceof Byte) {
                this.emitInt(((Byte)o).byteValue());
            } else if (o instanceof Short) {
                this.emitInt(((Short)o).shortValue());
            } else {
                if (!(o instanceof Float)) throw new TBinException("Unsupported Number subtype: " + o.getClass().getName());
                this.emitFloat(((Float)o).floatValue());
            }
        } else if (o instanceof Struct) {
            Struct s = (Struct)o;
            this.encodeStruct(s.size());
            for (Struct.Field f : s) {
                this.emitSymbol(f.name());
                this.encode(f.value());
            }
        } else if (o instanceof Map) {
            Map m = (Map)o;
            this.encodeMap(m.size());
            for (Object k : m.keySet()) {
                this.encode(k);
                this.encode(m.get(k));
            }
        } else if (o instanceof List) {
            List l = (List)o;
            this.encodeArray(l.size());
            for (Object v : l) {
                this.encode(v);
            }
        } else if (o instanceof Timestamp) {
            this.emitTimestamp((Timestamp)o);
        } else if (o instanceof Symbol) {
            this.encodeSymbol(((Symbol)o).name);
        } else if (o instanceof UUID) {
            this.encodeUUID((UUID)o);
        } else {
            Class<?> cl = o.getClass();
            try {
                int uvariant = 0;
                Field[] flds = cl.getFields();
                for (int fldnum = 0; fldnum < flds.length; ++fldnum) {
                    int modifiers;
                    Field f = flds[fldnum];
                    boolean optional = false;
                    for (Annotation anno : f.getDeclaredAnnotations()) {
                        if (anno instanceof RdlOptional) {
                            optional = true;
                        }
                        if (!"variant".equals(f.getName()) || !(anno instanceof JsonIgnore) || (uvariant = ((Enum)f.get(o)).ordinal() + 1) <= 0) continue;
                        this.emitNonNegativeInt(uvariant);
                    }
                    if (uvariant != 0 && fldnum != uvariant || ((modifiers = f.getModifiers()) & 1) == 0 || (modifiers & 8) != 0 || (modifiers & 0x80) != 0) continue;
                    TypeDef ftype = TypeDef.ANY;
                    Class<?> fclass = f.getType();
                    if (List.class.isAssignableFrom(fclass)) {
                        Class iclass = (Class)((ParameterizedType)f.getGenericType()).getActualTypeArguments()[0];
                        List lst = (List)f.get(o);
                        if (optional) {
                            if (lst == null) {
                                this.encodeNull();
                                continue;
                            }
                            TypeDef items = TypeDef.forClass(iclass);
                            String sig = TypeDef.forArray((TypeDef)items).signature;
                            this.emitNonNegativeInt(this.types.get(sig));
                        }
                        this.emitNonNegativeInt(lst.size());
                        int n = 0;
                        for (Object item : lst) {
                            ++n;
                            this.encodeTypedValue(item);
                        }
                        continue;
                    }
                    if (Map.class.isAssignableFrom(fclass)) {
                        Class kclass = (Class)((ParameterizedType)f.getGenericType()).getActualTypeArguments()[0];
                        Class iclass = (Class)((ParameterizedType)f.getGenericType()).getActualTypeArguments()[1];
                        Map map = (Map)f.get(o);
                        if (optional) {
                            if (map == null) {
                                this.encodeNull();
                                continue;
                            }
                            TypeDef keys = TypeDef.forClass(kclass);
                            TypeDef items = TypeDef.forClass(iclass);
                            String sig = TypeDef.forMap((TypeDef)keys, (TypeDef)items).signature;
                            this.emitNonNegativeInt(this.types.get(sig));
                        }
                        this.emitNonNegativeInt(map.size());
                        for (Object key : map.keySet()) {
                            this.encodeTypedValue(key);
                            this.encodeTypedValue(map.get(key));
                        }
                        continue;
                    }
                    Object v = f.get(o);
                    if (optional && uvariant == 0) {
                        this.encode(v);
                        continue;
                    }
                    this.encodeTypedValue(v);
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new TBinException("Cannot encode object of class " + cl.getName());
            }
        }
        this.out.flush();
    }

    void emitTypeDef(TypeDef td, int tag) throws IOException {
        this.emitNonNegativeInt(tag);
        switch (td.tag) {
            case 15: {
                this.emitNonNegativeInt(19);
                this.emitNonNegativeInt(td.fields.size());
                for (TypeDef.Field f : td.fields) {
                    this.emitString(f.name);
                    if (f.optional) {
                        this.emitNonNegativeInt(16);
                        continue;
                    }
                    this.emitNonNegativeInt(this.types.get(f.type.signature));
                }
                break;
            }
            case 13: {
                this.emitNonNegativeInt(17);
                this.emitNonNegativeInt(this.types.get(td.items.signature));
                break;
            }
            case 14: {
                this.emitNonNegativeInt(18);
                this.emitNonNegativeInt(this.types.get(td.keys.signature));
                this.emitNonNegativeInt(this.types.get(td.items.signature));
                break;
            }
            case 22: {
                this.emitNonNegativeInt(20);
                this.emitNonNegativeInt(td.variants.size());
                for (TypeDef vtd : td.variants) {
                    this.emitNonNegativeInt(this.types.get(vtd.signature));
                }
                break;
            }
            case 23: {
                this.emitNonNegativeInt(21);
                this.emitNonNegativeInt(td.symbols.size());
                for (String sym : td.symbols) {
                    this.emitString(sym);
                }
                break;
            }
        }
    }

    int encodeTypeDef(TypeDef td) throws IOException {
        int tag = td.tag;
        String sig = td.signature;
        if (this.types.containsKey(sig)) {
            tag = this.types.get(sig);
        } else {
            switch (td.tag) {
                case 15: {
                    if (td.fields == null) break;
                    for (TypeDef.Field field : td.fields) {
                        this.encodeTypeDef(field.type);
                    }
                    tag = this.nextTag++;
                    this.types.put(sig, tag);
                    this.emitTypeDef(td, tag);
                    break;
                }
                case 13: {
                    if (td.items == TypeDef.ANY) break;
                    this.encodeTypeDef(td.items);
                    tag = this.nextTag++;
                    this.types.put(sig, tag);
                    this.emitTypeDef(td, tag);
                    break;
                }
                case 22: {
                    for (TypeDef vtd : td.variants) {
                        this.encodeTypeDef(vtd);
                    }
                    tag = this.nextTag++;
                    this.types.put(sig, tag);
                    this.emitTypeDef(td, tag);
                    break;
                }
                case 14: {
                    if (td.keys == TypeDef.ANY && td.items == TypeDef.ANY) break;
                    this.encodeTypeDef(td.keys);
                    this.encodeTypeDef(td.items);
                    tag = this.nextTag++;
                    this.types.put(sig, tag);
                    this.emitTypeDef(td, tag);
                    break;
                }
                case 23: {
                    tag = this.nextTag++;
                    this.types.put(sig, tag);
                    this.emitTypeDef(td, tag);
                    break;
                }
                default: {
                    throw new TBinException("Cannot create typedef for this kind of object: " + td);
                }
            }
        }
        return tag;
    }

    public void encodeNull() throws IOException {
        this.emitNonNegativeInt(0);
    }

    public void encodeBoolean(boolean b) throws IOException {
        this.emitNonNegativeInt(1);
        this.emitBoolean(b);
    }

    public void encodeByte(byte n) throws IOException {
        this.emitNonNegativeInt(2);
        this.emitInt(n);
    }

    public void encodeShort(short n) throws IOException {
        this.emitNonNegativeInt(3);
        this.emitInt(n);
    }

    public void encodeInteger(int n) throws IOException {
        this.emitNonNegativeInt(4);
        this.emitInt(n);
    }

    public void encodeLong(long n) throws IOException {
        this.emitNonNegativeInt(5);
        this.emitLong(n);
    }

    public void encodeFloat(float n) throws IOException {
        this.emitNonNegativeInt(6);
        this.emitFloat(n);
    }

    public void encodeDouble(double n) throws IOException {
        this.emitNonNegativeInt(7);
        this.emitDouble(n);
    }

    public void encodeBytes(byte[] b) throws IOException {
        this.emitNonNegativeInt(8);
        this.emitBytes(b);
    }

    public void encodeString(String s) throws IOException {
        byte[] utf8 = this.utf8Bytes(s);
        int utflen = utf8.length;
        if (utflen <= 31) {
            this.emitNonNegativeInt(32 + utflen);
        } else {
            this.emitNonNegativeInt(9);
            this.emitNonNegativeInt(utflen);
        }
        this.out.write(utf8, 0, utflen);
    }

    public void encodeTimestamp(Timestamp ts) throws IOException {
        this.emitNonNegativeInt(10);
        this.emitTimestamp(ts);
    }

    void emitTimestamp(Timestamp ts) throws IOException {
        double secondsSinceEpoch = (double)ts.millis() / 1000.0;
        this.emitDouble(secondsSinceEpoch);
    }

    public void encodeSymbol(String s) throws IOException {
        this.emitNonNegativeInt(11);
        this.emitSymbol(s);
    }

    public void encodeUUID(UUID uuid) throws IOException {
        this.emitNonNegativeInt(12);
        this.emitUUID(uuid);
    }

    void emitUUID(UUID uuid) throws IOException {
        this.emitBytes(uuid.toBytes());
    }

    public void encodeArray(int count) throws IOException {
        this.emitNonNegativeInt(13);
        this.emitNonNegativeInt(count);
    }

    public void encodeMap(int count) throws IOException {
        this.emitNonNegativeInt(14);
        this.emitNonNegativeInt(count);
    }

    public void encodeStruct(int count) throws IOException {
        this.emitNonNegativeInt(15);
        this.emitNonNegativeInt(count);
    }

    public void encodeField(String name) throws IOException {
        this.emitSymbol(name);
    }

    private void emitBoolean(boolean b) throws IOException {
        this.emitNonNegativeInt(b ? 1 : 0);
    }

    private void emitInt(int n) throws IOException {
        this.emitNonNegativeInt(n << 1 ^ n >> 31);
    }

    private void emitNonNegativeInt(int n) throws IOException {
        int nn = n;
        int len = 0;
        if ((n & 0xFFFFFF80) != 0) {
            this.buf[len++] = (byte)((n | 0x80) & 0xFF);
            if ((n >>>= 7) > 127) {
                this.buf[len++] = (byte)((n | 0x80) & 0xFF);
                if ((n >>>= 7) > 127) {
                    this.buf[len++] = (byte)((n | 0x80) & 0xFF);
                    if ((n >>>= 7) > 127) {
                        this.buf[len++] = (byte)((n | 0x80) & 0xFF);
                        n >>>= 7;
                    }
                }
            }
        }
        this.buf[len++] = (byte)n;
        this.out.write(this.buf, 0, len);
    }

    private void emitLong(long n) throws IOException {
        n = n << 1 ^ n >> 63;
        int len = 0;
        if ((n & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.buf[len++] = (byte)((n | 0x80L) & 0xFFL);
            if ((n >>>= 7) > 127L) {
                this.buf[len++] = (byte)((n | 0x80L) & 0xFFL);
                if ((n >>>= 7) > 127L) {
                    this.buf[len++] = (byte)((n | 0x80L) & 0xFFL);
                    if ((n >>>= 7) > 127L) {
                        this.buf[len++] = (byte)((n | 0x80L) & 0xFFL);
                        if ((n >>>= 7) > 127L) {
                            this.buf[len++] = (byte)((n | 0x80L) & 0xFFL);
                            if ((n >>>= 7) > 127L) {
                                this.buf[len++] = (byte)((n | 0x80L) & 0xFFL);
                                if ((n >>>= 7) > 127L) {
                                    this.buf[len++] = (byte)((n | 0x80L) & 0xFFL);
                                    if ((n >>>= 7) > 127L) {
                                        this.buf[len++] = (byte)((n | 0x80L) & 0xFFL);
                                        if ((n >>>= 7) > 127L) {
                                            this.buf[len++] = (byte)((n | 0x80L) & 0xFFL);
                                            n >>>= 7;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        this.buf[len++] = (byte)n;
        this.out.write(this.buf, 0, len);
    }

    private void emitFloat(float n) throws IOException {
        int bits = Float.floatToIntBits(n);
        this.buf[0] = (byte)(bits >> 24);
        this.buf[1] = (byte)(bits >> 16);
        this.buf[2] = (byte)(bits >> 8);
        this.buf[3] = (byte)bits;
        this.out.write(this.buf, 0, 4);
    }

    private void emitDouble(double n) throws IOException {
        long bits = Double.doubleToLongBits(n);
        this.buf[0] = (byte)(bits >> 56);
        this.buf[1] = (byte)(bits >> 48);
        this.buf[2] = (byte)(bits >> 40);
        this.buf[3] = (byte)(bits >> 32);
        this.buf[4] = (byte)(bits >> 24);
        this.buf[5] = (byte)(bits >> 16);
        this.buf[6] = (byte)(bits >> 8);
        this.buf[7] = (byte)bits;
        this.out.write(this.buf, 0, 8);
    }

    private byte[] utf8Bytes(String s) throws IOException {
        return s.getBytes("UTF-8");
    }

    private void emitString(String s) throws IOException {
        byte[] utf8 = this.utf8Bytes(s);
        int utflen = utf8.length;
        this.emitNonNegativeInt(utflen);
        this.out.write(utf8, 0, utflen);
    }

    private void emitBytes(byte[] b) throws IOException {
        this.emitBytes(b, b.length);
    }

    private void emitBytes(byte[] b, int n) throws IOException {
        if (n > 0) {
            this.out.write(b, 0, n);
        }
    }

    private void emitSymbol(String name) throws IOException {
        Integer id = this.syms.get(name);
        if (id == null) {
            id = this.nextId++;
            this.syms.put(name, id);
            this.emitNonNegativeInt(id);
            this.emitString(name);
        } else {
            this.emitNonNegativeInt(id);
        }
    }
}

