/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tbin;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.yahoo.rdl.RdlOptional;
import com.yahoo.tbin.TBin;
import com.yahoo.tbin.TBinException;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TypeDef {
    public int tag;
    public List<Field> fields;
    public TypeDef items;
    public TypeDef keys;
    public List<TypeDef> variants;
    public List<String> symbols;
    String signature;
    static TypeDef ANY = TypeDef.forBaseType(16);
    static TypeDef NULL = TypeDef.forBaseType(0);
    static TypeDef BOOL = TypeDef.forBaseType(1);
    static TypeDef INT8 = TypeDef.forBaseType(2);
    static TypeDef INT16 = TypeDef.forBaseType(3);
    static TypeDef INT32 = TypeDef.forBaseType(4);
    static TypeDef INT64 = TypeDef.forBaseType(5);
    static TypeDef FLOAT32 = TypeDef.forBaseType(6);
    static TypeDef FLOAT64 = TypeDef.forBaseType(7);
    static TypeDef BYTES = TypeDef.forBaseType(8);
    static TypeDef STRING = TypeDef.forBaseType(9);
    static TypeDef TIMESTAMP = TypeDef.forBaseType(10);
    static TypeDef SYMBOL = TypeDef.forBaseType(11);
    static TypeDef UUID = TypeDef.forBaseType(12);
    static TypeDef ARRAY = TypeDef.forBaseType(13);
    static TypeDef MAP = TypeDef.forBaseType(14);
    static TypeDef STRUCT = TypeDef.forBaseType(15);
    private static Map<String, TypeDef> cache = TypeDef.initCache();
    static final String KEYWORD_PREFIX = "_";

    public String toString() {
        return this.signature;
    }

    private TypeDef() {
    }

    static TypeDef forBaseType(int tag) {
        TypeDef td = new TypeDef();
        td.tag = tag;
        return td.initSignature();
    }

    static TypeDef forStruct(List<Field> fields) {
        TypeDef td = new TypeDef();
        td.tag = 15;
        td.fields = fields;
        return td.initSignature();
    }

    static TypeDef forArray(TypeDef items) {
        TypeDef td = new TypeDef();
        td.tag = 13;
        td.items = items;
        return td.initSignature();
    }

    static TypeDef forMap(TypeDef keys, TypeDef items) {
        TypeDef td = new TypeDef();
        td.tag = 14;
        td.keys = keys;
        td.items = items;
        return td.initSignature();
    }

    static TypeDef forEnum(List<String> syms) {
        TypeDef td = new TypeDef();
        td.tag = 23;
        td.symbols = syms;
        return td.initSignature();
    }

    static TypeDef forUnion(List<TypeDef> variants) {
        TypeDef td = new TypeDef();
        td.tag = 22;
        td.variants = variants;
        return td.initSignature();
    }

    String tagName(int tag) {
        if ((tag & 0xE0) == 32) {
            return "String";
        }
        switch (tag) {
            case 0: {
                return "Null";
            }
            case 1: {
                return "Bool";
            }
            case 2: {
                return "Int8";
            }
            case 3: {
                return "Int16";
            }
            case 4: {
                return "Int32";
            }
            case 5: {
                return "Int64";
            }
            case 6: {
                return "Float32";
            }
            case 7: {
                return "Float64";
            }
            case 8: {
                return "Bytes";
            }
            case 9: {
                return "String";
            }
            case 10: {
                return "Timestamp";
            }
            case 11: {
                return "Symbol";
            }
            case 12: {
                return "UUID";
            }
            case 13: {
                return "Array";
            }
            case 14: {
                return "Map";
            }
            case 15: {
                return "Struct";
            }
            case 16: {
                return "Any";
            }
            case 23: {
                return "Enum";
            }
        }
        return "0x" + TBin.hexByte(tag);
    }

    static TypeDef forTag(int tag) {
        switch (tag) {
            case 0: {
                return NULL;
            }
            case 1: {
                return BOOL;
            }
            case 2: {
                return INT8;
            }
            case 3: {
                return INT16;
            }
            case 4: {
                return INT32;
            }
            case 5: {
                return INT64;
            }
            case 6: {
                return FLOAT32;
            }
            case 7: {
                return FLOAT64;
            }
            case 8: {
                return BYTES;
            }
            case 9: {
                return STRING;
            }
            case 10: {
                return TIMESTAMP;
            }
            case 11: {
                return SYMBOL;
            }
            case 12: {
                return UUID;
            }
            case 16: {
                return ANY;
            }
        }
        return null;
    }

    private TypeDef initSignature() {
        switch (this.tag) {
            case 15: {
                if (this.fields == null) {
                    this.signature = this.tagName(this.tag);
                    return this;
                }
                String s = this.tagName(this.tag) + "{";
                int i = 0;
                for (Field f : this.fields) {
                    if (i++ > 0) {
                        s = s + ",";
                    }
                    s = s + f.name;
                    s = s + ":";
                    s = s + f.type.toString();
                }
                this.signature = s + "}";
                return this;
            }
            case 13: {
                if (this.items == null) {
                    this.items = ANY;
                }
                this.signature = this.tagName(this.tag) + "<" + this.items.toString() + ">";
                return this;
            }
            case 14: {
                if (this.keys == null) {
                    this.keys = ANY;
                }
                if (this.items == null) {
                    this.items = ANY;
                }
                this.signature = this.tagName(this.tag) + "<" + this.keys.toString() + "," + this.items.toString() + ">";
                return this;
            }
            case 16: {
                this.signature = "Any";
                return this;
            }
            case 22: {
                String s = "Union<";
                int i = 0;
                for (TypeDef t : this.variants) {
                    if (i++ > 0) {
                        s = s + ",";
                    }
                    s = s + t.toString();
                }
                this.signature = s + ">";
                return this;
            }
            case 23: {
                String s = "Enum<";
                int i = 0;
                for (String t : this.symbols) {
                    if (i > 0) {
                        if (i > 1) {
                            s = s + ",";
                        }
                        s = s + t;
                    }
                    ++i;
                }
                this.signature = s + ">";
                return this;
            }
        }
        this.signature = this.tagName(this.tag);
        return this;
    }

    private static Map<String, TypeDef> initCache() {
        HashMap<String, TypeDef> map = new HashMap<String, TypeDef>();
        map.put("java.lang.Boolean", BOOL);
        map.put("boolean", BOOL);
        map.put("java.lang.Byte", INT8);
        map.put("java.lang.Short", INT16);
        map.put("java.lang.Integer", INT32);
        map.put("int", INT32);
        map.put("java.lang.Long", INT64);
        map.put("java.lang.Float", FLOAT32);
        map.put("java.lang.Double", FLOAT64);
        map.put("[byte", BYTES);
        map.put("java.lang.String", STRING);
        map.put("com.yahoo.rdl.Timestamp", TIMESTAMP);
        map.put("com.yahoo.rdl.Symbol", SYMBOL);
        map.put("com.yahoo.rdl.UUID", UUID);
        map.put("java.lang.Object", ANY);
        return map;
    }

    static <T> List<String> enumSymbols(Class<T> e) {
        ArrayList<String> lst = new ArrayList<String>();
        for (T item : e.getEnumConstants()) {
            lst.add(String.valueOf(item));
        }
        return lst;
    }

    public static TypeDef forClass(Class<?> cl) throws TBinException {
        String clName = cl.getName();
        TypeDef td = cache.get(clName);
        if (td == null) {
            if (List.class.isAssignableFrom(cl)) {
                return ARRAY;
            }
            if (cl.isEnum()) {
                List<String> syms = TypeDef.enumSymbols(cl);
                return TypeDef.forEnum(syms);
            }
            ArrayList<Field> fields = new ArrayList<Field>();
            ArrayList<TypeDef> variants = null;
            java.lang.reflect.Field[] flds = cl.getFields();
            for (int fldnum = 0; fldnum < flds.length; ++fldnum) {
                int modifiers;
                java.lang.reflect.Field f = flds[fldnum];
                boolean optional = false;
                for (Annotation anno : f.getDeclaredAnnotations()) {
                    if (anno instanceof RdlOptional) {
                        optional = true;
                        continue;
                    }
                    if (!"variant".equals(f.getName()) || !(anno instanceof JsonIgnore)) continue;
                    variants = new ArrayList<TypeDef>();
                }
                if (variants != null && fldnum == 0 || ((modifiers = f.getModifiers()) & 1) == 0 || (modifiers & 8) != 0 || (modifiers & 0x80) != 0) continue;
                String fname = f.getName();
                if (fname.startsWith(KEYWORD_PREFIX)) {
                    fname = fname.substring(1);
                }
                TypeDef ftype = ANY;
                Class<?> fclass = f.getType();
                if (fclass != Object.class) {
                    if (List.class.isAssignableFrom(fclass)) {
                        Class iclass = (Class)((ParameterizedType)f.getGenericType()).getActualTypeArguments()[0];
                        TypeDef fitems = TypeDef.forClass(iclass);
                        if (fitems == null) {
                            fitems = ANY;
                        }
                        ftype = TypeDef.forArray(fitems);
                    } else if (Map.class.isAssignableFrom(fclass)) {
                        TypeDef fitems;
                        Class kclass = (Class)((ParameterizedType)f.getGenericType()).getActualTypeArguments()[0];
                        Class iclass = (Class)((ParameterizedType)f.getGenericType()).getActualTypeArguments()[1];
                        TypeDef fkeys = TypeDef.forClass(kclass);
                        if (fkeys == null) {
                            fkeys = ANY;
                        }
                        if ((fitems = TypeDef.forClass(iclass)) == null) {
                            fitems = ANY;
                        }
                        ftype = TypeDef.forMap(fkeys, fitems);
                    } else {
                        ftype = TypeDef.forClass(fclass);
                        if (ftype == null) {
                            throw new TBinException("Cannot map class to TBin: " + fclass.getName());
                        }
                    }
                }
                if (variants != null) {
                    variants.add(ftype);
                    continue;
                }
                fields.add(new Field(fname, ftype, optional));
            }
            if (variants != null) {
                td = TypeDef.forUnion(variants);
            } else {
                if (fields.size() == 0) {
                    throw new RuntimeException("Empty struct: " + cl.getName());
                }
                td = TypeDef.forStruct(fields);
            }
        }
        return td;
    }

    static class Field {
        String name;
        TypeDef type;
        boolean optional;

        Field(String name, TypeDef type, boolean opt) {
            this.name = name;
            this.type = type;
            this.optional = opt;
        }

        public String toString() {
            return "<Field " + this.name + " " + this.type + " " + this.optional + ">";
        }
    }
}

