/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.airlift.zstd;

import ai.vespa.airlift.compress.MalformedInputException;
import ai.vespa.airlift.zstd.CompressionParameters;
import ai.vespa.airlift.zstd.UnsafeUtil;

final class Util {
    private Util() {
    }

    public static int highestBit(int value) {
        return 31 - Integer.numberOfLeadingZeros(value);
    }

    public static boolean isPowerOf2(int value) {
        return (value & value - 1) == 0;
    }

    public static int mask(int bits) {
        return (1 << bits) - 1;
    }

    public static void verify(boolean condition, long offset, String reason) {
        if (!condition) {
            throw new MalformedInputException(offset, reason);
        }
    }

    public static void checkArgument(boolean condition, String reason) {
        if (!condition) {
            throw new IllegalArgumentException(reason);
        }
    }

    public static void checkState(boolean condition, String reason) {
        if (!condition) {
            throw new IllegalStateException(reason);
        }
    }

    public static MalformedInputException fail(long offset, String reason) {
        throw new MalformedInputException(offset, reason);
    }

    public static int cycleLog(int hashLog, CompressionParameters.Strategy strategy) {
        int cycleLog = hashLog;
        if (strategy == CompressionParameters.Strategy.BTLAZY2 || strategy == CompressionParameters.Strategy.BTOPT || strategy == CompressionParameters.Strategy.BTULTRA) {
            cycleLog = hashLog - 1;
        }
        return cycleLog;
    }

    public static void put24BitLittleEndian(Object outputBase, long outputAddress, int value) {
        UnsafeUtil.UNSAFE.putShort(outputBase, outputAddress, (short)value);
        UnsafeUtil.UNSAFE.putByte(outputBase, outputAddress + 2L, (byte)(value >>> 16));
    }

    public static int minTableLog(int inputSize, int maxSymbolValue) {
        if (inputSize <= 1) {
            throw new IllegalArgumentException("Not supported. RLE should be used instead");
        }
        int minBitsSrc = Util.highestBit(inputSize - 1) + 1;
        int minBitsSymbols = Util.highestBit(maxSymbolValue) + 2;
        return Math.min(minBitsSrc, minBitsSymbols);
    }
}

