/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.airlift.zstd;

import ai.vespa.airlift.zstd.UnsafeUtil;
import ai.vespa.airlift.zstd.Util;

class BitOutputStream {
    private static final long[] BIT_MASK = new long[]{0L, 1L, 3L, 7L, 15L, 31L, 63L, 127L, 255L, 511L, 1023L, 2047L, 4095L, 8191L, 16383L, 32767L, 65535L, 131071L, 262143L, 524287L, 1048575L, 0x1FFFFFL, 0x3FFFFFL, 0x7FFFFFL, 0xFFFFFFL, 0x1FFFFFFL, 0x3FFFFFFL, 0x7FFFFFFL, 0xFFFFFFFL, 0x1FFFFFFFL, 0x3FFFFFFFL, Integer.MAX_VALUE};
    private final Object outputBase;
    private final long outputAddress;
    private final long outputLimit;
    private long container;
    private int bitCount;
    private long currentAddress;

    public BitOutputStream(Object outputBase, long outputAddress, int outputSize) {
        Util.checkArgument(outputSize >= 8, "Output buffer too small");
        this.outputBase = outputBase;
        this.outputAddress = outputAddress;
        this.outputLimit = this.outputAddress + (long)outputSize - 8L;
        this.currentAddress = this.outputAddress;
    }

    public void addBits(int value, int bits) {
        this.container |= ((long)value & BIT_MASK[bits]) << this.bitCount;
        this.bitCount += bits;
    }

    public void addBitsFast(int value, int bits) {
        this.container |= (long)value << this.bitCount;
        this.bitCount += bits;
    }

    public void flush() {
        int bytes = this.bitCount >>> 3;
        UnsafeUtil.UNSAFE.putLong(this.outputBase, this.currentAddress, this.container);
        this.currentAddress += (long)bytes;
        if (this.currentAddress > this.outputLimit) {
            this.currentAddress = this.outputLimit;
        }
        this.bitCount &= 7;
        this.container >>>= bytes * 8;
    }

    public int close() {
        this.addBitsFast(1, 1);
        this.flush();
        if (this.currentAddress >= this.outputLimit) {
            return 0;
        }
        return (int)(this.currentAddress - this.outputAddress + (long)(this.bitCount > 0 ? 1 : 0));
    }
}

