/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.airlift.zstd;

import ai.vespa.airlift.zstd.BlockCompressionState;
import ai.vespa.airlift.zstd.CompressionParameters;
import ai.vespa.airlift.zstd.HuffmanCompressionContext;
import ai.vespa.airlift.zstd.RepeatedOffsets;
import ai.vespa.airlift.zstd.SequenceEncodingContext;
import ai.vespa.airlift.zstd.SequenceStore;

class CompressionContext {
    public final RepeatedOffsets offsets = new RepeatedOffsets();
    public final BlockCompressionState blockCompressionState;
    public final SequenceStore sequenceStore;
    public final SequenceEncodingContext sequenceEncodingContext = new SequenceEncodingContext();
    public final HuffmanCompressionContext huffmanContext = new HuffmanCompressionContext();

    public CompressionContext(CompressionParameters parameters, long baseAddress, int inputSize) {
        int windowSize = Math.max(1, Math.min(1 << parameters.getWindowLog(), inputSize));
        int blockSize = Math.min(131072, windowSize);
        int divider = parameters.getSearchLength() == 3 ? 3 : 4;
        int maxSequences = blockSize / divider;
        this.sequenceStore = new SequenceStore(blockSize, maxSequences);
        this.blockCompressionState = new BlockCompressionState(parameters, baseAddress);
    }

    public void commit() {
        this.offsets.commit();
        this.huffmanContext.saveChanges();
    }
}

