/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.airlift.zstd;

import ai.vespa.airlift.compress.MalformedInputException;
import ai.vespa.airlift.zstd.FrameHeader;
import ai.vespa.airlift.zstd.UnsafeUtil;
import ai.vespa.airlift.zstd.Util;
import ai.vespa.airlift.zstd.XxHash64;
import ai.vespa.airlift.zstd.ZstdBlockDecompressor;

class ZstdFrameDecompressor {
    private static final int V07_MAGIC_NUMBER = -47205081;

    ZstdFrameDecompressor() {
    }

    public int decompress(Object inputBase, long inputAddress, long inputLimit, Object outputBase, long outputAddress, long outputLimit) {
        if (outputAddress == outputLimit) {
            return 0;
        }
        long input = inputAddress;
        long output = outputAddress;
        while (input < inputLimit) {
            boolean lastBlock;
            long outputStart = output;
            input += (long)ZstdFrameDecompressor.verifyMagic(inputBase, input, inputLimit);
            FrameHeader frameHeader = ZstdFrameDecompressor.readFrameHeader(inputBase, input, inputLimit);
            input += frameHeader.headerSize;
            ZstdBlockDecompressor blockDecompressor = new ZstdBlockDecompressor(frameHeader);
            do {
                int decodedSize;
                Util.verify(input + 3L <= inputLimit, input, "Not enough input bytes");
                int header = UnsafeUtil.UNSAFE.getInt(inputBase, input) & 0xFFFFFF;
                input += 3L;
                lastBlock = (header & 1) != 0;
                int blockType = header >>> 1 & 3;
                int blockSize = header >>> 3 & 0x1FFFFF;
                switch (blockType) {
                    case 0: {
                        Util.verify(inputAddress + (long)blockSize <= inputLimit, input, "Not enough input bytes");
                        decodedSize = ZstdBlockDecompressor.decodeRawBlock(inputBase, input, blockSize, outputBase, output, outputLimit);
                        input += (long)blockSize;
                        break;
                    }
                    case 1: {
                        Util.verify(inputAddress + 1L <= inputLimit, input, "Not enough input bytes");
                        decodedSize = ZstdBlockDecompressor.decodeRleBlock(blockSize, inputBase, input, outputBase, output, outputLimit);
                        ++input;
                        break;
                    }
                    case 2: {
                        Util.verify(inputAddress + (long)blockSize <= inputLimit, input, "Not enough input bytes");
                        decodedSize = blockDecompressor.decodeCompressedBlock(inputBase, input, blockSize, outputBase, output, outputLimit, frameHeader.windowSize, outputAddress);
                        input += (long)blockSize;
                        break;
                    }
                    default: {
                        throw Util.fail(input, "Invalid block type");
                    }
                }
                output += (long)decodedSize;
            } while (!lastBlock);
            if (!frameHeader.hasChecksum) continue;
            int decodedFrameSize = (int)(output - outputStart);
            long hash = XxHash64.hash(0L, outputBase, outputStart, decodedFrameSize);
            int checksum = UnsafeUtil.UNSAFE.getInt(inputBase, input);
            if (checksum != (int)hash) {
                throw new MalformedInputException(input, String.format("Bad checksum. Expected: %s, actual: %s", Integer.toHexString(checksum), Integer.toHexString((int)hash)));
            }
            input += 4L;
        }
        return (int)(output - outputAddress);
    }

    static FrameHeader readFrameHeader(Object inputBase, long inputAddress, long inputLimit) {
        long input = inputAddress;
        Util.verify(input < inputLimit, input, "Not enough input bytes");
        int frameHeaderDescriptor = UnsafeUtil.UNSAFE.getByte(inputBase, input++) & 0xFF;
        boolean singleSegment = (frameHeaderDescriptor & 0x20) != 0;
        int dictionaryDescriptor = frameHeaderDescriptor & 3;
        int contentSizeDescriptor = frameHeaderDescriptor >>> 6;
        int headerSize = 1 + (singleSegment ? 0 : 1) + (dictionaryDescriptor == 0 ? 0 : 1 << dictionaryDescriptor - 1) + (contentSizeDescriptor == 0 ? (singleSegment ? 1 : 0) : 1 << contentSizeDescriptor);
        Util.verify((long)headerSize <= inputLimit - inputAddress, input, "Not enough input bytes");
        int windowSize = -1;
        if (!singleSegment) {
            int windowDescriptor = UnsafeUtil.UNSAFE.getByte(inputBase, input++) & 0xFF;
            int exponent = windowDescriptor >>> 3;
            int mantissa = windowDescriptor & 7;
            int base = 1 << 10 + exponent;
            windowSize = base + base / 8 * mantissa;
        }
        long dictionaryId = -1L;
        switch (dictionaryDescriptor) {
            case 1: {
                dictionaryId = UnsafeUtil.UNSAFE.getByte(inputBase, input) & 0xFF;
                ++input;
                break;
            }
            case 2: {
                dictionaryId = UnsafeUtil.UNSAFE.getShort(inputBase, input) & 0xFFFF;
                input += 2L;
                break;
            }
            case 3: {
                dictionaryId = (long)UnsafeUtil.UNSAFE.getInt(inputBase, input) & 0xFFFFFFFFL;
                input += 4L;
            }
        }
        Util.verify(dictionaryId == -1L, input, "Custom dictionaries not supported");
        long contentSize = -1L;
        switch (contentSizeDescriptor) {
            case 0: {
                if (!singleSegment) break;
                contentSize = UnsafeUtil.UNSAFE.getByte(inputBase, input) & 0xFF;
                ++input;
                break;
            }
            case 1: {
                contentSize = UnsafeUtil.UNSAFE.getShort(inputBase, input) & 0xFFFF;
                contentSize += 256L;
                input += 2L;
                break;
            }
            case 2: {
                contentSize = (long)UnsafeUtil.UNSAFE.getInt(inputBase, input) & 0xFFFFFFFFL;
                input += 4L;
                break;
            }
            case 3: {
                contentSize = UnsafeUtil.UNSAFE.getLong(inputBase, input);
                input += 8L;
            }
        }
        boolean hasChecksum = (frameHeaderDescriptor & 4) != 0;
        return new FrameHeader(input - inputAddress, windowSize, contentSize, dictionaryId, hasChecksum);
    }

    public static long getDecompressedSize(Object inputBase, long inputAddress, long inputLimit) {
        long input = inputAddress;
        input += (long)ZstdFrameDecompressor.verifyMagic(inputBase, input, inputLimit);
        return ZstdFrameDecompressor.readFrameHeader((Object)inputBase, (long)input, (long)inputLimit).contentSize;
    }

    static int verifyMagic(Object inputBase, long inputAddress, long inputLimit) {
        Util.verify(inputLimit - inputAddress >= 4L, inputAddress, "Not enough input bytes");
        int magic = UnsafeUtil.UNSAFE.getInt(inputBase, inputAddress);
        if (magic != -47205080) {
            if (magic == -47205081) {
                throw new MalformedInputException(inputAddress, "Data encoded in unsupported ZSTD v0.7 format");
            }
            throw new MalformedInputException(inputAddress, "Invalid magic prefix: " + Integer.toHexString(magic));
        }
        return 4;
    }
}

