/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.application;

import com.yahoo.config.application.FileSystemWrapper;
import com.yahoo.config.application.PreProcessor;
import com.yahoo.config.application.Xml;
import com.yahoo.text.XML;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.NoSuchElementException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class IncludeProcessor
implements PreProcessor {
    private final FileSystemWrapper.FileWrapper application;

    public IncludeProcessor(File application) {
        this(FileSystemWrapper.getDefault(application.toPath()).wrap(application.toPath()));
    }

    public IncludeProcessor(FileSystemWrapper.FileWrapper application) {
        this.application = application;
    }

    @Override
    public Document process(Document input) throws IOException, TransformerException {
        Document doc = Xml.copyDocument(input);
        IncludeProcessor.includeFile(this.application, doc.getDocumentElement());
        return doc;
    }

    private static void includeFile(FileSystemWrapper.FileWrapper currentFolder, Element currentElement) throws IOException {
        NodeList list = currentElement.getElementsByTagNameNS("properties", "include");
        while (list.getLength() > 0) {
            Element elem = (Element)list.item(0);
            Element parent = (Element)elem.getParentNode();
            String filename = elem.getAttribute("file");
            boolean required = !elem.hasAttribute("required") || Boolean.parseBoolean(elem.getAttribute("required"));
            FileSystemWrapper.FileWrapper file = currentFolder.child(filename);
            IncludeProcessor.ckeckForDeployAttributeInsideInclude(elem, filename);
            Document subFile = IncludeProcessor.parseIncludeFile(file, parent.getTagName(), required);
            IncludeProcessor.includeFile(file.parent().orElseThrow(() -> new NoSuchElementException(String.valueOf(file) + " has no parent")), subFile.getDocumentElement());
            IncludeProcessor.mergeInto(parent, XML.getChildren((Element)subFile.getDocumentElement()));
            parent.removeChild(elem);
            list = currentElement.getElementsByTagNameNS("properties", "include");
        }
    }

    private static void ckeckForDeployAttributeInsideInclude(Element elem, String filename) {
        NamedNodeMap attributes = elem.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node item = attributes.item(i);
            String nodeName = item.getNodeName();
            if (!nodeName.startsWith("deploy:")) continue;
            throw new IllegalArgumentException("Using '" + nodeName + "' within a 'preprocess:include' is not supported: 'preprocess:include file=" + filename + ", please use " + nodeName + " in the included file instead");
        }
    }

    private static void mergeInto(Element destination, List<Element> subElements) {
        for (Element subElement : subElements) {
            Node copiedNode = destination.getOwnerDocument().importNode(subElement, true);
            destination.appendChild(copiedNode);
        }
    }

    private static Document parseIncludeFile(FileSystemWrapper.FileWrapper file, String parentTagName, boolean required) throws IOException {
        StringWriter w = new StringWriter();
        String startTag = "<" + parentTagName + " xmlns:deploy='vespa' xmlns:preprocess='properties'>";
        w.append(startTag);
        if (file.exists() || required) {
            w.append(new String(file.content(), StandardCharsets.UTF_8));
        }
        String endTag = "</" + parentTagName + ">";
        w.append(endTag);
        return XML.getDocument((Reader)new StringReader(w.toString()));
    }
}

