/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public record FileReference(String value) {
    public FileReference {
        Objects.requireNonNull(value);
        if (Path.of(value, new String[0]).normalize().startsWith("..")) {
            throw new IllegalArgumentException("Path may not start with '..' but got '" + value + "'");
        }
    }

    @Override
    public String toString() {
        return "file '" + this.value + "'";
    }

    public static List<String> toValues(Collection<FileReference> references) {
        ArrayList<String> ret = new ArrayList<String>();
        for (FileReference r : references) {
            ret.add(r.value());
        }
        return ret;
    }

    public static Map<String, String> toValueMap(Map<String, FileReference> map) {
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        for (Map.Entry<String, FileReference> e : map.entrySet()) {
            ret.put(e.getKey(), e.getValue().value());
        }
        return ret;
    }

    public static FileReference mockFileReferenceForUnitTesting(File file) {
        if (!file.exists()) {
            throw new IllegalArgumentException("File '" + file.getAbsolutePath() + "' does not exist.");
        }
        return new FileReference(file.getPath());
    }
}

