/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config;

import com.yahoo.config.LeafNode;
import com.yahoo.config.text.StringUtilities;

public class StringNode
extends LeafNode<String> {
    public StringNode() {
    }

    public StringNode(String value) {
        super(true);
        this.value = value;
    }

    @Override
    public String value() {
        return (String)this.value;
    }

    @Override
    public String getValue() {
        return this.value();
    }

    @Override
    public String toString() {
        return this.value == null ? "(null)" : "\"" + StringUtilities.escape(this.getValue()) + "\"";
    }

    public static String unescapeQuotedString(String string) {
        StringBuilder sb = new StringBuilder(string);
        block8: for (int i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) != '\\') continue;
            sb.deleteCharAt(i);
            if (i == sb.length()) {
                throw new IllegalArgumentException("Parse error" + string);
            }
            switch (sb.charAt(i)) {
                case 'n': {
                    sb.setCharAt(i, '\n');
                    continue block8;
                }
                case 'r': {
                    sb.setCharAt(i, '\r');
                    continue block8;
                }
                case 't': {
                    sb.setCharAt(i, '\t');
                    continue block8;
                }
                case 'f': {
                    sb.setCharAt(i, '\f');
                    continue block8;
                }
                case 'x': {
                    if (i + 2 >= sb.length()) {
                        throw new IllegalArgumentException("Could not parse hex value " + string);
                    }
                    sb.setCharAt(i, (char)Integer.parseInt(sb.substring(i + 1, i + 3), 16));
                    sb.delete(i + 1, i + 3);
                    continue block8;
                }
                case '\\': {
                    sb.setCharAt(i, '\\');
                }
            }
        }
        if (sb.length() > 0 && sb.charAt(0) == '\"' && sb.charAt(sb.length() - 1) == '\"') {
            sb.deleteCharAt(sb.length() - 1);
            if (sb.length() > 0) {
                sb.deleteCharAt(0);
            }
        }
        return sb.toString();
    }

    @Override
    protected boolean doSetValue(String value) {
        this.value = value.startsWith("\"") && value.endsWith("\"") ? StringNode.unescapeQuotedString(value) : value;
        return true;
    }
}

