/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.ArrayDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.document.MapDataType;
import com.yahoo.document.PrimitiveDataType;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.SDField;
import com.yahoo.schema.processing.Processor;
import com.yahoo.vespa.model.container.search.QueryProfiles;

public class DisallowComplexMapAndWsetKeyTypes
extends Processor {
    public DisallowComplexMapAndWsetKeyTypes(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        if (!validate) {
            return;
        }
        for (SDField field : this.schema.allConcreteFields()) {
            this.checkFieldType(field, field.getDataType());
        }
    }

    private void checkFieldType(Field field, DataType dataType) {
        if (dataType instanceof ArrayDataType) {
            DataType nestedType = ((ArrayDataType)dataType).getNestedType();
            this.checkFieldType(field, nestedType);
        } else if (dataType instanceof WeightedSetDataType) {
            DataType nestedType = ((WeightedSetDataType)dataType).getNestedType();
            if (!(nestedType instanceof PrimitiveDataType)) {
                this.fail(this.schema, field, "Weighted set must have a primitive key type.");
            }
        } else if (dataType instanceof MapDataType) {
            DataType keyType = ((MapDataType)dataType).getKeyType();
            if (!(keyType instanceof PrimitiveDataType)) {
                this.fail(this.schema, field, "Map key type must be a primitive type.");
            }
            this.checkFieldType(field, ((MapDataType)dataType).getValueType());
        }
    }
}

