/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.schema.RankProfile;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.Attribute;
import com.yahoo.schema.processing.MatchPhaseSettingsValidator;
import com.yahoo.schema.processing.Processor;
import com.yahoo.vespa.model.container.search.QueryProfiles;

public class DiversitySettingsValidator
extends Processor {
    public DiversitySettingsValidator(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        if (!validate) {
            return;
        }
        if (documentsOnly) {
            return;
        }
        for (RankProfile rankProfile : this.rankProfileRegistry.rankProfilesOf(this.schema)) {
            if (rankProfile.getMatchPhaseSettings() == null || rankProfile.getMatchPhaseSettings().getDiversity() == null) continue;
            this.validate(rankProfile, rankProfile.getMatchPhaseSettings().getDiversity());
        }
    }

    private void validate(RankProfile rankProfile, RankProfile.DiversitySettings settings) {
        String attributeName = settings.getAttribute();
        new AttributeValidator(this.schema.getName(), rankProfile.name(), this.schema.getAttribute(attributeName), attributeName).validate();
    }

    private static class AttributeValidator
    extends MatchPhaseSettingsValidator.AttributeValidator {
        public AttributeValidator(String searchName, String rankProfileName, Attribute attribute, String attributeName) {
            super(searchName, rankProfileName, attribute, attributeName);
        }

        protected void validateThatAttributeIsSingleAndNotPredicate() {
            if (!this.attribute.getCollectionType().equals((Object)Attribute.CollectionType.SINGLE) || this.attribute.getType().equals((Object)Attribute.Type.PREDICATE)) {
                this.failValidation("must be single value numeric, or enumerated attribute, but it is '" + this.attribute.getDataType().getName() + "'");
            }
        }

        @Override
        public void validate() {
            this.validateThatAttributeExists();
            this.validateThatAttributeIsSingleAndNotPredicate();
        }

        @Override
        public String getValidationType() {
            return "diversity";
        }
    }
}

