/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation;

import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.Validator;
import com.yahoo.vespa.model.container.Container;
import com.yahoo.vespa.model.container.http.ConnectorFactory;
import com.yahoo.vespa.model.container.http.Http;
import com.yahoo.vespa.model.container.http.ssl.DefaultSslProvider;
import com.yahoo.vespa.model.container.http.ssl.HostedSslConnectorFactory;
import java.util.List;

public class CloudHttpConnectorValidator
extends Validator {
    @Override
    public void validate(VespaModel model, DeployState state) {
        if (!state.isHostedTenantApplication(model.getAdmin().getApplicationType())) {
            return;
        }
        model.getContainerClusters().forEach((__, cluster) -> {
            Http http = cluster.getHttp();
            if (http == null) {
                return;
            }
            List<String> illegalConnectors = http.getHttpServer().stream().flatMap(s -> s.getConnectorFactories().stream().filter(c -> !CloudHttpConnectorValidator.isAllowedConnector(c))).map(cf -> "%s@%d".formatted(cf.getName(), cf.getListenPort())).toList();
            if (illegalConnectors.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException("Adding additional or modifying existing HTTPS connectors is not allowed for Vespa Cloud applications. Violating connectors: %s. See https://cloud.vespa.ai/en/security/whitepaper, https://cloud.vespa.ai/en/security/guide#data-plane.".formatted(illegalConnectors));
        });
    }

    private static boolean isAllowedConnector(ConnectorFactory cf) {
        return cf instanceof HostedSslConnectorFactory || cf.getClass().getSimpleName().endsWith("HealthCheckProxyConnector") || cf.getListenPort() == Container.BASEPORT && cf.sslProvider() instanceof DefaultSslProvider;
    }
}

