/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation;

import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.document.select.DocumentSelector;
import com.yahoo.document.select.parser.ParseException;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.Validator;
import com.yahoo.vespa.model.search.IndexedSearchCluster;
import com.yahoo.vespa.model.search.SearchCluster;

public class RoutingSelectorValidator
extends Validator {
    @Override
    public void validate(VespaModel model, DeployState deployState) {
        for (SearchCluster cluster : model.getSearchClusters()) {
            IndexedSearchCluster sc;
            String routingSelector;
            if (!(cluster instanceof IndexedSearchCluster) || (routingSelector = (sc = (IndexedSearchCluster)cluster).getRoutingSelector()) == null) continue;
            try {
                new DocumentSelector(routingSelector);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Failed to parse routing selector for search cluster '" + sc.getClusterName() + "'", e);
            }
        }
    }
}

