/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation.change;

import com.yahoo.config.model.api.ConfigChangeAction;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducerRoot;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.vespa.model.Service;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.change.ChangeValidator;
import com.yahoo.vespa.model.application.validation.change.VespaRestartAction;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public class StartupCommandChangeValidator
implements ChangeValidator {
    @Override
    public List<ConfigChangeAction> validate(VespaModel currentModel, VespaModel nextModel, DeployState deployState) {
        return this.findServicesWithChangedStartupCommand(currentModel, nextModel).toList();
    }

    public Stream<ConfigChangeAction> findServicesWithChangedStartupCommand(AbstractConfigProducerRoot currentModel, AbstractConfigProducerRoot nextModel) {
        return nextModel.getDescendantServices().stream().map(nextService -> currentModel.getService(nextService.getConfigId()).flatMap(currentService -> this.compareStartupCommand((Service)currentService, (Service)nextService))).filter(Optional::isPresent).map(Optional::get);
    }

    private Optional<ConfigChangeAction> compareStartupCommand(Service currentService, Service nextService) {
        String nextCommand;
        String currentCommand = currentService.getStartupCommand().orElse("");
        if (Objects.equals(currentCommand, nextCommand = nextService.getStartupCommand().orElse(""))) {
            return Optional.empty();
        }
        String message = String.format("Startup command for '%s' has changed.\nNew command: %s\nCurrent command: %s", currentService.getServiceName(), nextCommand, currentCommand);
        return Optional.of(new VespaRestartAction(ClusterSpec.Id.from((String)currentService.getConfigId()), message, currentService.getServiceInfo()));
    }
}

