/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.clients;

import com.yahoo.container.handler.threadpool.ContainerThreadpoolConfig;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.ContainerThreadpool;
import com.yahoo.vespa.model.container.PlatformBundles;
import com.yahoo.vespa.model.container.component.BindingPattern;
import com.yahoo.vespa.model.container.component.Handler;
import com.yahoo.vespa.model.container.component.SystemBindingPattern;
import com.yahoo.vespa.model.container.component.UserBindingPattern;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class ContainerDocumentApi {
    public static final String DOCUMENT_V1_PREFIX = "/document/v1";
    public static final Path VESPACLIENT_CONTAINER_BUNDLE = PlatformBundles.absoluteBundlePath("vespaclient-container-plugin");
    private final boolean ignoreUndefinedFields;

    public ContainerDocumentApi(ContainerCluster<?> cluster, HandlerOptions handlerOptions, boolean ignoreUndefinedFields, Set<Integer> portOverride) {
        this.ignoreUndefinedFields = ignoreUndefinedFields;
        ContainerDocumentApi.addRestApiHandler(cluster, handlerOptions, portOverride);
        ContainerDocumentApi.addFeedHandler(cluster, handlerOptions, portOverride);
        ContainerDocumentApi.addVespaClientContainerBundle(cluster);
    }

    public static void addVespaClientContainerBundle(ContainerCluster<?> c) {
        c.addPlatformBundle(VESPACLIENT_CONTAINER_BUNDLE);
    }

    private static void addFeedHandler(ContainerCluster<?> cluster, HandlerOptions handlerOptions, Set<Integer> portOverride) {
        String bindingSuffix = "/reserved-for-internal-use/feedapi";
        Threadpool executor = new Threadpool("feedapi-handler", handlerOptions.feedApiThreadpoolOptions);
        Handler handler = ContainerDocumentApi.newVespaClientHandler("com.yahoo.vespa.http.server.FeedHandler", bindingSuffix, handlerOptions, executor, portOverride);
        cluster.addComponent(handler);
    }

    private static void addRestApiHandler(ContainerCluster<?> cluster, HandlerOptions handlerOptions, Set<Integer> portOverride) {
        Handler handler = ContainerDocumentApi.newVespaClientHandler("com.yahoo.document.restapi.resource.DocumentV1ApiHandler", "/document/v1/*", handlerOptions, null, portOverride);
        cluster.addComponent(handler);
        Handler oldHandlerDummy = ContainerDocumentApi.createHandler("com.yahoo.document.restapi.resource.RestApi", null);
        cluster.addComponent(oldHandlerDummy);
    }

    public boolean ignoreUndefinedFields() {
        return this.ignoreUndefinedFields;
    }

    private static Handler newVespaClientHandler(String componentId, String bindingSuffix, HandlerOptions handlerOptions, Threadpool executor, Set<Integer> portOverride) {
        Handler handler = ContainerDocumentApi.createHandler(componentId, executor);
        if (handlerOptions.bindings.isEmpty()) {
            handler.addServerBindings(ContainerDocumentApi.bindingPattern(bindingSuffix, portOverride));
            handler.addServerBindings(ContainerDocumentApi.bindingPattern(bindingSuffix + "/", portOverride));
        } else {
            for (String rootBinding : handlerOptions.bindings) {
                String pathWithoutLeadingSlash = bindingSuffix.substring(1);
                handler.addServerBindings(ContainerDocumentApi.userBindingPattern(rootBinding + pathWithoutLeadingSlash, portOverride));
                handler.addServerBindings(ContainerDocumentApi.userBindingPattern(rootBinding + pathWithoutLeadingSlash + "/", portOverride));
            }
        }
        return handler;
    }

    private static List<BindingPattern> bindingPattern(String path, Set<Integer> ports) {
        if (ports.isEmpty()) {
            return List.of(SystemBindingPattern.fromHttpPath(path));
        }
        return ports.stream().map(p -> SystemBindingPattern.fromHttpPortAndPath(p, path)).toList();
    }

    private static List<BindingPattern> userBindingPattern(String path, Set<Integer> ports) {
        UserBindingPattern bindingPattern = UserBindingPattern.fromPattern(path);
        if (ports.isEmpty()) {
            return List.of(bindingPattern);
        }
        return ports.stream().map(p -> bindingPattern.withOverriddenPort((int)p)).toList();
    }

    private static Handler createHandler(String className, Threadpool executor) {
        return new Handler(new ComponentModel(className, null, "vespaclient-container-plugin"), executor);
    }

    public static final class HandlerOptions {
        private final Collection<String> bindings;
        private final ContainerThreadpool.UserOptions feedApiThreadpoolOptions;

        public HandlerOptions(Collection<String> bindings, ContainerThreadpool.UserOptions feedApiThreadpoolOptions) {
            this.bindings = Collections.unmodifiableCollection(bindings);
            this.feedApiThreadpoolOptions = feedApiThreadpoolOptions;
        }
    }

    private static class Threadpool
    extends ContainerThreadpool {
        Threadpool(String name, ContainerThreadpool.UserOptions threadpoolOptions) {
            super(name, threadpoolOptions);
        }

        @Override
        protected void setDefaultConfigValues(ContainerThreadpoolConfig.Builder builder) {
            builder.maxThreads(-4).minThreads(-4).queueSize(500);
        }
    }
}

